/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.level.feature.mansion;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import party.lemons.biomemakeover.level.feature.mansion.LayoutType;
import party.lemons.biomemakeover.level.feature.mansion.RoomType;
import party.lemons.biomemakeover.level.feature.mansion.processor.CorridorReplaceProcessor;
import party.lemons.biomemakeover.level.feature.mansion.processor.FloorRoomReplaceProcessor;
import party.lemons.biomemakeover.level.feature.mansion.processor.GardenRoomReplaceProcessor;
import party.lemons.biomemakeover.level.feature.mansion.room.BigMansionRoom;
import party.lemons.biomemakeover.level.feature.mansion.room.BossRoom;
import party.lemons.biomemakeover.level.feature.mansion.room.DungeonRoom;
import party.lemons.biomemakeover.level.feature.mansion.room.EntranceRoom;
import party.lemons.biomemakeover.level.feature.mansion.room.MansionRoom;
import party.lemons.biomemakeover.level.feature.mansion.room.RoofMansionRoom;
import party.lemons.biomemakeover.util.BMUtil;
import party.lemons.biomemakeover.util.Grid;
import party.lemons.biomemakeover.util.RandomUtil;

public class MansionLayout {
    protected final Grid<MansionRoom> layout = new Grid();
    protected final List<FloorRoomReplaceProcessor> floorProcessors = Lists.newArrayList();

    public MansionLayout() {
        this.floorProcessors.add(new CorridorReplaceProcessor());
        this.floorProcessors.add(new GardenRoomReplaceProcessor());
    }

    public void generateLayout(Random random, int startY) {
        int floorCorridorTarget = 10 + random.nextInt(5);
        int floors = 4 + random.nextInt(4);
        int floorRoomTarget = floorCorridorTarget - random.nextInt(5);
        ArrayList allRooms = Lists.newArrayList();
        ArrayList corridorStarts = Lists.newArrayList((Object[])new BlockPos.MutableBlockPos[]{new BlockPos.MutableBlockPos(0, 0, 0)});
        for (int floor = 0; floor < floors; ++floor) {
            List<MansionRoom> corridors = this.placeCorridors(floor, floorCorridorTarget, corridorStarts, random);
            allRooms.addAll(corridors.stream().filter(c -> c.getRoomType() != RoomType.CORRIDOR).collect(Collectors.toList()));
            corridors.removeIf(c -> c.getRoomType() != RoomType.CORRIDOR);
            List<Object> rooms = Lists.newArrayList();
            if (corridors.size() > 0) {
                rooms = this.placeRooms(floor, floorRoomTarget, random);
            }
            if (floor < floors - 1 && corridors.size() > 0) {
                corridorStarts.clear();
                for (int i = 0; i < Math.max(1, 1 + random.nextInt(3) - floor); ++i) {
                    MansionRoom stairCase = corridors.get(random.nextInt(corridors.size()));
                    stairCase.setRoomType(RoomType.STAIRS_UP);
                    BlockPos stairPos = stairCase.getPosition().m_7494_();
                    MansionRoom upStairs = new MansionRoom(stairPos, RoomType.STAIRS_DOWN);
                    upStairs.setLayoutType(LayoutType.REQUIRED);
                    this.layout.put(stairPos, upStairs);
                    corridorStarts.add(new BlockPos.MutableBlockPos(stairPos.m_123341_(), stairPos.m_123342_(), stairPos.m_123343_()));
                }
            }
            floorCorridorTarget = (int)((float)floorCorridorTarget / 1.5f);
            floorRoomTarget = (int)((float)floorRoomTarget / 1.5f);
            allRooms.addAll(rooms);
            allRooms.addAll(corridors);
            int size = allRooms.size();
            ArrayList floorRooms = Lists.newArrayList();
            floorRooms.addAll(rooms);
            floorRooms.addAll(corridors);
            block2: for (int i = 0; i < floorRooms.size(); ++i) {
                MansionRoom room = (MansionRoom)floorRooms.get(i);
                if (!room.getRoomType().isReplaceable()) continue;
                for (FloorRoomReplaceProcessor processor : this.floorProcessors) {
                    if (!processor.isValid(random, floor, this.layout, room)) continue;
                    room.active = false;
                    MansionRoom newRoom = processor.getReplaceRoom(room);
                    newRoom.active = true;
                    this.layout.put(room.getPosition(), newRoom);
                    rooms.add(newRoom);
                    continue block2;
                }
            }
            rooms.removeIf(rm -> !rm.active);
            corridors.removeIf(rm -> !rm.active);
            allRooms.removeIf(rm -> !rm.active);
        }
        this.layout.getEntries().forEach(rm -> rm.setLayout(this, random));
        this.layout.getEntries().forEach(rm -> {
            if (rm.getRoomType() == RoomType.CORRIDOR && (random.nextFloat() < 0.3f || rm.getLayout().doorCount() < 2)) {
                rm.setRoomType(RoomType.ROOM);
            }
        });
        allRooms.removeIf(rm -> !rm.active);
        this.createEntrance(random, allRooms);
        this.createDungeon(random, allRooms, startY);
        this.createTowers(random, allRooms);
        this.createBigRooms(random, allRooms);
        Iterator it = allRooms.iterator();
        BlockPos.MutableBlockPos upPos = new BlockPos.MutableBlockPos();
        ArrayList roofs = Lists.newArrayList();
        while (it.hasNext()) {
            MansionRoom rm2 = (MansionRoom)it.next();
            upPos.m_122178_(rm2.getPosition().m_123341_(), rm2.getPosition().m_123342_() + 1, rm2.getPosition().m_123343_());
            if (!rm2.canSupportRoof() || this.layout.contains((BlockPos)upPos)) continue;
            BlockPos immu = upPos.m_7949_();
            RoofMansionRoom roofRoom = new RoofMansionRoom(immu);
            this.layout.put(immu, roofRoom);
            roofs.add(roofRoom);
        }
        roofs.forEach(rm -> rm.setLayout(this, random));
    }

    private void createBigRooms(Random random, List<MansionRoom> allRooms) {
        block0: for (int i = 0; i < allRooms.size(); ++i) {
            MansionRoom currentRoom = allRooms.get(i);
            if (!currentRoom.active || currentRoom.getRoomType() != RoomType.ROOM) continue;
            for (Direction dir : BMUtil.randomOrderedHorizontals()) {
                BlockPos offset = currentRoom.getPosition().m_142300_(dir);
                if (!this.getLayout().contains(offset)) continue;
                MansionRoom offsetRoom = this.getLayout().get(offset);
                if (!offsetRoom.active || offsetRoom.getRoomType() != RoomType.ROOM || !(random.nextFloat() < 0.25f)) continue;
                BigMansionRoom bigRoom = new BigMansionRoom(currentRoom.getPosition(), dir, false);
                BigMansionRoom bigRoomDummy = new BigMansionRoom(offset, dir.m_122424_(), true);
                bigRoom.setLayout(currentRoom);
                bigRoomDummy.setLayout(offsetRoom);
                currentRoom.active = false;
                offsetRoom.active = false;
                this.getLayout().put(currentRoom.getPosition(), bigRoom);
                this.getLayout().put(offset, bigRoomDummy);
                continue block0;
            }
        }
    }

    protected void createEntrance(Random random, List<MansionRoom> allRooms) {
        MansionRoom entranceConnected = null;
        Direction offsetDirection = null;
        List possibleRooms = allRooms.stream().filter(room -> room.getPosition().m_123342_() == 0 && room.getRoomType().hasWalls()).collect(Collectors.toList());
        Collections.shuffle(possibleRooms);
        for (MansionRoom room2 : possibleRooms) {
            Direction outSide;
            if (room2.getPosition().m_123342_() != 0 || !room2.getRoomType().hasWalls() || (outSide = this.getOutsideDirection(room2.getPosition())) == null) continue;
            entranceConnected = room2;
            offsetDirection = outSide;
            break;
        }
        BlockPos entrancePos = entranceConnected.getPosition().m_142300_(offsetDirection);
        EntranceRoom entranceRoom = new EntranceRoom(entrancePos, RoomType.ENTRANCE);
        entranceRoom.getLayout().put(offsetDirection.m_122424_(), true);
        entranceConnected.getLayout().put(offsetDirection, true);
        this.layout.put(entrancePos, entranceRoom);
        allRooms.add(entranceRoom);
    }

    private Direction getOutsideDirection(BlockPos pos) {
        if (this.layout.getMinX() == pos.m_123341_()) {
            return Direction.WEST;
        }
        if (this.layout.getMaxX() == pos.m_123341_()) {
            return Direction.EAST;
        }
        if (this.layout.getMinZ() == pos.m_123343_()) {
            return Direction.NORTH;
        }
        if (this.layout.getMaxZ() == pos.m_123343_()) {
            return Direction.SOUTH;
        }
        return null;
    }

    protected void createTowers(Random random, List<MansionRoom> allRooms) {
        int maxTowers = 3;
        int maxTowerHeight = 3;
        for (int i = 1; i < 3; ++i) {
            MansionRoom room = allRooms.get(random.nextInt(allRooms.size()));
            if (!room.canSupportRoof()) continue;
            while (this.layout.contains(room.getPosition().m_7494_())) {
                room = this.layout.get(room.getPosition().m_7494_());
            }
            if (!room.getRoomType().isReplaceable()) continue;
            room.setRoomType(RoomType.TOWER_BASE);
            BlockPos towerPos = room.getPosition().m_7494_();
            int height = 1 + random.nextInt(3);
            for (int t = 0; t < height; ++t) {
                this.layout.put(towerPos, new MansionRoom(towerPos, RoomType.TOWER_MID));
                towerPos = towerPos.m_7494_();
            }
            this.layout.put(towerPos, new MansionRoom(towerPos, RoomType.TOWER_TOP));
        }
    }

    protected void createDungeon(Random random, List<MansionRoom> allRooms, int startY) {
        MansionRoom dungeonStairs;
        int maxY = 30;
        int downStep = 7;
        while ((dungeonStairs = allRooms.get(random.nextInt(allRooms.size()))).getPosition().m_123342_() != 0 || !dungeonStairs.getRoomType().isReplaceable()) {
        }
        dungeonStairs.setRoomType(RoomType.DUNGEON_STAIRS_TOP);
        float downDiff = startY - 30;
        int amt = (int)Math.floor(downDiff / 7.0f);
        BlockPos dungeonPos = dungeonStairs.getPosition().m_7495_();
        for (int i = 0; i < amt - 1; ++i) {
            MansionRoom dungeonStairsMid = new MansionRoom(dungeonPos, RoomType.DUNGEON_STAIRS_MID);
            this.layout.put(dungeonPos, dungeonStairsMid);
            dungeonPos = dungeonPos.m_7495_();
        }
        DungeonRoom dungeonStairsBottom = new DungeonRoom(dungeonPos, RoomType.DUNGEON_STAIRS_BOTTOM);
        this.layout.put(dungeonPos, dungeonStairsBottom);
        BlockPos dungeonStart = new BlockPos((Vec3i)dungeonPos);
        Direction bossDir = BMUtil.randomHorizontal();
        ArrayList dungeonRooms = Lists.newArrayList();
        dungeonRooms.add(dungeonStairsBottom);
        int dungeonCorridorLength = RandomUtil.randomRange(4, 6);
        for (int i = 1; i < dungeonCorridorLength; ++i) {
            BlockPos roomPos = dungeonStart.m_5484_(bossDir, i);
            DungeonRoom room = new DungeonRoom(roomPos, RoomType.DUNGEON_ROOM);
            room.setLayoutType(LayoutType.REQUIRED);
            room.getLayout().put(bossDir, true);
            this.layout.put(roomPos, room);
            dungeonRooms.add(room);
        }
        BlockPos bossPos = dungeonStart.m_5484_(bossDir, dungeonCorridorLength + 1);
        BossRoom bossRoom = new BossRoom(bossPos);
        bossRoom.getLayout().put(bossDir.m_122424_(), true);
        this.layout.put(bossPos, bossRoom);
        for (int i = 0; i < 10; ++i) {
            Direction dir;
            MansionRoom rm2;
            while ((rm2 = (MansionRoom)dungeonRooms.get(random.nextInt(dungeonRooms.size()))).getPosition().equals((Object)dungeonPos.m_5484_(bossDir, dungeonCorridorLength - 1))) {
            }
            while ((dir = BMUtil.randomHorizontal()) == bossDir || dir == bossDir.m_122424_()) {
            }
            BlockPos offPos = rm2.getPosition().m_142300_(dir);
            if (this.layout.contains(offPos)) continue;
            DungeonRoom offsetRoom = new DungeonRoom(offPos, RoomType.DUNGEON_ROOM);
            offsetRoom.setLayoutType(LayoutType.REQUIRED);
            this.layout.put(offPos, offsetRoom);
            dungeonRooms.add(offsetRoom);
        }
        dungeonRooms.forEach(rm -> rm.setLayout(this, random));
    }

    public List<MansionRoom> placeCorridors(int y, int maxCount, List<BlockPos.MutableBlockPos> positions, Random random) {
        int attempts = 20;
        int placed = 0;
        ArrayList corridors = Lists.newArrayList();
        for (BlockPos blockPos : positions) {
            MansionRoom room = this.layout.get(blockPos.m_7949_());
            if (room == null) continue;
            corridors.add(room);
        }
        BlockPos.MutableBlockPos pos = y == 0 ? positions.get(0) : ((MansionRoom)corridors.get(random.nextInt(corridors.size()))).getPosition().m_122032_();
        while (placed < maxCount && attempts > 0) {
            if (!this.layout.contains((BlockPos)pos)) {
                attempts = 20;
                if (y != 0 && !this.layout.contains(pos.m_7495_())) {
                    this.setNextPos(corridors, random, y, pos);
                    continue;
                }
                if (y == 0 || this.layout.get(pos.m_7495_()).canSupportRoof()) {
                    MansionRoom mansionRoom = new MansionRoom(pos.m_7949_(), RoomType.CORRIDOR);
                    mansionRoom.setLayoutType(LayoutType.REQUIRED);
                    this.layout.put(pos.m_7949_(), mansionRoom);
                    corridors.add(mansionRoom);
                    ++placed;
                }
            }
            this.setNextPos(corridors, random, y, pos);
            --attempts;
        }
        return corridors;
    }

    private void setNextPos(List<MansionRoom> corridors, Random random, int y, BlockPos.MutableBlockPos pos) {
        BlockPos nextPos;
        BlockPos checkPos = nextPos = corridors.get(random.nextInt(corridors.size())).getPosition();
        for (Direction dir : BMUtil.randomOrderedHorizontals()) {
            checkPos = nextPos.m_142300_(dir);
            if (y != 0 && (!this.layout.contains(checkPos.m_7495_()) || !this.layout.get(checkPos.m_7495_()).canSupportRoof())) continue;
            break;
        }
        pos.m_122178_(checkPos.m_123341_(), checkPos.m_123342_(), checkPos.m_123343_());
    }

    public List<MansionRoom> placeRooms(int y, int maxCount, Random random) {
        int roomsPlaced = 0;
        int roomTarget = maxCount;
        int attempts = 500;
        ArrayList rooms = Lists.newArrayList();
        BlockPos lastSuccess = null;
        while (attempts > 0 && roomsPlaced < roomTarget) {
            BlockPos.MutableBlockPos randomPos = new BlockPos.MutableBlockPos(RandomUtil.randomRange(this.layout.getMinX(), this.layout.getMaxX()), y, RandomUtil.randomRange(this.layout.getMinZ(), this.layout.getMaxZ()));
            if (lastSuccess != null && random.nextFloat() < 0.1f) {
                randomPos = new BlockPos.MutableBlockPos(lastSuccess.m_123341_(), lastSuccess.m_123342_(), lastSuccess.m_123343_());
            }
            if (this.layout.contains((BlockPos)randomPos)) {
                if (y != 0 && !this.layout.contains(randomPos.m_7495_())) continue;
                MansionRoom existingRoom = this.layout.get((BlockPos)randomPos);
                if (this.layout.contains((BlockPos)(randomPos = randomPos.m_122173_(Direction.m_122407_((int)random.nextInt(4))))) || y != 0 && (!this.layout.contains(randomPos.m_7495_()) || !this.layout.get(randomPos.m_7495_()).canSupportRoof())) continue;
                MansionRoom newRoom = new MansionRoom(randomPos.m_7949_(), RoomType.ROOM);
                this.layout.put((BlockPos)randomPos, newRoom);
                if (existingRoom.getRoomType() == RoomType.ROOM) {
                    newRoom.setLayoutType(LayoutType.REQUIRED);
                }
                rooms.add(newRoom);
                ++roomsPlaced;
                lastSuccess = new BlockPos(randomPos.m_123341_(), randomPos.m_123342_(), randomPos.m_123343_());
                continue;
            }
            --attempts;
        }
        return rooms;
    }

    public Grid<MansionRoom> getLayout() {
        return this.layout;
    }
}

