/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.level.feature.foliage;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import party.lemons.biomemakeover.init.BMFeatures;

public class WillowFoliagePlacer
extends FoliagePlacer {
    protected final int height;
    protected final boolean doWillows;
    public static final Codec<WillowFoliagePlacer> CODEC = RecordCodecBuilder.create(instance -> WillowFoliagePlacer.buildCodec(instance).apply((Applicative)instance, WillowFoliagePlacer::new));

    public WillowFoliagePlacer(IntProvider radius, IntProvider offset, int height, boolean doWillows) {
        super(radius, offset);
        this.height = height;
        this.doWillows = doWillows;
    }

    protected FoliagePlacerType<?> m_5897_() {
        return BMFeatures.WILLOW_FOLIAGE.get();
    }

    protected void m_142539_(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> biConsumer, Random random, TreeConfiguration treeConfiguration, int trunkHeight, FoliagePlacer.FoliageAttachment attachment, int foliageHeight, int radius, int offset) {
        BoundingBox box = new BoundingBox(attachment.m_161451_());
        for (int placeOffset = offset; placeOffset >= offset - foliageHeight; --placeOffset) {
            int baseHeight = attachment.m_68589_() > 0 ? Math.max(radius + attachment.m_68589_() - 1 - placeOffset / 2, 0) : Math.max(radius + attachment.m_68589_() - placeOffset / 2, 0);
            this.placeLeavesRow(level, biConsumer, random, treeConfiguration, attachment.m_161451_(), baseHeight, placeOffset, attachment.m_68590_(), box);
        }
    }

    protected void placeLeavesRow(LevelSimulatedReader levelSimulatedReader, BiConsumer<BlockPos, BlockState> biConsumer, Random random, TreeConfiguration treeConfiguration, BlockPos blockPos, int i, int j, boolean bl, BoundingBox box) {
        int k = bl ? 1 : 0;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int l = -i; l <= i + k; ++l) {
            for (int m = -i; m <= i + k; ++m) {
                if (this.m_7395_(random, l, j, m, i, bl)) continue;
                mutableBlockPos.m_122154_((Vec3i)blockPos, l, j, m);
                FoliagePlacer.m_161431_((LevelSimulatedReader)levelSimulatedReader, biConsumer, (Random)random, (TreeConfiguration)treeConfiguration, (BlockPos)mutableBlockPos);
                box.m_162371_(new BlockPos((Vec3i)mutableBlockPos));
            }
        }
    }

    public int m_5969_(Random random, int i, TreeConfiguration treeConfiguration) {
        return this.height;
    }

    protected boolean m_7394_(Random random, int baseHeight, int dx, int dy, int dz, boolean giantTrunk) {
        if (baseHeight + dy >= 4) {
            return true;
        }
        return baseHeight * baseHeight + dy * dy > dz * dz;
    }

    protected static <P extends WillowFoliagePlacer> Products.P4<RecordCodecBuilder.Mu<P>, IntProvider, IntProvider, Integer, Boolean> buildCodec(RecordCodecBuilder.Instance<P> instance) {
        return WillowFoliagePlacer.m_68573_(instance).and((App)Codec.intRange((int)0, (int)16).fieldOf("height").forGetter(cdc -> cdc.height)).and((App)Codec.BOOL.fieldOf("doWillows").forGetter(cdc -> cdc.doWillows));
    }
}

