/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.level.feature.foliage;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import party.lemons.biomemakeover.init.BMWorldGen;
import party.lemons.biomemakeover.util.HorizontalDirection;

public class CypressTrunkPlacer
extends TrunkPlacer {
    public static final Codec<CypressTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> CypressTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, CypressTrunkPlacer::new));

    public CypressTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
    }

    protected TrunkPlacerType<?> m_7362_() {
        return BMWorldGen.Swamp.CYPRESS_TRUNK;
    }

    public List<FoliagePlacer.FoliageAttachment> m_142625_(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> biConsumer, Random random, int trunkHeight, BlockPos pos, TreeConfiguration treeConfiguration) {
        int i;
        CypressTrunkPlacer.m_161880_((LevelSimulatedReader)level, biConsumer, (Random)random, (BlockPos)pos.m_7495_(), (TreeConfiguration)treeConfiguration);
        ArrayList list = Lists.newArrayList();
        for (i = 0; i < trunkHeight; ++i) {
            CypressTrunkPlacer.m_161893_((LevelSimulatedReader)level, biConsumer, (Random)random, (BlockPos)pos.m_6630_(i), (TreeConfiguration)treeConfiguration);
        }
        list.add(new FoliagePlacer.FoliageAttachment(pos.m_6630_(trunkHeight), 1, true));
        for (i = 0; i < 2 + random.nextInt(6); ++i) {
            HorizontalDirection dir = HorizontalDirection.random(random);
            BlockPos offsetStart = dir.offset(pos);
            for (int j = 0; j < 1 + random.nextInt(8); ++j) {
                CypressTrunkPlacer.m_161893_((LevelSimulatedReader)level, biConsumer, (Random)random, (BlockPos)offsetStart.m_6630_(j), (TreeConfiguration)treeConfiguration);
            }
        }
        for (i = 0; i < 1 + random.nextInt(4); ++i) {
            int offset = 7 + random.nextInt(Math.max(1, trunkHeight - 4));
            Direction dir = Direction.m_122404_((Random)random);
            BlockPos trunkPos = pos.m_142300_(dir).m_6630_(offset);
            CypressTrunkPlacer.setBranch(level, biConsumer, treeConfiguration, random, trunkPos);
            list.add(new FoliagePlacer.FoliageAttachment(trunkPos.m_142300_(dir), 1, false));
        }
        return list;
    }

    protected static boolean setBranch(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> biConsumer, TreeConfiguration treeConfiguration, Random random, BlockPos blockPos) {
        if (TreeFeature.m_67267_((LevelSimulatedReader)level, (BlockPos)blockPos)) {
            CypressTrunkPlacer.m_161893_((LevelSimulatedReader)level, biConsumer, (Random)random, (BlockPos)blockPos, (TreeConfiguration)treeConfiguration);
            return true;
        }
        return false;
    }
}

