/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.level.feature;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.NoiseEffect;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockRotProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.FluidState;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.init.BMWorldGen;
import party.lemons.biomemakeover.util.RandomUtil;

public class SunkenRuinFeature
extends StructureFeature<SunkenRuinFeatureConfig> {
    private static final ResourceLocation[] LARGE_PIECES = new ResourceLocation[]{BiomeMakeover.ID("sunken_ruins/sunken_1"), BiomeMakeover.ID("sunken_ruins/sunken_2"), BiomeMakeover.ID("sunken_ruins/sunken_3")};
    private static final ResourceLocation[] SMALL_PIECES = new ResourceLocation[]{BiomeMakeover.ID("sunken_ruins/sunken_small_1"), BiomeMakeover.ID("sunken_ruins/sunken_small_2"), BiomeMakeover.ID("sunken_ruins/sunken_small_3"), BiomeMakeover.ID("sunken_ruins/sunken_small_4"), BiomeMakeover.ID("sunken_ruins/sunken_small_5"), BiomeMakeover.ID("sunken_ruins/sunken_small_6")};
    private static final ResourceLocation LOOT = BiomeMakeover.ID("sunken_ruin");

    public SunkenRuinFeature(Codec<SunkenRuinFeatureConfig> codec) {
        super(codec, PieceGeneratorSupplier.m_197349_((Predicate)PieceGeneratorSupplier.m_197345_((Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG), SunkenRuinFeature::generatePieces));
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.LOCAL_MODIFICATIONS;
    }

    private static <C extends FeatureConfiguration> void generatePieces(StructurePiecesBuilder builder, PieceGenerator.Context<SunkenRuinFeatureConfig> ctx) {
        BlockPos blockPos = new BlockPos(ctx.f_192705_().m_45604_(), 90, ctx.f_192705_().m_45605_());
        Rotation rotation = Rotation.m_55956_((Random)ctx.f_192708_());
        SunkenRuinFeature.addPieces(ctx.f_192704_(), blockPos, rotation, (StructurePieceAccessor)builder, (Random)ctx.f_192708_(), (SunkenRuinFeatureConfig)ctx.f_197328_());
    }

    public static void addPieces(StructureManager manager, BlockPos blockPos, Rotation rotation, StructurePieceAccessor pieceAccessor, Random random, SunkenRuinFeatureConfig cfg) {
        boolean isLarge = random.nextFloat() <= cfg.largeProbability;
        float f = isLarge ? 0.9f : 0.8f;
        SunkenRuinFeature.addPiece(manager, blockPos, rotation, pieceAccessor, random, cfg, isLarge, f);
        if (isLarge && random.nextFloat() <= cfg.clusterProbability) {
            SunkenRuinFeature.addClusterRuins(manager, random, rotation, blockPos, cfg, pieceAccessor);
        }
    }

    private static void addPiece(StructureManager structureManager, BlockPos blockPos, Rotation rotation, StructurePieceAccessor structurePieceAccessor, Random random, SunkenRuinFeatureConfig oceanRuinConfiguration, boolean bl, float f) {
        ResourceLocation resourceLocation = bl ? LARGE_PIECES[random.nextInt(LARGE_PIECES.length)] : SMALL_PIECES[random.nextInt(SMALL_PIECES.length)];
        structurePieceAccessor.m_142679_((StructurePiece)new SunkenRuinPiece(structureManager, resourceLocation, blockPos, rotation, 1.0f, bl));
    }

    private static void addClusterRuins(StructureManager structureManager, Random random, Rotation rotation, BlockPos blockPos, SunkenRuinFeatureConfig oceanRuinConfiguration, StructurePieceAccessor structurePieceAccessor) {
        BlockPos blockPos2 = new BlockPos(blockPos.m_123341_(), 90, blockPos.m_123343_());
        BlockPos blockPos3 = StructureTemplate.m_74593_((BlockPos)new BlockPos(15, 0, 15), (Mirror)Mirror.NONE, (Rotation)rotation, (BlockPos)BlockPos.f_121853_).m_141952_((Vec3i)blockPos2);
        BoundingBox boundingBox = BoundingBox.m_162375_((Vec3i)blockPos2, (Vec3i)blockPos3);
        BlockPos blockPos4 = new BlockPos(Math.min(blockPos2.m_123341_(), blockPos3.m_123341_()), blockPos2.m_123342_(), Math.min(blockPos2.m_123343_(), blockPos3.m_123343_()));
        List<BlockPos> list = SunkenRuinFeature.allPositions(random, blockPos4);
        int i = Mth.m_14072_((Random)random, (int)4, (int)8);
        for (int j = 0; j < i; ++j) {
            Rotation rotation2;
            BlockPos blockPos6;
            int k;
            BlockPos blockPos5;
            BoundingBox boundingBox2;
            if (list.isEmpty() || (boundingBox2 = BoundingBox.m_162375_((Vec3i)(blockPos5 = list.remove(k = random.nextInt(list.size()))), (Vec3i)(blockPos6 = StructureTemplate.m_74593_((BlockPos)new BlockPos(5, 0, 6), (Mirror)Mirror.NONE, (Rotation)(rotation2 = Rotation.m_55956_((Random)random)), (BlockPos)BlockPos.f_121853_).m_141952_((Vec3i)blockPos5)))).m_71049_(boundingBox)) continue;
            SunkenRuinFeature.addPiece(structureManager, blockPos5, rotation2, structurePieceAccessor, random, oceanRuinConfiguration, false, 1.0f);
        }
    }

    private static List<BlockPos> allPositions(Random random, BlockPos blockPos) {
        ArrayList list = Lists.newArrayList();
        list.add(blockPos.m_142082_(-16 + Mth.m_14072_((Random)random, (int)1, (int)8), 0, 16 + Mth.m_14072_((Random)random, (int)1, (int)7)));
        list.add(blockPos.m_142082_(-16 + Mth.m_14072_((Random)random, (int)1, (int)8), 0, Mth.m_14072_((Random)random, (int)1, (int)7)));
        list.add(blockPos.m_142082_(-16 + Mth.m_14072_((Random)random, (int)1, (int)8), 0, -16 + Mth.m_14072_((Random)random, (int)4, (int)8)));
        list.add(blockPos.m_142082_(Mth.m_14072_((Random)random, (int)1, (int)7), 0, 16 + Mth.m_14072_((Random)random, (int)1, (int)7)));
        list.add(blockPos.m_142082_(Mth.m_14072_((Random)random, (int)1, (int)7), 0, -16 + Mth.m_14072_((Random)random, (int)4, (int)6)));
        list.add(blockPos.m_142082_(16 + Mth.m_14072_((Random)random, (int)1, (int)7), 0, 16 + Mth.m_14072_((Random)random, (int)3, (int)8)));
        list.add(blockPos.m_142082_(16 + Mth.m_14072_((Random)random, (int)1, (int)7), 0, Mth.m_14072_((Random)random, (int)1, (int)7)));
        list.add(blockPos.m_142082_(16 + Mth.m_14072_((Random)random, (int)1, (int)7), 0, -16 + Mth.m_14072_((Random)random, (int)4, (int)8)));
        return list;
    }

    public static class SunkenRuinFeatureConfig
    implements FeatureConfiguration {
        public static final Codec<SunkenRuinFeatureConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("large_probability").forGetter(cfg -> Float.valueOf(cfg.largeProbability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("cluster_probability").forGetter(cfg -> Float.valueOf(cfg.clusterProbability))).apply((Applicative)instance, SunkenRuinFeatureConfig::new));
        public final float largeProbability;
        public final float clusterProbability;

        public SunkenRuinFeatureConfig(float largeProbability, float clusterProbability) {
            this.largeProbability = largeProbability;
            this.clusterProbability = clusterProbability;
        }
    }

    public static class SunkenRuinPiece
    extends TemplateStructurePiece {
        private final float integrity;
        private final boolean isLarge;

        public SunkenRuinPiece(StructureManager structureManager, ResourceLocation resourceLocation, BlockPos blockPos, Rotation rotation, float f, boolean bl) {
            super(BMWorldGen.Swamp.SUNKEN_RUIN_PIECE, 0, structureManager, resourceLocation, resourceLocation.toString(), SunkenRuinPiece.makeSettings(rotation), blockPos);
            this.integrity = f;
            this.isLarge = bl;
        }

        public SunkenRuinPiece(StructureManager structureManager, CompoundTag compoundTag) {
            super(BMWorldGen.Swamp.SUNKEN_RUIN_PIECE, compoundTag, structureManager, resourceLocation -> SunkenRuinPiece.makeSettings(Rotation.valueOf((String)compoundTag.m_128461_("Rot"))));
            this.integrity = compoundTag.m_128457_("Integrity");
            this.isLarge = compoundTag.m_128471_("IsLarge");
        }

        public SunkenRuinPiece(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag compoundTag) {
            super(BMWorldGen.Swamp.SUNKEN_RUIN_PIECE, compoundTag, structurePieceSerializationContext.f_192764_(), resourceLocation -> SunkenRuinPiece.makeSettings(Rotation.valueOf((String)compoundTag.m_128461_("Rot"))));
            this.integrity = compoundTag.m_128457_("Integrity");
            this.isLarge = compoundTag.m_128471_("IsLarge");
        }

        private static StructurePlaceSettings makeSettings(Rotation rotation) {
            return new StructurePlaceSettings().m_74379_(rotation).m_74377_(Mirror.NONE).m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74048_);
        }

        public NoiseEffect m_142318_() {
            return NoiseEffect.BURY;
        }

        protected void m_183620_(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag compoundTag) {
            super.m_183620_(structurePieceSerializationContext, compoundTag);
            compoundTag.m_128359_("Rot", this.f_73657_.m_74404_().name());
            compoundTag.m_128350_("Integrity", this.integrity);
            compoundTag.m_128379_("IsLarge", this.isLarge);
        }

        protected void m_7756_(String metadata, BlockPos pos, ServerLevelAccessor level, Random random, BoundingBox boundingBox) {
            if ("chest".equals(metadata)) {
                level.m_7731_(pos, (BlockState)Blocks.f_50087_.m_49966_().m_61124_((Property)ChestBlock.f_51480_, (Comparable)Boolean.valueOf(level.m_6425_(pos).m_205070_(FluidTags.f_13131_))), 2);
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof ChestBlockEntity) {
                    ((ChestBlockEntity)blockEntity).m_59626_(LOOT, random.nextLong());
                }
            } else if ("witch".equals(metadata) && random.nextBoolean() && level.m_8055_(pos.m_7494_()).m_60795_()) {
                Witch witch = (Witch)EntityType.f_20495_.m_20615_((Level)level.m_6018_());
                witch.m_21530_();
                witch.m_20035_(pos, 0.0f, 0.0f);
                witch.m_6518_(level, level.m_6436_(pos), MobSpawnType.STRUCTURE, null, null);
                level.m_47205_((Entity)witch);
                if (pos.m_123342_() >= level.m_5736_()) {
                    level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
                } else {
                    level.m_7731_(pos, Blocks.f_49990_.m_49966_(), 2);
                }
            }
        }

        public void m_183269_(WorldGenLevel worldGenLevel, StructureFeatureManager structureFeatureManager, ChunkGenerator chunkGenerator, Random random, BoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            this.f_73657_.m_74394_().m_74383_((StructureProcessor)new BlockRotProcessor(this.integrity)).m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74048_);
            int i = worldGenLevel.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, this.f_73658_.m_123341_(), this.f_73658_.m_123343_()) - RandomUtil.randomRange(1, 4);
            this.f_73658_ = new BlockPos(this.f_73658_.m_123341_(), i, this.f_73658_.m_123343_());
            BlockPos blockPos2 = StructureTemplate.m_74593_((BlockPos)new BlockPos(this.f_73656_.m_163801_().m_123341_() - 1, 0, this.f_73656_.m_163801_().m_123343_() - 1), (Mirror)Mirror.NONE, (Rotation)this.f_73657_.m_74404_(), (BlockPos)BlockPos.f_121853_).m_141952_((Vec3i)this.f_73658_);
            this.f_73658_ = new BlockPos(this.f_73658_.m_123341_(), this.getHeight(this.f_73658_, (BlockGetter)worldGenLevel, blockPos2), this.f_73658_.m_123343_());
            super.m_183269_(worldGenLevel, structureFeatureManager, chunkGenerator, random, boundingBox, chunkPos, blockPos);
        }

        private int getHeight(BlockPos blockPos, BlockGetter blockGetter, BlockPos blockPos2) {
            int i = blockPos.m_123342_();
            int j = 512;
            int k = i - 1;
            int l = 0;
            for (BlockPos blockPos3 : BlockPos.m_121940_((BlockPos)blockPos, (BlockPos)blockPos2)) {
                int m = blockPos3.m_123341_();
                int n = blockPos3.m_123343_();
                int o = blockPos.m_123342_() - 1;
                BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(m, o, n);
                BlockState blockState = blockGetter.m_8055_((BlockPos)mutableBlockPos);
                FluidState fluidState = blockGetter.m_6425_((BlockPos)mutableBlockPos);
                while ((blockState.m_60795_() || fluidState.m_205070_(FluidTags.f_13131_) || blockState.m_204336_(BlockTags.f_13047_)) && o > blockGetter.m_141937_() + 1) {
                    mutableBlockPos.m_122178_(m, --o, n);
                    blockState = blockGetter.m_8055_((BlockPos)mutableBlockPos);
                    fluidState = blockGetter.m_6425_((BlockPos)mutableBlockPos);
                }
                j = Math.min(j, o);
                if (o >= k - 2) continue;
                ++l;
            }
            int p = Math.abs(blockPos.m_123341_() - blockPos2.m_123341_());
            if (k - j > 2 && l > p - 2) {
                i = j + 1;
            }
            return i;
        }
    }
}

