/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.level;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import party.lemons.biomemakeover.init.BMEffects;
import party.lemons.biomemakeover.network.S2C_DoPoltergeistParticle;

public class PoltergeistHandler {
    private static final Map<TagKey<Block>, PoltergeistBehaviour> BEHAVIOUR_TAG = Maps.newHashMap();
    private static final Map<Block, PoltergeistBehaviour> BEHAVIOUR_BLOCK = Maps.newHashMap();

    public static void doPoltergeist(Level level, BlockPos pos, int range) {
        int volume = range * range * range;
        int geistIndex = level.f_46441_.nextInt(volume);
        int half = range / 2;
        int pZ = geistIndex % range;
        int pY = geistIndex / range % range;
        int pX = geistIndex / (range * range);
        BlockPos checkPos = new BlockPos((pX += pos.m_123341_()) - half, (pY += pos.m_123342_()) - half, (pZ += pos.m_123343_()) - half);
        if (PoltergeistHandler.doBehaviour(level, checkPos)) {
            Random random = level.f_46441_;
            PoltergeistHandler.doParticles(level, checkPos);
            float pitch = random.nextFloat() * 0.4f + random.nextFloat() > 0.9f ? 0.6f : 0.0f;
            level.m_5594_(null, pos, BMEffects.POLTERGEIST_ACTION.get(), SoundSource.BLOCKS, pitch, 0.6f + random.nextFloat() * 0.4f);
        }
    }

    public static void doParticles(Level world, BlockPos pos) {
        new S2C_DoPoltergeistParticle(pos).sendToChunkListeners(world.m_46745_(pos));
    }

    public static boolean doBehaviour(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        Block bl = state.m_60734_();
        if (state.m_60795_() || state.m_60713_(Blocks.f_50069_)) {
            return false;
        }
        if (BEHAVIOUR_BLOCK.containsKey(bl)) {
            return BEHAVIOUR_BLOCK.get(bl).handle(level, pos, state);
        }
        for (TagKey<Block> tag : BEHAVIOUR_TAG.keySet()) {
            if (!state.m_204336_(tag)) continue;
            return BEHAVIOUR_TAG.get(tag).handle(level, pos, state);
        }
        return false;
    }

    public static void registerBehaviour(TagKey<Block> blockTag, PoltergeistBehaviour behaviour) {
        BEHAVIOUR_TAG.put(blockTag, behaviour);
    }

    public static void registerBehaviour(Block block, PoltergeistBehaviour behaviour) {
        BEHAVIOUR_BLOCK.put(block, behaviour);
    }

    public static void init() {
    }

    static {
        PoltergeistHandler.registerBehaviour((TagKey<Block>)BlockTags.f_13103_, (Level w, BlockPos p, BlockState st) -> {
            if (st.m_61143_((Property)DoorBlock.f_52730_) != DoubleBlockHalf.LOWER || st.m_60767_() == Material.f_76279_) {
                return false;
            }
            w.m_7731_(p, (BlockState)st.m_61122_((Property)DoorBlock.f_52727_), 10);
            int sound = (Boolean)st.m_61143_((Property)DoorBlock.f_52727_) != false ? 1012 : 1006;
            w.m_5898_(null, sound, p, 0);
            return true;
        });
        PoltergeistHandler.registerBehaviour((TagKey<Block>)BlockTags.f_13093_, (Level w, BlockPos p, BlockState st) -> {
            if (((Boolean)st.m_61143_((Property)ButtonBlock.f_51045_)).booleanValue()) {
                return false;
            }
            ((ButtonBlock)st.m_60734_()).m_51116_(st, w, p);
            w.m_5594_(null, p, SoundEvents.f_12632_, SoundSource.BLOCKS, 0.3f, 0.6f);
            return true;
        });
        PoltergeistHandler.registerBehaviour((TagKey<Block>)BlockTags.f_13036_, (Level w, BlockPos p, BlockState st) -> {
            if (st.m_60767_() == Material.f_76279_) {
                return false;
            }
            BlockState newState = (BlockState)st.m_61122_((Property)TrapDoorBlock.f_57514_);
            w.m_7731_(p, newState, 2);
            if (((Boolean)newState.m_61143_((Property)TrapDoorBlock.f_57517_)).booleanValue()) {
                w.m_186469_(p, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)w));
            }
            w.m_5898_(null, (Boolean)st.m_61143_((Property)TrapDoorBlock.f_57514_) != false ? 1007 : 1013, p, 0);
            return true;
        });
        PoltergeistHandler.registerBehaviour(Blocks.f_50164_, (Level w, BlockPos p, BlockState st) -> {
            ((LeverBlock)st.m_60734_()).m_54676_(st, w, p);
            float pitch = (Boolean)st.m_61143_((Property)LeverBlock.f_54622_) != false ? 0.6f : 0.5f;
            w.m_5594_(null, p, SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, pitch);
            return true;
        });
        PoltergeistHandler.registerBehaviour(Blocks.f_50065_, (Level w, BlockPos p, BlockState st) -> {
            if (w.m_8055_(p.m_7494_()).m_60795_()) {
                w.m_7696_(p, st.m_60734_(), 0, 0);
                return true;
            }
            return false;
        });
        PoltergeistHandler.registerBehaviour((TagKey<Block>)BlockTags.f_13055_, (Level w, BlockPos p, BlockState st) -> {
            st = (BlockState)st.m_61122_((Property)FenceGateBlock.f_53341_);
            w.m_7731_(p, st, 10);
            w.m_5898_(null, (Boolean)st.m_61143_((Property)FenceGateBlock.f_53341_) != false ? 1008 : 1014, p, 0);
            return true;
        });
        PoltergeistHandler.registerBehaviour(Blocks.f_50680_, (Level w, BlockPos p, BlockState st) -> {
            ((BellBlock)st.m_60734_()).m_49712_(w, p, null);
            return true;
        });
    }

    public static interface PoltergeistBehaviour {
        public boolean handle(Level var1, BlockPos var2, BlockState var3);
    }
}

