/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.init;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import dev.architectury.core.item.ArchitecturySpawnEggItem;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.registry.fuel.FuelRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.block.BMItemNameBlockItem;
import party.lemons.biomemakeover.init.BMBlocks;
import party.lemons.biomemakeover.init.BMEffects;
import party.lemons.biomemakeover.init.BMEntities;
import party.lemons.biomemakeover.item.BMArmorItem;
import party.lemons.biomemakeover.item.BMItem;
import party.lemons.biomemakeover.item.BMMobBucketItem;
import party.lemons.biomemakeover.item.BMRecordItem;
import party.lemons.biomemakeover.item.EctoplasmItem;
import party.lemons.biomemakeover.item.EnchantedTotemItem;
import party.lemons.biomemakeover.item.FakeItem;
import party.lemons.biomemakeover.item.GlowfishBucketItem;
import party.lemons.biomemakeover.item.HatItem;
import party.lemons.biomemakeover.item.LightningBottleItem;
import party.lemons.biomemakeover.item.StuntPowderItem;
import party.lemons.biomemakeover.item.modifier.CompostItemModifier;
import party.lemons.biomemakeover.item.modifier.ItemModifier;

public class BMItems {
    public static final Multimap<Item, ItemModifier> MODIFIERS = ArrayListMultimap.create();
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"biomemakeover", (ResourceKey)Registry.f_122904_);
    public static final FoodProperties GLOWSHROOM_SOUP_FOOD = new FoodProperties.Builder().m_38765_().m_38758_(0.6f).m_38760_(5).m_38762_(new MobEffectInstance(MobEffects.f_19611_, 1200, 0), 1.0f).m_38762_(new MobEffectInstance(MobEffects.f_19619_, 1200, 0), 1.0f).m_38767_();
    public static final FoodProperties GLOWFISH_FOOD = new FoodProperties.Builder().m_38765_().m_38758_(0.1f).m_38760_(1).m_38762_(new MobEffectInstance(MobEffects.f_19611_, 200, 0), 0.5f).m_38762_(new MobEffectInstance(MobEffects.f_19619_, 200, 0), 0.5f).m_38767_();
    public static final FoodProperties COOKED_GLOWFISH_FOOD = new FoodProperties.Builder().m_38765_().m_38758_(0.6f).m_38760_(5).m_38762_(new MobEffectInstance(MobEffects.f_19611_, 200, 0), 0.5f).m_38762_(new MobEffectInstance(MobEffects.f_19619_, 200, 0), 0.5f).m_38767_();
    public static final FoodProperties COOKED_TOAD_FOOD = new FoodProperties.Builder().m_38760_(6).m_38758_(0.6f).m_38757_().m_38767_();
    public static final FoodProperties RAW_TOAD_FOOD = new FoodProperties.Builder().m_38760_(3).m_38758_(0.3f).m_38757_().m_38767_();
    public static final FoodProperties RAW_BULBUS_ROOT_FOOD = new FoodProperties.Builder().m_38760_(2).m_38758_(0.6f).m_38767_();
    public static final FoodProperties BULBUS_ROOT_FOOD = new FoodProperties.Builder().m_38760_(5).m_38758_(0.8f).m_38767_();
    public static final ArmorMaterial CLADDED_MATERIAL = new CladdedArmorMaterial();
    public static final BMArmorItem.Builder CLADDED_ARMOR = BMArmorItem.Builder.create(CLADDED_MATERIAL).attribute("Armor Proj Res", BMEntities.ATT_PROJECTILE_RESISTANCE, 1.0, AttributeModifier.Operation.ADDITION);
    public static final Supplier<Item> GLOWSHROOM_STEW = BMItems.registerItem("glowshroom_stew", () -> new SuspiciousStewItem(BMItems.properties().m_41487_(1).m_41495_(Items.f_42399_).m_41489_(GLOWSHROOM_SOUP_FOOD)));
    public static final Supplier<Item> GLOWFISH = BMItems.registerItem("glowfish", () -> new Item(BMItems.properties().m_41489_(GLOWFISH_FOOD)));
    public static final Supplier<Item> COOKED_GLOWFISH = BMItems.registerItem("cooked_glowfish", () -> new Item(BMItems.properties().m_41489_(COOKED_GLOWFISH_FOOD)));
    public static final Supplier<Item> RAW_TOAD = BMItems.registerItem("raw_toad", () -> new Item(BMItems.properties().m_41489_(RAW_TOAD_FOOD)));
    public static final Supplier<Item> COOKED_TOAD = BMItems.registerItem("cooked_toad", () -> new Item(BMItems.properties().m_41489_(COOKED_TOAD_FOOD)));
    public static final Supplier<Item> BULBUS_ROOT = BMItems.registerItem("bulbus_root", () -> new BMItem(BMItems.properties().m_41489_(RAW_BULBUS_ROOT_FOOD)).modifiers(CompostItemModifier.create(0.4f)));
    public static final Supplier<Item> ROASTED_BULBUS_ROOT = BMItems.registerItem("roasted_bulbus_root", () -> new Item(BMItems.properties().m_41489_(BULBUS_ROOT_FOOD)));
    public static final Supplier<Item> COWBOY_HAT = BMItems.registerItem("cowboy_hat", () -> new HatItem(BiomeMakeover.ID("textures/misc/cowboy_hat.png"), BMItems.properties()));
    public static final Supplier<Item> WITCH_HAT = BMItems.registerItem("witch_hat", () -> new HatItem(BiomeMakeover.ID("textures/misc/witch_hat.png"), BMItems.properties()));
    public static final Supplier<Item> MAGENTA_PETALS = BMItems.registerItem("magenta_petals", () -> new BMItem(BMItems.properties()).modifiers(CompostItemModifier.create(0.3f)));
    public static final Supplier<Item> LIGHT_BLUE_PETALS = BMItems.registerItem("light_blue_petals", () -> new BMItem(BMItems.properties()).modifiers(CompostItemModifier.create(0.3f)));
    public static final Supplier<Item> PINK_PETALS = BMItems.registerItem("pink_petals", () -> new BMItem(BMItems.properties()).modifiers(CompostItemModifier.create(0.3f)));
    public static final Supplier<Item> GRAY_PETALS = BMItems.registerItem("gray_petals", () -> new BMItem(BMItems.properties()).modifiers(CompostItemModifier.create(0.3f)));
    public static final Supplier<Item> CYAN_PETALS = BMItems.registerItem("cyan_petals", () -> new BMItem(BMItems.properties()).modifiers(CompostItemModifier.create(0.3f)));
    public static final Supplier<Item> PURPLE_PETALS = BMItems.registerItem("purple_petals", () -> new BMItem(BMItems.properties()).modifiers(CompostItemModifier.create(0.3f)));
    public static final Supplier<Item> BLUE_PETALS = BMItems.registerItem("blue_petals", () -> new BMItem(BMItems.properties()).modifiers(CompostItemModifier.create(0.3f)));
    public static final Supplier<Item> BROWN_PETALS = BMItems.registerItem("brown_petals", () -> new BMItem(BMItems.properties()).modifiers(CompostItemModifier.create(0.3f)));
    public static final Supplier<Item> SCUTTLER_TAIL = BMItems.registerItem("scuttler_tail", () -> new BMItem(BMItems.properties()));
    public static final Supplier<Item> ECTOPLASM = BMItems.registerItem("ectoplasm", () -> new EctoplasmItem(BMItems.properties()));
    public static final Supplier<Item> LIGHTNING_BOTTLE = BMItems.registerItem("lightning_bottle", () -> new LightningBottleItem(BMItems.properties()));
    public static final Supplier<Item> DRAGONFLY_WINGS = BMItems.registerItem("dragonfly_wings", () -> new Item(BMItems.properties()));
    public static final Supplier<Item> BAT_WING = BMItems.registerItem("bat_wing", () -> new Item(BMItems.properties()));
    public static final Supplier<Item> BLIGHTBAT_WING = BMItems.registerItem("blightbat_wing", () -> new Item(BMItems.properties()));
    public static final Supplier<Item> WART = BMItems.registerItem("wart", () -> new Item(BMItems.properties()));
    public static final Supplier<Item> SOUL_EMBERS = BMItems.registerItem("soul_embers", () -> new Item(BMItems.properties()));
    public static final Supplier<Item> ILLUNITE_SHARD = BMItems.registerItem("illunite_shard", () -> new Item(BMItems.properties()));
    public static final Supplier<Item> ROOTLING_SEEDS = BMItems.registerItem("rootling_seeds", () -> new BMItemNameBlockItem(BMBlocks.ROOTLING_CROP.get(), BMItems.properties()).modifiers(CompostItemModifier.create(0.4f)));
    public static final Supplier<Item> MOTH_SCALES = BMItems.registerItem("moth_scales", () -> new Item(BMItems.properties()));
    public static final Supplier<Item> STUNT_POWDER = BMItems.registerItem("stunt_powder", () -> new StuntPowderItem(BMItems.properties()));
    public static final Supplier<Item> CRUDE_CLADDING = BMItems.registerItem("crude_cladding", () -> new Item(BMItems.properties()));
    public static final Supplier<Item> CLADDED_HELMET = BMItems.registerItem("cladded_helmet", CLADDED_ARMOR.build(EquipmentSlot.HEAD, BMItems.properties()));
    public static final Supplier<Item> CLADDED_CHESTPLATE = BMItems.registerItem("cladded_chestplate", CLADDED_ARMOR.build(EquipmentSlot.CHEST, BMItems.properties()));
    public static final Supplier<Item> CLADDED_LEGGINGS = BMItems.registerItem("cladded_leggings", CLADDED_ARMOR.build(EquipmentSlot.LEGS, BMItems.properties()));
    public static final Supplier<Item> CLADDED_BOOTS = BMItems.registerItem("cladded_boots", CLADDED_ARMOR.build(EquipmentSlot.FEET, BMItems.properties()));
    public static final Supplier<Item> ENCHANTED_TOTEM = BMItems.registerItem("enchanted_totem", () -> new EnchantedTotemItem(BMItems.properties().m_41497_(Rarity.EPIC).m_41487_(1)));
    public static final Supplier<Item> BUTTON_MUSHROOMS_MUSIC_DISK = BMItems.registerItem("button_mushrooms_music_disk", () -> new BMRecordItem(14, (Supplier<SoundEvent>)BMEffects.BUTTON_MUSHROOMS, BMItems.properties().m_41487_(1).m_41497_(Rarity.RARE)));
    public static final Supplier<Item> GHOST_TOWN_MUSIC_DISK = BMItems.registerItem("ghost_town_music_disk", () -> new BMRecordItem(15, (Supplier<SoundEvent>)BMEffects.GHOST_TOWN, BMItems.properties().m_41487_(1).m_41497_(Rarity.RARE)));
    public static final Supplier<Item> SWAMP_JIVES_MUSIC_DISK = BMItems.registerItem("swamp_jives_music_disk", () -> new BMRecordItem(1, (Supplier<SoundEvent>)BMEffects.SWAMP_JIVES, BMItems.properties().m_41487_(1).m_41497_(Rarity.RARE)));
    public static final Supplier<Item> RED_ROSE_MUSIC_DISK = BMItems.registerItem("red_rose_music_disk", () -> new BMRecordItem(2, (Supplier<SoundEvent>)BMEffects.RED_ROSE, BMItems.properties().m_41487_(1).m_41497_(Rarity.RARE)));
    public static final Supplier<Item> GLOWFISH_BUCKET = BMItems.registerItem("glowfish_bucket", () -> new GlowfishBucketItem((Supplier)BMEntities.GLOWFISH, (Fluid)Fluids.f_76193_, SoundEvents.f_11779_, BMItems.properties().m_41487_(1)));
    public static final Supplier<Item> TADPOLE_BUCKET = BMItems.registerItem("tadpole_bucket", () -> new BMMobBucketItem((Supplier)BMEntities.TADPOLE, (Fluid)Fluids.f_76193_, SoundEvents.f_11779_, BMItems.properties().m_41487_(1)));
    public static final Supplier<Item> GLOWFISH_SPAWN_EGG = BMItems.registerItem("glowfish_spawn_egg", () -> new ArchitecturySpawnEggItem(BMEntities.GLOWFISH, 16743168, 16766899, BMItems.properties()));
    public static final Supplier<Item> MUSHROOM_TRADER_SPAWN_EGG = BMItems.registerItem("mushroom_trader_spawn_egg", () -> new ArchitecturySpawnEggItem(BMEntities.MUSHROOM_TRADER, 3669760, 11665308, BMItems.properties()));
    public static final Supplier<Item> BLIGHTBAT_SPAWN_EGG = BMItems.registerItem("blightbat_spawn_egg", () -> new ArchitecturySpawnEggItem(BMEntities.BLIGHTBAT, 11403519, 14655484, BMItems.properties()));
    public static final Supplier<Item> GHOST_SPAWN_EGG = BMItems.registerItem("ghost_spawn_egg", () -> new ArchitecturySpawnEggItem(BMEntities.GHOST, 0x566B6B, 11927550, BMItems.properties()));
    public static final Supplier<Item> SCUTTLER_SPAWN_EGG = BMItems.registerItem("scuttler_spawn_egg", () -> new ArchitecturySpawnEggItem(BMEntities.SCUTTLER, 4666407, 8414547, BMItems.properties()));
    public static final Supplier<Item> COWBOY_SPAWN_EGG = BMItems.registerItem("cowboy_spawn_egg", () -> new ArchitecturySpawnEggItem(BMEntities.COWBOY, 10207938, 7028537, BMItems.properties()));
    public static final Supplier<Item> TOAD_SPAWN_EGG = BMItems.registerItem("toad_spawn_egg", () -> new ArchitecturySpawnEggItem(BMEntities.TOAD, 4948562, 6376755, BMItems.properties()));
    public static final Supplier<Item> TADPOLE_SPAWN_EGG = BMItems.registerItem("tadpole_spawn_egg", () -> new ArchitecturySpawnEggItem(BMEntities.TADPOLE, 6783563, 6376755, BMItems.properties()));
    public static final Supplier<Item> DRAGONFLY_SPAWN_EGG = BMItems.registerItem("dragonfly_spawn_egg", () -> new ArchitecturySpawnEggItem(BMEntities.DRAGONFLY, 13088308, 15920054, BMItems.properties()));
    public static final Supplier<Item> LIGHTNING_BUG_SPAWN_EGG = BMItems.registerItem("lightning_bug_spawn_egg", () -> new ArchitecturySpawnEggItem(BMEntities.LIGHTNING_BUG_ALTERNATE, 6474081, 9890785, BMItems.properties()));
    public static final Supplier<Item> DECAYED_SPAWN_EGG = BMItems.registerItem("decayed_spawn_egg", () -> new ArchitecturySpawnEggItem(BMEntities.DECAYED, 3043432, 4866100, BMItems.properties()));
    public static final Supplier<Item> OWL_SPAWN_EGG = BMItems.registerItem("owl_spawn_egg", () -> new ArchitecturySpawnEggItem(BMEntities.OWL, 3157543, 6511689, BMItems.properties()));
    public static final Supplier<Item> ROOTLING_SPAWN_EGG = BMItems.registerItem("rootling_spawn_egg", () -> new ArchitecturySpawnEggItem(BMEntities.ROOTLING, 2828580, 10582815, BMItems.properties()));
    public static final RegistrySupplier<Item> MOTH_SPAWN_EGG = BMItems.registerItem("moth_spawn_egg", () -> new ArchitecturySpawnEggItem(BMEntities.MOTH, 8214169, 9866908, BMItems.properties()));
    public static final Supplier<Item> ICON_ITEM = BMItems.registerItem("icon_item", FakeItem::new);
    public static final TagKey<Item> CURSE_FUEL = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)BiomeMakeover.ID("curse_fuel"));
    public static final TagKey<Item> TOAD_FOOD = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)BiomeMakeover.ID("toad_food"));

    public static void init() {
        BMBlocks.BLOCK_ITEMS.get(BiomeMakeover.ID("dried_peat")).listen(i -> FuelRegistry.register((int)10000, (ItemLike[])new ItemLike[]{i}));
        ITEMS.register();
        LifecycleEvent.SETUP.register(() -> MODIFIERS.forEach((b, a) -> a.accept(b)));
    }

    private static RegistrySupplier<Item> registerItem(String id, Supplier<Item> item) {
        return ITEMS.register(BiomeMakeover.ID(id), item);
    }

    public static Item.Properties properties() {
        return new Item.Properties().m_41491_(BiomeMakeover.TAB);
    }

    private static class CladdedArmorMaterial
    implements ArmorMaterial {
        private CladdedArmorMaterial() {
        }

        public int m_7366_(EquipmentSlot equipmentSlot) {
            return ArmorMaterials.IRON.m_7366_(equipmentSlot);
        }

        public int m_7365_(EquipmentSlot equipmentSlot) {
            return ArmorMaterials.CHAIN.m_7365_(equipmentSlot);
        }

        public int m_6646_() {
            return 15;
        }

        public SoundEvent m_7344_() {
            return ArmorMaterials.LEATHER.m_7344_();
        }

        public Ingredient m_6230_() {
            return ArmorMaterials.LEATHER.m_6230_();
        }

        public String m_6082_() {
            return "cladded";
        }

        public float m_6651_() {
            return 0.0f;
        }

        public float m_6649_() {
            return 0.07f;
        }
    }
}

