/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.init;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.item.WaterLilyBlockItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.material.PushReaction;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.block.AdjudicatorTapestryBlock;
import party.lemons.biomemakeover.block.AdjudicatorTapestryWallBlock;
import party.lemons.biomemakeover.block.AltarBlock;
import party.lemons.biomemakeover.block.BMBlock;
import party.lemons.biomemakeover.block.BMFlowerPotBlock;
import party.lemons.biomemakeover.block.BMLeavesBlock;
import party.lemons.biomemakeover.block.BMMushroomBlock;
import party.lemons.biomemakeover.block.BMSaplingBlock;
import party.lemons.biomemakeover.block.BMSpreadableBlock;
import party.lemons.biomemakeover.block.BMTallFlowerBlock;
import party.lemons.biomemakeover.block.BMTallMushroomBlock;
import party.lemons.biomemakeover.block.BarrelCactusBlock;
import party.lemons.biomemakeover.block.BlackThistleBlock;
import party.lemons.biomemakeover.block.ColorTapestryBlock;
import party.lemons.biomemakeover.block.ColorTapestryWallBlock;
import party.lemons.biomemakeover.block.DirectionalDataBlock;
import party.lemons.biomemakeover.block.EctoplasmComposterBlock;
import party.lemons.biomemakeover.block.FloweredWaterlilyPadBlock;
import party.lemons.biomemakeover.block.GlowshroomPlantBlock;
import party.lemons.biomemakeover.block.IlluniteClusterBlock;
import party.lemons.biomemakeover.block.ItchingIvyBlock;
import party.lemons.biomemakeover.block.IvyBlock;
import party.lemons.biomemakeover.block.LightningBugBottleBlock;
import party.lemons.biomemakeover.block.MothBlossomBlock;
import party.lemons.biomemakeover.block.MushroomRootsBlock;
import party.lemons.biomemakeover.block.MushroomSproutsBlock;
import party.lemons.biomemakeover.block.PeatFarmlandBlock;
import party.lemons.biomemakeover.block.PoltergeistBlock;
import party.lemons.biomemakeover.block.ReedBlock;
import party.lemons.biomemakeover.block.RootlingCropBlock;
import party.lemons.biomemakeover.block.SaguaroCactusBlock;
import party.lemons.biomemakeover.block.SmallLilyPadBlock;
import party.lemons.biomemakeover.block.UnderwaterMushroomPlantBlock;
import party.lemons.biomemakeover.block.WaterSaplingBlock;
import party.lemons.biomemakeover.block.WildMushroomBlock;
import party.lemons.biomemakeover.block.WillowingBranchesBlock;
import party.lemons.biomemakeover.block.modifier.BlockModifier;
import party.lemons.biomemakeover.block.modifier.CompostModifier;
import party.lemons.biomemakeover.block.modifier.FlammableModifier;
import party.lemons.biomemakeover.block.modifier.HoeModifier;
import party.lemons.biomemakeover.block.modifier.RTypeModifier;
import party.lemons.biomemakeover.init.BMEffects;
import party.lemons.biomemakeover.init.BMWorldGen;
import party.lemons.biomemakeover.init.forge.BMBlocksImpl;
import party.lemons.biomemakeover.level.generate.foliage.AncientOakSaplingGenerator;
import party.lemons.biomemakeover.level.generate.foliage.BalsaSaplingGenerator;
import party.lemons.biomemakeover.level.generate.foliage.SwampCypressSaplingGenerator;
import party.lemons.biomemakeover.level.generate.foliage.WillowSaplingGenerator;
import party.lemons.biomemakeover.util.BMSoundType;
import party.lemons.biomemakeover.util.FieldConsumer;
import party.lemons.biomemakeover.util.registry.DecorationBlockInfo;
import party.lemons.biomemakeover.util.registry.RType;
import party.lemons.biomemakeover.util.registry.WoodTypeInfo;
import party.lemons.biomemakeover.util.registry.boat.BoatTypes;

public class BMBlocks {
    public static final List<Block> blocks = Lists.newArrayList();
    public static final Map<ResourceLocation, RegistrySupplier<Item>> BLOCK_ITEMS = Maps.newHashMap();
    public static final Multimap<Block, BlockModifier> MODIFIERS = ArrayListMultimap.create();
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"biomemakeover", (ResourceKey)Registry.f_122901_);
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"biomemakeover", (ResourceKey)Registry.f_122904_);
    public static final Material POLTERGEIST_MATERIAL = new Material(MaterialColor.f_76419_, false, true, true, false, true, false, PushReaction.BLOCK);
    public static final SoundType BM_LILY_PAD_SOUND = new SoundType(1.0f, 1.0f, SoundEvents.f_12543_, SoundEvents.f_12547_, SoundEvents.f_12581_, SoundEvents.f_12545_, SoundEvents.f_12544_);
    public static final SoundType ILLUNITE_SOUND = new BMSoundType(1.0f, 1.0f, BMEffects.ILLUNITE_BREAK, BMEffects.ILLUNITE_STEP, BMEffects.ILLUNITE_PLACE, BMEffects.ILLUNITE_HIT, () -> SoundEvents.f_12445_);
    public static final Supplier<Block> PURPLE_GLOWSHROOM = BMBlocks.registerBlockItem("purple_glowshroom", () -> new GlowshroomPlantBlock(() -> BMWorldGen.MushroomFields.HUGE_PURPLE_GLOWSHROOM, BMBlocks.properties(Material.f_76300_, 0.0f).m_60953_(s -> 13).m_60910_().m_60910_().m_60918_(SoundType.f_56711_)).modifiers(RTypeModifier.create(RType.CUTOUT), CompostModifier.create(0.7f)));
    public static final Supplier<Block> GREEN_GLOWSHROOM = BMBlocks.registerBlockItem("green_glowshroom", () -> new GlowshroomPlantBlock(() -> BMWorldGen.MushroomFields.HUGE_GREEN_GLOWSHROOM, BMBlocks.properties(Material.f_76300_, 0.0f).m_60953_(s -> 13).m_60910_().m_60955_().m_60918_(SoundType.f_56711_)).modifiers(RTypeModifier.create(RType.CUTOUT), CompostModifier.create(0.7f)));
    public static final Supplier<Block> ORANGE_GLOWSHROOM = BMBlocks.registerBlockItem("orange_glowshroom", () -> new UnderwaterMushroomPlantBlock(() -> BMWorldGen.MushroomFields.HUGE_ORANGE_GLOWSHROOM, BMBlocks.properties(Material.f_76300_, 0.0f).m_60953_(s -> 13).m_60910_().m_60955_().m_60918_(SoundType.f_56711_)).modifiers(RTypeModifier.create(RType.CUTOUT), CompostModifier.create(0.7f)));
    public static final Supplier<Block> PURPLE_GLOWSHROOM_BLOCK = BMBlocks.registerBlockItem("purple_glowshroom_block", () -> new BMMushroomBlock(BMBlocks.properties(Material.f_76300_, 0.2f).m_60953_(s -> 15).m_60918_(SoundType.f_56711_)).modifiers(CompostModifier.create(0.9f)));
    public static final Supplier<Block> GREEN_GLOWSHROOM_BLOCK = BMBlocks.registerBlockItem("green_glowshroom_block", () -> new BMMushroomBlock(BMBlocks.properties(Material.f_76300_, 0.2f).m_60953_(s -> 15).m_60918_(SoundType.f_56711_)).modifiers(CompostModifier.create(0.9f)));
    public static final Supplier<Block> ORANGE_GLOWSHROOM_BLOCK = BMBlocks.registerBlockItem("orange_glowshroom_block", () -> new BMMushroomBlock(BMBlocks.properties(Material.f_76300_, 0.2f).m_60953_(s -> 15).m_60918_(SoundType.f_56711_)).modifiers(CompostModifier.create(0.9f)));
    public static final Supplier<Block> MYCELIUM_SPROUTS = BMBlocks.registerBlockItem("mycelium_sprouts", () -> new MushroomSproutsBlock(BMBlocks.properties(Material.f_76303_, 0.0f).m_60910_().m_60910_().m_60966_().m_60918_(SoundType.f_56722_)).modifiers(RTypeModifier.create(RType.CUTOUT), CompostModifier.create(0.7f)));
    public static final Supplier<Block> MYCELIUM_ROOTS = BMBlocks.registerBlockItem("mycelium_roots", () -> new MushroomRootsBlock(BMBlocks.properties(Material.f_76303_, 0.0f).m_60910_().m_60910_().m_60966_().m_60918_(SoundType.f_56712_)).modifiers(RTypeModifier.create(RType.CUTOUT), CompostModifier.create(0.7f)));
    public static final Supplier<Block> TALL_BROWN_MUSHROOM = BMBlocks.registerBlockItem("tall_brown_mushroom", () -> new BMTallMushroomBlock(Blocks.f_50072_, BMBlocks.properties(Material.f_76300_, 0.0f).m_60966_().m_60910_().m_60918_(SoundType.f_56711_)).modifiers(RTypeModifier.create(RType.CUTOUT), CompostModifier.create(0.7f)));
    public static final Supplier<Block> TALL_RED_MUSHROOM = BMBlocks.registerBlockItem("tall_red_mushroom", () -> new BMTallMushroomBlock(Blocks.f_50073_, BMBlocks.properties(Material.f_76300_, 0.0f).m_60966_().m_60910_().m_60918_(SoundType.f_56711_)).modifiers(RTypeModifier.create(RType.CUTOUT), CompostModifier.create(0.9f)));
    public static WoodTypeInfo BLIGHTED_BALSA_WOOD_INFO = new WoodTypeInfo("biomemakeover", BiomeMakeover.TAB, "blighted_balsa").all(() -> BoatTypes.BLIGHTED_BALSA);
    public static final Supplier<Block> BLIGHTED_BALSA_LEAVES = BMBlocks.registerBlockItem("blighted_balsa_leaves", () -> new BMLeavesBlock(BMBlocks.properties(Material.f_76274_, 0.2f).m_60977_().m_60918_(SoundType.f_56740_).m_60955_().m_60922_(BMBlocks::canSpawnOnLeaves).m_60960_((a, b, c) -> false).m_60971_((a, b, c) -> false)).modifiers(RTypeModifier.create(RType.CUTOUT), CompostModifier.create(0.3f), FlammableModifier.LEAVES));
    public static final Supplier<Block> BLIGHTED_BALSA_SAPLING = BMBlocks.registerBlockItem("blighted_balsa_sapling", () -> new BMSaplingBlock(new BalsaSaplingGenerator(), BMBlocks.properties(Material.f_76300_, 0.0f).m_60910_().m_60977_().m_60966_().m_60918_(SoundType.f_56740_)).modifiers(RTypeModifier.create(RType.CUTOUT), CompostModifier.create(0.4f)));
    public static final Supplier<Block> GLOWSHROOM_STEM = BMBlocks.registerBlockItem("glowshroom_stem", () -> new BMMushroomBlock(BMBlocks.properties(Material.f_76315_, 0.2f).m_60953_(s -> 7).m_60918_(SoundType.f_56711_)).modifiers(CompostModifier.create(0.9f)));
    public static final Supplier<Block> RED_MUSHROOM_BRICK = BMBlocks.registerBlockItem("red_mushroom_brick", () -> new BMBlock(BMBlocks.properties(Material.f_76315_, 0.8f).m_60918_(SoundType.f_56711_)));
    public static final DecorationBlockInfo RED_MUSHROOM_BRICK_DECORATION = new DecorationBlockInfo("biomemakeover", BiomeMakeover.TAB, "red_mushroom_brick", RED_MUSHROOM_BRICK, BMBlocks.properties(Material.f_76315_, 0.8f).m_60918_(SoundType.f_56711_)).all();
    public static final Supplier<Block> BROWN_MUSHROOM_BRICK = BMBlocks.registerBlockItem("brown_mushroom_brick", () -> new BMBlock(BMBlocks.properties(Material.f_76315_, 0.8f).m_60918_(SoundType.f_56711_)));
    public static final DecorationBlockInfo BROWN_MUSHROOM_BRICK_DECORATION = new DecorationBlockInfo("biomemakeover", BiomeMakeover.TAB, "brown_mushroom_brick", BROWN_MUSHROOM_BRICK, BMBlocks.properties(Material.f_76315_, 0.8f).m_60918_(SoundType.f_56711_)).all();
    public static final Supplier<Block> PURPLE_GLOWSHROOM_BRICK = BMBlocks.registerBlockItem("purple_glowshroom_brick", () -> new BMBlock(BMBlocks.properties(Material.f_76315_, 0.8f).m_60953_(s -> 13).m_60918_(SoundType.f_56711_)));
    public static final DecorationBlockInfo PURPLE_GLOWSROOM_BRICK_DECORATION = new DecorationBlockInfo("biomemakeover", BiomeMakeover.TAB, "purple_glowshroom_brick", PURPLE_GLOWSHROOM_BRICK, BMBlocks.properties(Material.f_76315_, 0.8f).m_60953_(s -> 13).m_60918_(SoundType.f_56711_)).all();
    public static final Supplier<Block> GREEN_GLOWSHROOM_BRICK = BMBlocks.registerBlockItem("green_glowshroom_brick", () -> new BMBlock(BMBlocks.properties(Material.f_76315_, 0.8f).m_60953_(s -> 13).m_60918_(SoundType.f_56711_)));
    public static final DecorationBlockInfo GREEN_GLOWSROOM_BRICK_DECORATION = new DecorationBlockInfo("biomemakeover", BiomeMakeover.TAB, "green_glowshroom_brick", GREEN_GLOWSHROOM_BRICK, BMBlocks.properties(Material.f_76315_, 0.8f).m_60953_(s -> 13).m_60918_(SoundType.f_56711_)).all();
    public static final Supplier<Block> ORANGE_GLOWSHROOM_BRICK = BMBlocks.registerBlockItem("orange_glowshroom_brick", () -> new BMBlock(BMBlocks.properties(Material.f_76315_, 0.8f).m_60953_(s -> 13).m_60918_(SoundType.f_56711_)));
    public static final DecorationBlockInfo ORANGE_GLOWSROOM_BRICK_DECORATION = new DecorationBlockInfo("biomemakeover", BiomeMakeover.TAB, "orange_glowshroom_brick", ORANGE_GLOWSHROOM_BRICK, BMBlocks.properties(Material.f_76315_, 0.8f).m_60953_(s -> 13).m_60918_(SoundType.f_56711_)).all();
    public static final Supplier<Block> GLOWSHROOM_STEM_BRICK = BMBlocks.registerBlockItem("glowshroom_stem_brick", () -> new BMBlock(BMBlocks.properties(Material.f_76315_, 0.8f).m_60953_(s -> 7).m_60918_(SoundType.f_56711_)));
    public static final DecorationBlockInfo GLOWSHROOM_STEM_BRICK_DECORATION = new DecorationBlockInfo("biomemakeover", BiomeMakeover.TAB, "glowshroom_stem_brick", GLOWSHROOM_STEM_BRICK, BMBlocks.properties(Material.f_76315_, 0.8f).m_60953_(s -> 7).m_60918_(SoundType.f_56711_)).all();
    public static final Supplier<Block> MUSHROOM_STEM_BRICK = BMBlocks.registerBlockItem("mushroom_stem_brick", () -> new BMBlock(BMBlocks.properties(Material.f_76315_, 0.8f).m_60918_(SoundType.f_56711_)));
    public static final DecorationBlockInfo MUSHROOM_STEM_BRICK_DECORATION = new DecorationBlockInfo("biomemakeover", BiomeMakeover.TAB, "mushroom_stem_brick", MUSHROOM_STEM_BRICK, BMBlocks.properties(Material.f_76315_, 0.8f).m_60918_(SoundType.f_56711_)).all();
    public static final Supplier<Block> BLIGHTED_COBBLESTONE = BMBlocks.registerBlockItem("blighted_cobblestone", () -> new BMBlock(BMBlocks.properties(Material.f_76278_, 2.0f).m_60918_(SoundType.f_56742_).m_60999_()));
    public static final DecorationBlockInfo BLIGHTED_COBBLESTONE_DECORATION = new DecorationBlockInfo("biomemakeover", BiomeMakeover.TAB, "blighted_cobblestone", BLIGHTED_COBBLESTONE, BMBlocks.properties(Material.f_76278_, 2.0f).m_60999_().m_60918_(SoundType.f_56742_)).all();
    public static final Supplier<Block> BLIGHTED_STONE_BRICKS = BMBlocks.registerBlockItem("blighted_stone_bricks", () -> new BMBlock(BMBlocks.properties(Material.f_76278_, 2.0f).m_60918_(SoundType.f_56742_).m_60999_()));
    public static final DecorationBlockInfo BLIGHTED_STONE_BRICKS_DECORATION = new DecorationBlockInfo("biomemakeover", BiomeMakeover.TAB, "blighted_stone_bricks", BLIGHTED_STONE_BRICKS, BMBlocks.properties(Material.f_76278_, 2.0f).m_60999_().m_60918_(SoundType.f_56742_)).all();
    public static final Supplier<Block> PAYDIRT = BMBlocks.registerBlockItem("paydirt", () -> new BMBlock(BMBlocks.properties(Material.f_76314_, 1.4f).m_60999_().m_60918_(SoundType.f_56739_)));
    public static final Supplier<Block> TUMBLEWEED = BLOCKS.register(BiomeMakeover.ID("tumbleweed"), () -> new Block(BMBlocks.properties(Material.f_76300_, 0.0f)));
    public static final Supplier<Block> SAGUARO_CACTUS = BMBlocks.registerBlockItem("saguaro_cactus", () -> new SaguaroCactusBlock(BMBlocks.properties(Material.f_76277_, 0.4f).m_60918_(SoundType.f_56745_).m_60977_()).modifiers(RTypeModifier.create(RType.CUTOUT), CompostModifier.create(0.15f)));
    public static final Supplier<Block> BARREL_CACTUS = BMBlocks.registerBlockItem("barrel_cactus", () -> new BarrelCactusBlock(false, BMBlocks.properties(Material.f_76277_, 0.0f).m_60977_().m_60918_(SoundType.f_56745_).m_60955_().m_60966_().m_60910_()).modifiers(RTypeModifier.create(RType.CUTOUT), CompostModifier.create(0.3f)));
    public static final Supplier<Block> BARREL_CACTUS_FLOWERED = BMBlocks.registerBlockItem("barrel_cactus_flowered", () -> new BarrelCactusBlock(true, BMBlocks.properties(Material.f_76277_, 0.0f).m_60918_(SoundType.f_56745_).m_60955_().m_60966_().m_60910_()).modifiers(RTypeModifier.create(RType.CUTOUT), CompostModifier.create(0.3f)));
    public static final Supplier<Block> POLTERGEIST = BMBlocks.registerBlockItem("poltergeist", () -> new PoltergeistBlock(BMBlocks.properties(POLTERGEIST_MATERIAL, 1.0f).m_60953_(bs -> (Boolean)bs.m_61143_((Property)PoltergeistBlock.ENABLED) != false ? 7 : 0).m_60918_(SoundType.f_56727_)).modifiers(RTypeModifier.create(RType.CUTOUT)));
    public static final Supplier<Block> ECTOPLASM_COMPOSTER = BLOCKS.register(BiomeMakeover.ID("ectoplasm_composter"), () -> new EctoplasmComposterBlock(BMBlocks.properties(Material.f_76320_, 0.6f).m_60918_(SoundType.f_56736_)));
    public static WoodTypeInfo WILLOW_WOOD_INFO = new WoodTypeInfo("biomemakeover", BiomeMakeover.TAB, "willow").all(() -> BoatTypes.WILLOW);
    public static WoodTypeInfo SWAMP_CYPRESS_WOOD_INFO = new WoodTypeInfo("biomemakeover", BiomeMakeover.TAB, "swamp_cypress").all(() -> BoatTypes.SWAMP_CYPRESS);
    public static final Supplier<Block> WILLOWING_BRANCHES = BMBlocks.registerBlockItem("willowing_branches", () -> new WillowingBranchesBlock(BMBlocks.properties(Material.f_76300_, 0.1f).m_60977_().m_60918_(SoundType.f_56760_).m_60910_().m_60955_()).modifiers(RTypeModifier.create(RType.CUTOUT_MIPPED), CompostModifier.create(0.3f), new FlammableModifier(15, 100)));
    public static final Supplier<Block> WILLOW_SAPLING = BMBlocks.registerBlockItem("willow_sapling", () -> new WaterSaplingBlock(new WillowSaplingGenerator(), 1, BMBlocks.properties(Material.f_76300_, 0.0f).m_60910_().m_60977_().m_60966_().m_60918_(SoundType.f_56740_)).modifiers(RTypeModifier.create(RType.CUTOUT), CompostModifier.create(0.4f)));
    public static final Supplier<Block> SWAMP_CYPRESS_SAPLING = BMBlocks.registerBlockItem("swamp_cypress_sapling", () -> new WaterSaplingBlock(new SwampCypressSaplingGenerator(), 3, BMBlocks.properties(Material.f_76300_, 0.0f).m_60910_().m_60977_().m_60966_().m_60918_(SoundType.f_56740_)).modifiers(RTypeModifier.create(RType.CUTOUT), CompostModifier.create(0.4f)));
    public static final Supplier<Block> PEAT = BMBlocks.registerBlockItem("peat", () -> new BMBlock(BMBlocks.properties(Material.f_76314_, 0.5f).m_60918_(SoundType.f_56752_)).modifiers(new HoeModifier(PEAT_FARMLAND)));
    public static final RegistrySupplier<Block> DRIED_PEAT = BMBlocks.registerBlockItem("dried_peat", () -> new BMBlock(BMBlocks.properties(Material.f_76314_, 1.0f).m_60918_(SoundType.f_56720_)));
    public static final Supplier<Block> MOSSY_PEAT = BMBlocks.registerBlockItem("mossy_peat", () -> new BMSpreadableBlock(BMBlocks.properties(Material.f_76314_, 0.5f).m_60977_().m_60918_(SoundType.f_56752_), PEAT).modifiers(new HoeModifier(PEAT_FARMLAND)));
    public static final Supplier<Block> PEAT_FARMLAND = BMBlocks.registerBlockItem("peat_farmland", () -> new PeatFarmlandBlock(BMBlocks.properties(Material.f_76314_, 0.5f).m_60918_(SoundType.f_56752_).m_60977_().m_60955_()));
    public static final Supplier<Block> DRIED_PEAT_BRICKS = BMBlocks.registerBlockItem("dried_peat_bricks", () -> new BMBlock(BMBlocks.properties(Material.f_76278_, 2.0f).m_60918_(SoundType.f_56742_).m_60999_()));
    public static final DecorationBlockInfo DRIED_PEAT_BRICKS_DECORATION = new DecorationBlockInfo("biomemakeover", BiomeMakeover.TAB, "dried_peat_bricks", DRIED_PEAT_BRICKS, BMBlocks.properties(Material.f_76278_, 2.0f).m_60918_(SoundType.f_56720_).m_60999_().m_60918_(SoundType.f_56742_)).all();
    public static final Supplier<Block> MOSSY_DRIED_PEAT_BRICKS = BMBlocks.registerBlockItem("mossy_dried_peat_bricks", () -> new BMBlock(BMBlocks.properties(Material.f_76278_, 2.0f).m_60918_(SoundType.f_56742_).m_60999_()));
    public static final DecorationBlockInfo MOSSY_DRIED_PEAT_BRICKS_DECORATION = new DecorationBlockInfo("biomemakeover", BiomeMakeover.TAB, "mossy_dried_peat_brick", MOSSY_DRIED_PEAT_BRICKS, BMBlocks.properties(Material.f_76278_, 2.0f).m_60918_(SoundType.f_56720_).m_60999_().m_60918_(SoundType.f_56742_)).all();
    public static final Supplier<Block> CRACKED_DRIED_PEAT_BRICKS = BMBlocks.registerBlockItem("cracked_dried_peat_bricks", () -> new BMBlock(BMBlocks.properties(Material.f_76278_, 2.0f).m_60918_(SoundType.f_56742_).m_60999_()));
    public static final DecorationBlockInfo CRACKED_DRIED_PEAT_BRICKS_DECORATION = new DecorationBlockInfo("biomemakeover", BiomeMakeover.TAB, "cracked_dried_peat_brick", CRACKED_DRIED_PEAT_BRICKS, BMBlocks.properties(Material.f_76278_, 2.0f).m_60918_(SoundType.f_56720_).m_60999_().m_60918_(SoundType.f_56742_)).all();
    public static final Supplier<Block> SWAMP_AZALEA = BMBlocks.registerBlockItem("swamp_azalea", () -> new BMTallFlowerBlock(BMBlocks.properties(Material.f_76300_, 0.0f).m_60910_().m_60966_().m_60918_(SoundType.f_56740_)).modifiers(RTypeModifier.create(RType.CUTOUT), CompostModifier.create(0.65f), FlammableModifier.TALL_FLOWER));
    public static final Supplier<Block> MARIGOLD = BMBlocks.registerBlockItem("marigold", () -> new BMTallFlowerBlock(BMBlocks.properties(Material.f_76300_, 0.0f).m_60910_().m_60966_().m_60918_(SoundType.f_56740_)).modifiers(RTypeModifier.create(RType.CUTOUT), CompostModifier.create(0.65f), FlammableModifier.TALL_FLOWER));
    public static final Supplier<Block> BLACK_THISTLE = BMBlocks.registerBlockItem("black_thistle", () -> new BlackThistleBlock(BMBlocks.properties(Material.f_76300_, 0.0f).m_60910_().m_60966_().m_60918_(SoundType.f_56740_)).modifiers(RTypeModifier.create(RType.CUTOUT), CompostModifier.create(0.65f), FlammableModifier.TALL_FLOWER));
    public static final Supplier<Block> FOXGLOVE = BMBlocks.registerBlockItem("foxglove", () -> new BMTallFlowerBlock(BMBlocks.properties(Material.f_76300_, 0.0f).m_60910_().m_60966_().m_60918_(SoundType.f_56740_)).modifiers(RTypeModifier.create(RType.CUTOUT), CompostModifier.create(0.65f), FlammableModifier.TALL_FLOWER));
    public static final Supplier<Block> CATTAIL = BMBlocks.registerBlockItem("cattail", () -> new ReedBlock(BMBlocks.properties(Material.f_76300_, 0.0f).m_60966_().m_60910_().m_60918_(SoundType.f_56740_)).modifiers(RTypeModifier.create(RType.CUTOUT), CompostModifier.create(0.5f)));
    public static final Supplier<Block> REED = BMBlocks.registerBlockItem("reed", () -> new ReedBlock(BMBlocks.properties(Material.f_76300_, 0.0f).m_60966_().m_60910_().m_60918_(SoundType.f_56740_)).modifiers(RTypeModifier.create(RType.CUTOUT), CompostModifier.create(0.2f)));
    public static final Supplier<Block> SMALL_LILY_PAD = BMBlocks.registerLilyPad("small_lily_pad", () -> new SmallLilyPadBlock(BMBlocks.properties(Material.f_76300_, 0.0f).m_60966_().m_60918_(BM_LILY_PAD_SOUND)).modifiers(RTypeModifier.create(RType.CUTOUT), CompostModifier.create(0.3f)));
    public static final Supplier<Block> WATER_LILY = BMBlocks.registerLilyPad("water_lily", () -> new FloweredWaterlilyPadBlock(BMBlocks.properties(Material.f_76300_, 0.0f).m_60966_().m_60918_(BM_LILY_PAD_SOUND)).modifiers(RTypeModifier.create(RType.CUTOUT), CompostModifier.create(0.8f)));
    public static final Supplier<Block> WILLOW_LEAVES = BMBlocks.registerBlockItem("willow_leaves", () -> new BMLeavesBlock(BMBlocks.properties(Material.f_76274_, 0.2f).m_60977_().m_60918_(SoundType.f_56740_).m_60955_().m_60922_(BMBlocks::canSpawnOnLeaves).m_60960_((a, b, c) -> false).m_60971_((a, b, c) -> false)).modifiers(RTypeModifier.create(RType.CUTOUT_MIPPED), CompostModifier.create(0.3f), FlammableModifier.LEAVES));
    public static final Supplier<Block> SWAMP_CYPRESS_LEAVES = BMBlocks.registerBlockItem("swamp_cypress_leaves", () -> new BMLeavesBlock(BMBlocks.properties(Material.f_76274_, 0.2f).m_60977_().m_60918_(SoundType.f_56740_).m_60955_().m_60922_(BMBlocks::canSpawnOnLeaves).m_60960_((a, b, c) -> false).m_60971_((a, b, c) -> false)).modifiers(RTypeModifier.create(RType.CUTOUT_MIPPED), CompostModifier.create(0.3f), FlammableModifier.LEAVES));
    public static final Supplier<Block> LIGHTNING_BUG_BOTTLE = BMBlocks.registerBlockItem("lightning_bug_bottle", () -> new LightningBugBottleBlock(BMBlocks.properties(Material.f_76278_, 0.5f).m_60953_(b -> 15).m_60955_()).modifiers(RTypeModifier.create(RType.CUTOUT)));
    public static final Supplier<Block> ILLUNITE_CLUSTER = BMBlocks.registerBlockItem("illunite_cluster", () -> new IlluniteClusterBlock(BMBlocks.properties(Material.f_76278_, 0.5f).m_60918_(ILLUNITE_SOUND).m_60955_().m_60982_(BMBlocks::always).m_60991_(BMBlocks::always)).modifiers(RTypeModifier.create(RType.CUTOUT)));
    public static final Supplier<Block> ILLUNITE_BLOCK = BMBlocks.registerBlockItem("illunite_block", () -> new BMBlock(BMBlocks.properties(Material.f_76278_, 1.5f).m_60999_().m_60918_(ILLUNITE_SOUND)));
    public static final Supplier<Block> MESMERITE = BMBlocks.registerBlockItem("mesmerite", () -> new BMBlock(BMBlocks.properties(Material.f_76278_, 1.5f)));
    public static final DecorationBlockInfo MESMERITE_DECORATION = new DecorationBlockInfo("biomemakeover", BiomeMakeover.TAB, "mesmerite", MESMERITE, BMBlocks.properties(Material.f_76278_, 1.5f)).all();
    public static final Supplier<Block> POLISHED_MESMERITE = BMBlocks.registerBlockItem("polished_mesmerite", () -> new BMBlock(BMBlocks.properties(Material.f_76278_, 1.5f)));
    public static final DecorationBlockInfo POLISHED_MESMERITE_DECORATION = new DecorationBlockInfo("biomemakeover", BiomeMakeover.TAB, "polished_mesmerite", POLISHED_MESMERITE, BMBlocks.properties(Material.f_76278_, 1.5f)).all();
    public static WoodTypeInfo ANCIENT_OAK_WOOD_INFO = new WoodTypeInfo("biomemakeover", BiomeMakeover.TAB, "ancient_oak").all(() -> BoatTypes.ANCIENT_OAK);
    public static final Supplier<Block> ANCIENT_OAK_SAPLING = BMBlocks.registerBlockItem("ancient_oak_sapling", () -> new BMSaplingBlock((AbstractTreeGrower)new AncientOakSaplingGenerator(), BMBlocks.properties(Material.f_76300_, 0.0f).m_60910_().m_60977_().m_60966_().m_60918_(SoundType.f_56740_)).modifiers(RTypeModifier.create(RType.CUTOUT)));
    public static final Supplier<Block> ANCIENT_OAK_LEAVES = BMBlocks.registerBlockItem("ancient_oak_leaves", () -> new BMLeavesBlock(BMBlocks.properties(Material.f_76274_, 0.2f).m_60977_().m_60918_(SoundType.f_56740_).m_60955_().m_60922_(BMBlocks::canSpawnOnLeaves).m_60960_((a, b, c) -> false).m_60971_((a, b, c) -> false)).modifiers(RTypeModifier.create(RType.CUTOUT_MIPPED), CompostModifier.create(0.3f), FlammableModifier.LEAVES));
    public static final Supplier<Block> ALTAR = BMBlocks.registerBlockItem("altar", () -> new AltarBlock(BMBlocks.properties(Material.f_76278_, 5.0f).m_60953_(st -> (Boolean)st.m_61143_((Property)AltarBlock.ACTIVE) != false ? 5 : 1).m_60999_().m_60955_()).modifiers(RTypeModifier.create(RType.CUTOUT)));
    public static final Supplier<Block> CLADDED_STONE = BMBlocks.registerBlockItem("cladded_stone", () -> new BMBlock(BMBlocks.properties(Material.f_76278_, 1.5f).m_60999_()));
    public static final Supplier<Block> ROOTLING_CROP = BLOCKS.register(BiomeMakeover.ID("rootling_crop"), () -> new RootlingCropBlock(BMBlocks.properties(Material.f_76300_, 0.0f).m_60910_().m_60977_().m_60966_().m_60918_(SoundType.f_56758_)).modifiers(RTypeModifier.create(RType.CUTOUT)));
    public static final Supplier<Block> IVY = BMBlocks.registerBlockItem("ivy", () -> new IvyBlock(BMBlocks.properties(Material.f_76302_, 0.15f).m_60910_().m_60977_().m_60918_(SoundType.f_56760_)).modifiers(RTypeModifier.create(RType.CUTOUT), FlammableModifier.IVY));
    public static final Supplier<Block> ITCHING_IVY = BMBlocks.registerBlockItem("itching_ivy", () -> new ItchingIvyBlock(BMBlocks.properties(Material.f_76302_, 0.15f).m_60956_(0.5f).m_60910_().m_60977_().m_60918_(SoundType.f_56760_)).modifiers(RTypeModifier.create(RType.CUTOUT), FlammableModifier.IVY));
    public static final Supplier<Block> MOTH_BLOSSOM = BMBlocks.registerBlockItem("moth_blossom", () -> new MothBlossomBlock(BMBlocks.properties(Material.f_76300_, 0.25f).m_60956_(0.5f).m_60910_().m_60977_().m_60918_(SoundType.f_56760_)).modifiers(RTypeModifier.create(RType.CUTOUT), FlammableModifier.IVY));
    public static final Supplier<Block> WILD_MUSHROOMS = BMBlocks.registerBlockItem("wild_mushrooms", () -> new WildMushroomBlock(BMBlocks.properties(Material.f_76300_, 0.0f).m_60910_().m_60977_().m_60955_().m_60918_(SoundType.f_56711_)).modifiers(RTypeModifier.create(RType.CUTOUT), FlammableModifier.IVY));
    public static final Supplier<Block> POTTED_MYCELIUM_ROOTS = BLOCKS.register(BiomeMakeover.ID("potted_mycelium_roots"), () -> new BMFlowerPotBlock(MYCELIUM_ROOTS.get(), BMBlocks.properties(Material.f_76310_, 0.0f).m_60966_().m_60955_().m_60918_(SoundType.f_56722_)).modifiers(RTypeModifier.create(RType.CUTOUT)));
    public static final Supplier<Block> POTTED_PURPLE_GLOWSHROOM = BLOCKS.register(BiomeMakeover.ID("potted_purple_glowshroom"), () -> new BMFlowerPotBlock(PURPLE_GLOWSHROOM.get(), BMBlocks.properties(Material.f_76310_, 0.0f).m_60953_(s -> 13).m_60966_().m_60955_().m_60918_(SoundType.f_56722_)).modifiers(RTypeModifier.create(RType.CUTOUT)));
    public static final Supplier<Block> POTTED_GREEN_GLOWSHROOM = BLOCKS.register(BiomeMakeover.ID("potted_green_glowshroom"), () -> new BMFlowerPotBlock(GREEN_GLOWSHROOM.get(), BMBlocks.properties(Material.f_76310_, 0.0f).m_60953_(s -> 13).m_60966_().m_60955_().m_60918_(SoundType.f_56722_)).modifiers(RTypeModifier.create(RType.CUTOUT)));
    public static final Supplier<Block> POTTED_ORANGE_GLOWSHROOM = BLOCKS.register(BiomeMakeover.ID("potted_orange_glowshroom"), () -> new BMFlowerPotBlock(ORANGE_GLOWSHROOM.get(), BMBlocks.properties(Material.f_76310_, 0.0f).m_60953_(s -> 13).m_60966_().m_60955_().m_60918_(SoundType.f_56722_)).modifiers(RTypeModifier.create(RType.CUTOUT)));
    public static final Supplier<Block> POTTED_BLIGHTED_BALSA_SAPLING = BLOCKS.register(BiomeMakeover.ID("potted_blighted_balsa_sapling"), () -> new BMFlowerPotBlock(BLIGHTED_BALSA_SAPLING.get(), BMBlocks.properties(Material.f_76310_, 0.0f).m_60966_().m_60955_().m_60918_(SoundType.f_56722_)).modifiers(RTypeModifier.create(RType.CUTOUT)));
    public static final Supplier<Block> POTTED_SAGUARO_CACTUS = BLOCKS.register(BiomeMakeover.ID("potted_saguaro_cactus"), () -> new BMFlowerPotBlock(SAGUARO_CACTUS.get(), BMBlocks.properties(Material.f_76310_, 0.0f).m_60966_().m_60955_().m_60918_(SoundType.f_56745_)).modifiers(RTypeModifier.create(RType.CUTOUT)));
    public static final Supplier<Block> POTTED_BARREL_CACTUS = BLOCKS.register(BiomeMakeover.ID("potted_barrel_cactus"), () -> new BMFlowerPotBlock(BARREL_CACTUS.get(), BMBlocks.properties(Material.f_76310_, 0.0f).m_60966_().m_60955_().m_60918_(SoundType.f_56745_)).modifiers(RTypeModifier.create(RType.CUTOUT)));
    public static final Supplier<Block> POTTED_FLOWERED_BARREL_CACTUS = BLOCKS.register(BiomeMakeover.ID("potted_flowered_barrel_cactus"), () -> new BMFlowerPotBlock(BARREL_CACTUS_FLOWERED.get(), BMBlocks.properties(Material.f_76310_, 0.0f).m_60966_().m_60955_().m_60918_(SoundType.f_56745_)).modifiers(RTypeModifier.create(RType.CUTOUT)));
    public static final Supplier<Block> POTTED_WILLOW_SAPLING = BLOCKS.register(BiomeMakeover.ID("potted_willow_sapling"), () -> new BMFlowerPotBlock(WILLOW_SAPLING.get(), BMBlocks.properties(Material.f_76310_, 0.0f).m_60966_().m_60955_().m_60918_(SoundType.f_56745_)).modifiers(RTypeModifier.create(RType.CUTOUT)));
    public static final Supplier<Block> POTTED_SWAMP_CYPRESS_SAPLING = BLOCKS.register(BiomeMakeover.ID("potted_swamp_cypress_sapling"), () -> new BMFlowerPotBlock(SWAMP_CYPRESS_SAPLING.get(), BMBlocks.properties(Material.f_76310_, 0.0f).m_60966_().m_60955_().m_60918_(SoundType.f_56745_)).modifiers(RTypeModifier.create(RType.CUTOUT)));
    public static final Supplier<Block> POTTED_ANCIENT_OAK_SAPLING = BLOCKS.register(BiomeMakeover.ID("potted_ancient_oak_sapling"), () -> new BMFlowerPotBlock(ANCIENT_OAK_SAPLING.get(), BMBlocks.properties(Material.f_76310_, 0.0f).m_60966_().m_60955_().m_60918_(SoundType.f_56745_)).modifiers(RTypeModifier.create(RType.CUTOUT)));
    public static final Supplier<Block> POTTED_WILD_MUSHROOMS = BLOCKS.register(BiomeMakeover.ID("potted_wild_mushrooms"), () -> new BMFlowerPotBlock(WILD_MUSHROOMS.get(), BMBlocks.properties(Material.f_76310_, 0.0f).m_60966_().m_60955_().m_60918_(SoundType.f_56745_)).modifiers(RTypeModifier.create(RType.CUTOUT)));
    public static final Supplier<Block> DIRECTIONAL_DATA = BMBlocks.registerBlockItem("directional_data", () -> new DirectionalDataBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(-1.0f).m_60993_()));
    public static final Map<DyeColor, Supplier<Block>> DYE_TO_TAPESTRY = Maps.newHashMap();
    public static final List<Supplier<Block>> TAPESTRY_BLOCKS = Lists.newArrayList();
    public static final List<Supplier<Block>> TAPESTRY_WALL_BLOCKS = Lists.newArrayList();
    public static final List<Supplier<Block>> TAPESTRY_FLOOR_BLOCKS = Lists.newArrayList();
    public static Supplier<Block> ADJUDICATOR_TAPESTRY;
    public static final List<CompostModifier.CompostValue> COMPOSTABLES;
    public static final Map<Block, RType> RTYPES;
    public static final Map<Supplier<Block>, Block> BRICK_TO_TERRACOTTA;
    public static final TagKey<Block> LILY_PADS;
    public static final TagKey<Block> MOTH_ATTRACTIVE;
    public static final TagKey<Block> IVY_TAG;
    public static final TagKey<Block> ITCHING_IVY_TAG;
    public static final TagKey<Block> ORE_REPLACEABLE;

    public static void init() {
        FieldConsumer.run(BMBlocks.class, WoodTypeInfo.class, w -> w.register(BLOCKS, ITEMS));
        FieldConsumer.run(BMBlocks.class, DecorationBlockInfo.class, d -> d.register(BLOCKS, ITEMS));
        BMBlocks.createTerracottaBricks();
        BMBlocks.createTapestries();
        BLOCKS.register();
        ITEMS.register();
        BMBlocks.postRegister();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void postRegister() {
        BMBlocksImpl.postRegister();
    }

    public static void initClient() {
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> RTYPES.forEach((block, type) -> RenderTypeRegistry.register((RenderType)type.getAsRenderType(), (Block[])new Block[]{block})));
    }

    public static BlockBehaviour.Properties properties(Material material, float hardness) {
        return BlockBehaviour.Properties.m_60939_((Material)material).m_60913_(hardness, hardness);
    }

    public static Boolean canSpawnOnLeaves(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, EntityType<?> type) {
        return type == EntityType.f_20505_ || type == EntityType.f_20508_;
    }

    public static void createTerracottaBricks() {
        HashMap vanillaTerracotta = Maps.newHashMap();
        vanillaTerracotta.put(DyeColor.BLACK, Blocks.f_50302_);
        vanillaTerracotta.put(DyeColor.RED, Blocks.f_50301_);
        vanillaTerracotta.put(DyeColor.BLUE, Blocks.f_50298_);
        vanillaTerracotta.put(DyeColor.BROWN, Blocks.f_50299_);
        vanillaTerracotta.put(DyeColor.CYAN, Blocks.f_50296_);
        vanillaTerracotta.put(DyeColor.GRAY, Blocks.f_50294_);
        vanillaTerracotta.put(DyeColor.GREEN, Blocks.f_50300_);
        vanillaTerracotta.put(DyeColor.LIGHT_BLUE, Blocks.f_50290_);
        vanillaTerracotta.put(DyeColor.LIGHT_GRAY, Blocks.f_50295_);
        vanillaTerracotta.put(DyeColor.LIME, Blocks.f_50292_);
        vanillaTerracotta.put(DyeColor.MAGENTA, Blocks.f_50289_);
        vanillaTerracotta.put(DyeColor.ORANGE, Blocks.f_50288_);
        vanillaTerracotta.put(DyeColor.PINK, Blocks.f_50293_);
        vanillaTerracotta.put(DyeColor.PURPLE, Blocks.f_50297_);
        vanillaTerracotta.put(DyeColor.WHITE, Blocks.f_50287_);
        vanillaTerracotta.put(DyeColor.YELLOW, Blocks.f_50291_);
        RegistrySupplier tBlock = BLOCKS.register(BiomeMakeover.ID("terracotta_bricks"), () -> new BMBlock(BMBlocks.properties(Material.f_76278_, 2.0f).m_60999_().m_60918_(SoundType.f_56742_)));
        ITEMS.register(BiomeMakeover.ID("terracotta_bricks"), () -> new BlockItem((Block)tBlock.get(), new Item.Properties().m_41491_(BiomeMakeover.TAB)));
        DecorationBlockInfo terracottaBrick = new DecorationBlockInfo("biomemakeover", BiomeMakeover.TAB, "terracotta_brick", (Supplier<Block>)tBlock, BMBlocks.properties(Material.f_76278_, 2.0f).m_60999_().m_60918_(SoundType.f_56742_)).all();
        terracottaBrick.register(BLOCKS, ITEMS);
        for (DyeColor dye : DyeColor.values()) {
            ResourceLocation id = BiomeMakeover.ID(dye.m_41065_() + "_terracotta_bricks");
            RegistrySupplier bl = BLOCKS.register(id, () -> new BMBlock(BMBlocks.properties(Material.f_76278_, 2.0f).m_155949_(dye.m_41069_()).m_60999_().m_60918_(SoundType.f_56742_)));
            ITEMS.register(id, () -> new BlockItem((Block)bl.get(), new Item.Properties().m_41491_(BiomeMakeover.TAB)));
            DecorationBlockInfo dec = new DecorationBlockInfo("biomemakeover", BiomeMakeover.TAB, dye.m_41065_() + "_terracotta_brick", (Supplier<Block>)bl, BMBlocks.properties(Material.f_76278_, 2.0f).m_155949_(dye.m_41069_()).m_60999_().m_60918_(SoundType.f_56742_)).all();
            dec.register(BLOCKS, ITEMS);
            BRICK_TO_TERRACOTTA.put((Supplier<Block>)bl, (Block)vanillaTerracotta.get(dye));
        }
    }

    private static void createTapestries() {
        for (DyeColor dye : DyeColor.values()) {
            RegistrySupplier tap = BLOCKS.register(BiomeMakeover.ID(dye.m_41065_() + "_tapestry"), DYE_TO_TAPESTRY.get(dye));
            RegistrySupplier wallBlock = BLOCKS.register(BiomeMakeover.ID(dye.m_41065_() + "_wall_tapestry"), () -> BMBlocks.lambda$createTapestries$123(dye, (Supplier)tap));
            ITEMS.register(BiomeMakeover.ID(dye.m_41065_() + "_tapestry"), () -> BMBlocks.lambda$createTapestries$124((Supplier)tap, (Supplier)wallBlock));
            TAPESTRY_BLOCKS.add((Supplier<Block>)tap);
            TAPESTRY_BLOCKS.add((Supplier<Block>)wallBlock);
            TAPESTRY_FLOOR_BLOCKS.add((Supplier<Block>)tap);
            TAPESTRY_WALL_BLOCKS.add((Supplier<Block>)wallBlock);
        }
        ADJUDICATOR_TAPESTRY = BLOCKS.register(BiomeMakeover.ID("adjudicator_tapestry"), () -> new AdjudicatorTapestryBlock(BMBlocks.properties(Material.f_76320_, 1.0f).m_60910_().m_60918_(SoundType.f_56736_)));
        RegistrySupplier adjWall = BLOCKS.register(BiomeMakeover.ID("adjudicator_wall_tapestry"), () -> new AdjudicatorTapestryWallBlock(BMBlocks.properties(Material.f_76320_, 1.0f).m_60910_().m_60918_(SoundType.f_56736_).m_60916_(ADJUDICATOR_TAPESTRY.get())));
        ITEMS.register(BiomeMakeover.ID("adjudicator_tapestry"), () -> BMBlocks.lambda$createTapestries$127((Supplier)adjWall));
        TAPESTRY_BLOCKS.add(ADJUDICATOR_TAPESTRY);
        TAPESTRY_BLOCKS.add((Supplier<Block>)adjWall);
    }

    public static void initModifiers() {
        MODIFIERS.forEach((b, a) -> a.accept(b));
    }

    public static void initCompost() {
        COMPOSTABLES.forEach(p -> ComposterBlock.f_51914_.put((Object)p.block().m_5456_(), p.chance()));
    }

    private static boolean always(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    public static RegistrySupplier<Block> registerBlockItem(String id, Supplier<Block> block) {
        ResourceLocation loc = BiomeMakeover.ID(id);
        RegistrySupplier bl = BLOCKS.register(loc, block);
        RegistrySupplier it = ITEMS.register(loc, () -> new BlockItem((Block)bl.get(), new Item.Properties().m_41491_(BiomeMakeover.TAB)));
        BLOCK_ITEMS.put(loc, (RegistrySupplier<Item>)it);
        return bl;
    }

    public static Supplier<Block> registerLilyPad(String id, Supplier<Block> block) {
        RegistrySupplier bl = BLOCKS.register(BiomeMakeover.ID(id), block);
        ITEMS.register(BiomeMakeover.ID(id), () -> new WaterLilyBlockItem((Block)bl.get(), new Item.Properties().m_41491_(BiomeMakeover.TAB)));
        return bl;
    }

    private static /* synthetic */ StandingAndWallBlockItem lambda$createTapestries$127(Supplier adjWall) {
        return new StandingAndWallBlockItem(ADJUDICATOR_TAPESTRY.get(), (Block)adjWall.get(), new Item.Properties().m_41491_(BiomeMakeover.TAB).m_41487_(16).m_41497_(Rarity.EPIC));
    }

    private static /* synthetic */ StandingAndWallBlockItem lambda$createTapestries$124(Supplier tap, Supplier wallBlock) {
        return new StandingAndWallBlockItem((Block)tap.get(), (Block)wallBlock.get(), new Item.Properties().m_41491_(BiomeMakeover.TAB).m_41487_(16).m_41497_(Rarity.UNCOMMON));
    }

    private static /* synthetic */ Block lambda$createTapestries$123(DyeColor dye, Supplier tap) {
        return new ColorTapestryWallBlock(dye, BMBlocks.properties(Material.f_76320_, 1.0f).m_60910_().m_60918_(SoundType.f_56736_).m_60916_((Block)tap.get()));
    }

    static {
        for (DyeColor dyeColor : DyeColor.values()) {
            Supplier<Block> tap = () -> new ColorTapestryBlock(dyeColor, BMBlocks.properties(Material.f_76320_, 1.0f).m_60910_().m_60918_(SoundType.f_56736_));
            DYE_TO_TAPESTRY.put(dyeColor, tap);
        }
        COMPOSTABLES = Lists.newArrayList();
        RTYPES = Maps.newHashMap();
        BRICK_TO_TERRACOTTA = Maps.newHashMap();
        LILY_PADS = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)BiomeMakeover.ID("lily_pads"));
        MOTH_ATTRACTIVE = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)BiomeMakeover.ID("moth_attractive"));
        IVY_TAG = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)BiomeMakeover.ID("ivy"));
        ITCHING_IVY_TAG = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)BiomeMakeover.ID("itching_ivy"));
        ORE_REPLACEABLE = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)BiomeMakeover.ID("ore_replaceable"));
    }
}

