/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.forge;

import dev.architectury.platform.Platform;
import dev.architectury.platform.forge.EventBuses;
import dev.architectury.utils.Env;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.BiomeMakeoverClient;
import party.lemons.biomemakeover.init.BMEffects;
import party.lemons.biomemakeover.init.BMEntities;
import party.lemons.biomemakeover.init.BMWorldGen;
import party.lemons.biomemakeover.level.particle.BlossomParticle;
import party.lemons.biomemakeover.level.particle.LightningSparkParticle;
import party.lemons.biomemakeover.level.particle.PoltergeistParticle;
import party.lemons.biomemakeover.level.particle.TeleportParticle;
import party.lemons.biomemakeover.util.loot.BMLootTableInjection;

@Mod(value="biomemakeover")
@Mod.EventBusSubscriber(modid="biomemakeover", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BMForge {
    private static final ResourceLocation DARK_FOREST = new ResourceLocation("dark_forest");

    public BMForge() {
        EventBuses.registerModEventBus((String)"biomemakeover", (IEventBus)FMLJavaModLoadingContext.get().getModEventBus());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(BMForge::clientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(BMForge::commonSetup);
        BiomeMakeover.init();
        if (Platform.getEnvironment() == Env.CLIENT) {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(BMForge::particleSetup);
            BiomeMakeoverClient.init();
        }
        BMEntities.registerModels();
    }

    @SubscribeEvent
    public static void lootLoad(LootTableLoadEvent event) {
        for (BMLootTableInjection.InjectedItem item : BMLootTableInjection.getInsertedEntries()) {
            if (!event.getName().equals((Object)item.table())) continue;
            event.getTable().addPool(LootPool.m_79043_().m_165133_((NumberProvider)item.rolls()).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item.itemLike()).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f)))).m_6509_(LootItemKilledByPlayerCondition.m_81901_()).m_79082_());
        }
    }

    public static void commonSetup(FMLCommonSetupEvent event) {
    }

    public static void clientSetup(FMLClientSetupEvent event) {
        if (Platform.getEnvironment() == Env.CLIENT) {
            BiomeMakeoverClient.init();
        }
    }

    public static void particleSetup(ParticleFactoryRegisterEvent event) {
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)BMEffects.LIGHTNING_SPARK.get(), LightningSparkParticle.Provider::new);
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)BMEffects.POLTERGEIST.get(), PoltergeistParticle.Provider::new);
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)BMEffects.BLOSSOM.get(), BlossomParticle.Provider::new);
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)BMEffects.TELEPORT.get(), TeleportParticle.Provider::new);
    }

    @SubscribeEvent
    public static void addGen(BiomeLoadingEvent event) {
        BMForge.addBiomeFeatures(event.getCategory() == Biome.BiomeCategory.MUSHROOM, event.getGeneration(), BMWorldGen.MUSHROOM_GEN);
        BMForge.addBiomeFeatures(event.getCategory() == Biome.BiomeCategory.MESA, event.getGeneration(), BMWorldGen.BADLANDS_GEN);
        BMForge.addBiomeFeatures(event.getCategory() == Biome.BiomeCategory.SWAMP, event.getGeneration(), BMWorldGen.SWAMP_GEN);
        BMForge.addBiomeFeatures(event.getName().equals((Object)DARK_FOREST), event.getGeneration(), BMWorldGen.DF_GEN);
    }

    private static void addBiomeFeatures(boolean doAdd, BiomeGenerationSettingsBuilder generation, Map<GenerationStep.Decoration, List<Holder<PlacedFeature>>> features) {
        if (doAdd) {
            for (GenerationStep.Decoration step : features.keySet()) {
                for (Holder<PlacedFeature> feature : features.get(step)) {
                    generation.m_204201_(step, feature);
                }
            }
        }
    }
}

