/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.entity.StoneGolemEntity;
import party.lemons.biomemakeover.util.AnimationHelper;

public class StoneGolemModel
extends EntityModel<StoneGolemEntity>
implements HeadedModel,
ArmedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(BiomeMakeover.ID("stone_golem"), "main");
    private final ModelPart lower_base;
    private final ModelPart body;
    private final ModelPart arm_left;
    private final ModelPart arm_right;
    private final ModelPart head;

    public StoneGolemModel(ModelPart root) {
        this.lower_base = root.m_171324_("lower_base");
        this.body = root.m_171324_("body");
        this.arm_left = this.body.m_171324_("arm_left");
        this.arm_right = this.body.m_171324_("arm_right");
        this.head = this.body.m_171324_("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition lower_base = partdefinition.m_171599_("lower_base", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-7.0f, 0.0f, -7.0f, 14.0f, 8.0f, 14.0f, new CubeDeformation(0.0f)).m_171514_(56, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)16.0f, (float)0.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-9.0f, -16.7f, -5.0f, 18.0f, 12.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(42, 22).m_171488_(-7.0f, -4.7f, -3.0f, 14.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)9.7f, (float)0.0f));
        PartDefinition arm_left = body.m_171599_("arm_left", CubeListBuilder.m_171558_().m_171514_(0, 44).m_171488_(0.5f, 1.5f, -3.0f, 4.0f, 26.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(40, 62).m_171488_(0.5f, -2.5f, -4.0f, 6.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)8.5f, (float)-14.2f, (float)0.0f));
        PartDefinition arm_right = body.m_171599_("arm_right", CubeListBuilder.m_171558_().m_171514_(20, 44).m_171488_(-4.5f, 1.5f, -3.0f, 4.0f, 26.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(64, 33).m_171488_(-6.5f, -2.5f, -4.0f, 6.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-8.5f, (float)-14.2f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(40, 44).m_171488_(-4.0f, -11.0f, -3.5f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(60, 62).m_171488_(-5.0f, -6.0f, -5.5f, 10.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(6, 22).m_171488_(-1.0f, -4.0f, -5.5f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(56, 16).m_171488_(-5.0f, -2.0f, -4.5f, 10.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-15.7f, (float)-3.5f));
        PartDefinition horn = head.m_171599_("horn", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-9.5f, -2.5f, -1.0f, 1.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-0.5f, -2.5f, -1.0f, 1.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.5f, (float)-10.5f, (float)-3.5f, (float)0.7854f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(StoneGolemEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadyRot, float headPitch) {
        AnimationHelper.rotateHead(this.head, headPitch, netHeadyRot);
        AbstractIllager.IllagerArmPose state = entity.getState();
        if (state == AbstractIllager.IllagerArmPose.NEUTRAL) {
            AnimationHelper.setRotation(this.arm_left, 0.0f, 0.0f, 0.0f);
            AnimationHelper.setRotation(this.arm_right, 0.0f, 0.0f, 0.0f);
        } else if (state == AbstractIllager.IllagerArmPose.ATTACKING) {
            if (entity.m_21205_().m_41619_()) {
                AnimationUtils.m_102102_((ModelPart)this.arm_left, (ModelPart)this.arm_right, (boolean)true, (float)this.f_102608_, (float)limbSwingAmount);
            } else {
                AnimationUtils.m_102091_((ModelPart)this.arm_right, (ModelPart)this.arm_left, (Mob)entity, (float)this.f_102608_, (float)limbSwingAmount);
            }
        } else if (state == AbstractIllager.IllagerArmPose.CROSSBOW_HOLD) {
            StoneGolemModel.hold(this.arm_right, this.arm_left, this.head, true);
        } else if (state == AbstractIllager.IllagerArmPose.CROSSBOW_CHARGE) {
            StoneGolemModel.charge(this.arm_right, this.arm_left, (LivingEntity)entity, true);
        }
    }

    public static void hold(ModelPart holdingArm, ModelPart otherArm, ModelPart head, boolean rightArmed) {
        ModelPart modelPart = rightArmed ? holdingArm : otherArm;
        ModelPart modelPart2 = rightArmed ? otherArm : holdingArm;
        modelPart.f_104204_ = (rightArmed ? -0.3f : 0.3f) + head.f_104204_;
        modelPart2.f_104204_ = (rightArmed ? 0.6f : -0.6f) + head.f_104204_;
        modelPart.f_104203_ = -1.25f + head.f_104203_ + 0.1f;
        modelPart2.f_104203_ = -1.25f + head.f_104203_;
    }

    public static void charge(ModelPart holdingArm, ModelPart pullingArm, LivingEntity actor, boolean rightArmed) {
        ModelPart modelPart = rightArmed ? holdingArm : pullingArm;
        ModelPart pullArm = rightArmed ? pullingArm : holdingArm;
        modelPart.f_104204_ = rightArmed ? -0.8f : 0.8f;
        pullArm.f_104203_ = modelPart.f_104203_ = -0.97079635f;
        float f = CrossbowItem.m_40939_((ItemStack)actor.m_21211_());
        float g = Mth.m_14036_((float)actor.m_21252_(), (float)0.0f, (float)f);
        float h = g / f;
        pullArm.f_104204_ = Mth.m_14179_((float)h, (float)0.2f, (float)0.4f) * (float)(rightArmed ? 1 : -1);
        pullArm.f_104203_ = Mth.m_14179_((float)h, (float)pullArm.f_104203_, (float)-1.0f);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104301_(poseStack, buffer, packedLight, packedOverlay);
    }

    public void renderBaseToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.lower_base.m_104301_(poseStack, buffer, packedLight, packedOverlay);
    }

    public void m_6002_(HumanoidArm arm, PoseStack poseStack) {
        if (arm == HumanoidArm.LEFT) {
            this.arm_left.m_104299_(poseStack);
        } else {
            this.arm_right.m_104299_(poseStack);
        }
    }

    public ModelPart m_5585_() {
        return this.head;
    }
}

