/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EyesLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.entity.OwlEntity;
import party.lemons.biomemakeover.entity.render.OwlModel;

public class OwlRender
extends MobRenderer<OwlEntity, OwlModel> {
    private static final ResourceLocation TEXTURE = BiomeMakeover.ID("textures/entity/owl.png");
    private static final ResourceLocation TEXTURE_EASTEREGG = BiomeMakeover.ID("textures/entity/owl_2.png");

    public OwlRender(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new OwlModel(context.m_174023_(OwlModel.LAYER_LOCATION)), 0.5f);
        this.m_115326_((RenderLayer)new OwnEyesRenderer((RenderLayerParent<OwlEntity, OwlModel>)this));
    }

    public ResourceLocation getTextureLocation(OwlEntity entity) {
        String nameString = ChatFormatting.m_126649_((String)entity.m_7755_().getString());
        if (nameString != null && nameString.equalsIgnoreCase("Hedwig")) {
            return TEXTURE_EASTEREGG;
        }
        return TEXTURE;
    }

    protected void renderNameTag(OwlEntity entity, Component component, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        poseStack.m_85836_();
        if (entity.m_6162_()) {
            poseStack.m_85837_(0.0, 0.5, 0.0);
        }
        super.m_7649_((Entity)entity, component, poseStack, multiBufferSource, i);
        poseStack.m_85849_();
    }

    protected void setupRotations(OwlEntity owl, PoseStack poseStack, float f, float g, float h) {
        super.m_7523_((LivingEntity)owl, poseStack, f, g, h);
        if (owl.m_21825_()) {
            poseStack.m_85837_(0.0, (double)-0.1f, 0.0);
        }
        float i = owl.m_20998_(h);
        poseStack.m_85837_(0.0, (double)(i / 7.0f / 2.0f), (double)(i / 7.0f / 2.0f));
        if (i > 0.0f) {
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14179_((float)i, (float)0.0f, (float)-7.0f)));
        }
        poseStack.m_85841_(0.75f, 0.75f, 0.75f);
    }

    public static class OwnEyesRenderer
    extends EyesLayer<OwlEntity, OwlModel> {
        private static RenderType renderType = RenderType.m_110488_((ResourceLocation)BiomeMakeover.ID("textures/entity/owl_eyes.png"));

        public OwnEyesRenderer(RenderLayerParent<OwlEntity, OwlModel> renderLayerParent) {
            super(renderLayerParent);
        }

        public RenderType m_5708_() {
            return renderType;
        }
    }
}

