/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EnergySwirlLayer;
import net.minecraft.client.renderer.entity.layers.EyesLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.entity.adjudicator.AdjudicatorEntity;
import party.lemons.biomemakeover.entity.adjudicator.AdjudicatorState;
import party.lemons.biomemakeover.entity.adjudicator.AdjudicatorStateProvider;
import party.lemons.biomemakeover.entity.render.AdjudicatorModel;

public class AdjudicatorRender
extends MobRenderer<AdjudicatorEntity, AdjudicatorModel<AdjudicatorEntity>> {
    private static final ResourceLocation TEXTURE = BiomeMakeover.ID("textures/entity/adjudicator.png");

    public AdjudicatorRender(EntityRendererProvider.Context context) {
        super(context, new AdjudicatorModel(context.m_174023_(AdjudicatorModel.LAYER_LOCATION)), 0.25f);
        this.m_115326_((RenderLayer)new AdjudicatorHeldItemRenderer((RenderLayerParent)this));
        this.m_115326_((RenderLayer)new AdjudicatorEyesRenderLayer(this));
        this.m_115326_((RenderLayer)new InvulnerableFeatureRenderer(this));
    }

    protected void setupRotations(AdjudicatorEntity entity, PoseStack poseStack, float animationProgress, float bodyYaw, float tickDelta) {
        super.m_7523_((LivingEntity)entity, poseStack, animationProgress, bodyYaw, tickDelta);
        switch (entity.getState()) {
            case WAITING: {
                float waitAng = Mth.m_14189_((float)tickDelta, (float)entity.renderRotPrevious, (float)((float)entity.stateTime * 1.0f));
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(waitAng));
                poseStack.m_85837_(0.0, Math.sin(animationProgress / 25.0f) / 4.0, 0.0);
                entity.renderRotPrevious = waitAng;
                break;
            }
            case TELEPORT: {
                float teleAngle = Mth.m_14189_((float)tickDelta, (float)entity.renderRotPrevious, (float)(entity.stateTime * entity.stateTime));
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(teleAngle));
                entity.renderRotPrevious = teleAngle;
            }
        }
    }

    public ResourceLocation getTextureLocation(AdjudicatorEntity entity) {
        return TEXTURE;
    }

    public static class AdjudicatorHeldItemRenderer<T extends Mob, M extends EntityModel<T>>
    extends ItemInHandLayer<T, M> {
        public AdjudicatorHeldItemRenderer(RenderLayerParent renderLayerParent) {
            super(renderLayerParent);
        }

        public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, T boss, float f, float g, float h, float j, float k, float l) {
            ItemStack rightHand;
            boolean rightHanded = boss.m_5737_() == HumanoidArm.RIGHT;
            ItemStack leftHand = rightHanded ? boss.m_21206_() : boss.m_21205_();
            ItemStack itemStack = rightHand = rightHanded ? boss.m_21205_() : boss.m_21206_();
            if (!leftHand.m_41619_() || !rightHand.m_41619_()) {
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, 0.75, 0.0);
                this.m_117184_((LivingEntity)boss, rightHand, ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, HumanoidArm.RIGHT, poseStack, multiBufferSource, i);
                this.m_117184_((LivingEntity)boss, leftHand, ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND, HumanoidArm.LEFT, poseStack, multiBufferSource, i);
                poseStack.m_85849_();
            }
        }

        protected void m_117184_(LivingEntity livingEntity, ItemStack stack, ItemTransforms.TransformType transformType, HumanoidArm humanoidArm, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
            if (!stack.m_41619_()) {
                poseStack.m_85836_();
                ((ArmedModel)this.m_117386_()).m_6002_(humanoidArm, poseStack);
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                boolean isLeft = humanoidArm == HumanoidArm.LEFT;
                poseStack.m_85837_((double)((isLeft ? -0.7f : 0.7f) / 16.0f), 0.125, -0.625);
                Minecraft.m_91087_().m_91292_().m_109322_(livingEntity, stack, transformType, isLeft, poseStack, multiBufferSource, i);
                poseStack.m_85849_();
            }
        }
    }

    public static class AdjudicatorEyesRenderLayer<T extends Mob, M extends EntityModel<T>>
    extends EyesLayer<T, M> {
        private static RenderType renderType = RenderType.m_110488_((ResourceLocation)BiomeMakeover.ID("textures/entity/adjudicator_eyes.png"));

        public AdjudicatorEyesRenderLayer(RenderLayerParent<T, M> renderLayerParent) {
            super(renderLayerParent);
        }

        public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, T entity, float f, float g, float h, float j, float k, float l) {
            if (((AdjudicatorStateProvider)entity).getState() != AdjudicatorState.WAITING) {
                super.m_6494_(poseStack, multiBufferSource, i, entity, f, g, h, j, k, l);
            }
        }

        public RenderType m_5708_() {
            return renderType;
        }
    }

    private class InvulnerableFeatureRenderer
    extends EnergySwirlLayer<AdjudicatorEntity, AdjudicatorModel<AdjudicatorEntity>> {
        private final ResourceLocation SKIN;

        public InvulnerableFeatureRenderer(AdjudicatorRender adjudicatorRender2) {
            super((RenderLayerParent)adjudicatorRender2);
            this.SKIN = new ResourceLocation("textures/entity/wither/wither_armor.png");
        }

        protected float m_7631_(float f) {
            return Mth.m_14089_((float)(f * 0.02f)) * 3.0f;
        }

        protected ResourceLocation m_7029_() {
            return this.SKIN;
        }

        protected EntityModel<AdjudicatorEntity> m_7193_() {
            return this.m_117386_();
        }
    }
}

