/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity.mutipart;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.network.protocol.game.ClientboundAddMobPacket;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import party.lemons.biomemakeover.entity.mutipart.EntityPart;
import party.lemons.biomemakeover.util.extension.MultipartHolder;

public interface MultiPartEntity<T extends EntityPart<?>> {
    @OnlyIn(value=Dist.CLIENT)
    public static void handleClientSpawn(ClientboundAddMobPacket packet, MultiPartEntity<?> entity) {
        List<?> parts = entity.getParts();
        for (int i = 0; i < parts.size(); ++i) {
            ((EntityPart)((Object)parts.get(i))).m_20234_(i + packet.m_131552_());
        }
    }

    public static void unload(MultiPartEntity<?> e) {
        for (EntityPart part : e.getParts()) {
            part.m_142687_(Entity.RemovalReason.DISCARDED);
            ((MultipartHolder)part.f_19853_).getPartMap().remove(part.m_142049_(), (Object)part);
        }
    }

    public static void loadParts(MultiPartEntity<?> e) {
        for (EntityPart part : e.getParts()) {
            ((MultipartHolder)part.f_19853_).getPartMap().put(part.m_142049_(), (Object)part);
        }
    }

    public static void onCollectOtherEntities(Entity except, AABB box, Predicate<? super Entity> predicate, MultiPartEntity<?> e, List<Entity> entityList) {
        for (EntityPart part : e.getParts()) {
            if (part == except || !part.m_142469_().m_82381_(box) || predicate != null && !predicate.test(part)) continue;
            entityList.add(part);
        }
    }

    public boolean damagePart(T var1, DamageSource var2, float var3);

    public List<T> getParts();

    default public void updateParts() {
        this.getParts().forEach(p -> {
            p.updatePartPosition();
            p.f_19790_ = p.m_20185_();
            p.f_19791_ = p.m_20186_();
            p.f_19792_ = p.m_20189_();
        });
    }
}

