/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity;

import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.jetbrains.annotations.Nullable;
import party.lemons.biomemakeover.entity.TadpoleEntity;
import party.lemons.biomemakeover.entity.ToadTargetEntity;
import party.lemons.biomemakeover.entity.ai.PredicateTemptGoal;
import party.lemons.biomemakeover.init.BMBlocks;
import party.lemons.biomemakeover.init.BMEffects;
import party.lemons.biomemakeover.init.BMEntities;
import party.lemons.biomemakeover.init.BMItems;
import party.lemons.biomemakeover.util.MathUtils;
import party.lemons.biomemakeover.util.RandomUtil;

public class ToadEntity
extends Animal {
    private static final UUID JUMP_SPEED_BOOST = UUID.fromString("0fa7caca-4f09-11eb-ae93-0242ac130002");
    private static final AttributeModifier JUMP_SPEED_BOOST_MOD = new AttributeModifier(JUMP_SPEED_BOOST, "Jump Speed Boost", (double)0.6f, AttributeModifier.Operation.ADDITION);
    private static final EntityDataAccessor<Integer> TONGUE_ENTITY = SynchedEntityData.m_135353_(ToadEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private boolean onGroundPrev;
    private int ticksUntilJump;
    public float tongueDistance;
    public float targetTongueDistance;
    public float mouthDistance = 0.0f;
    public int eatCooldown = 0;
    public boolean hasBaby;
    private final TargetingConditions predicate = TargetingConditions.m_148353_().m_26888_(e -> e.m_20270_((Entity)e) < 10.0f);

    public ToadEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(TONGUE_ENTITY, (Object)-1);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtTongueTarget(this));
        this.f_21345_.m_25352_(0, (Goal)new MakeTadpoleGoal(this, 1.0, 10));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 0.8));
        this.f_21345_.m_25352_(3, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(3, (Goal)new PredicateTemptGoal((PathfinderMob)this, 1.0, s -> s.m_204117_(BMItems.TOAD_FOOD), false));
        this.f_21345_.m_25352_(11, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.f_21345_.m_25352_(12, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void setTongueEntity(ToadTargetEntity e) {
        this.m_20088_().m_135381_(TONGUE_ENTITY, (Object)e.m_142049_());
        e.setEatenBy(this);
        if (!this.f_19853_.m_5776_()) {
            this.m_5496_(BMEffects.TOAD_MOUTH.get(), 1.0f, 1.0f + (float)this.f_19796_.nextGaussian() / 5.0f);
        }
    }

    public boolean hasTongueEntity() {
        return (Integer)this.m_20088_().m_135370_(TONGUE_ENTITY) != -1;
    }

    public int getTongueEntityID() {
        return (Integer)this.m_20088_().m_135370_(TONGUE_ENTITY);
    }

    public void clearTongueEntity() {
        if (this.f_19853_.m_6815_(this.getTongueEntityID()) != null) {
            ((ToadTargetEntity)this.f_19853_.m_6815_(this.getTongueEntityID())).setEatenBy(null);
        }
        this.m_20088_().m_135381_(TONGUE_ENTITY, (Object)-1);
    }

    public float m_5610_(BlockPos blockPos, LevelReader levelReader) {
        if (levelReader.m_8055_(blockPos).m_204336_(BMBlocks.LILY_PADS)) {
            return 100.0f;
        }
        return super.m_5610_(blockPos, levelReader);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.hasBaby && this.m_146764_() == 0) {
            this.hasBaby = false;
        }
        if (this.hasTongueEntity()) {
            Entity e = this.f_19853_.m_6815_(this.getTongueEntityID());
            if (e != null && !e.m_20159_()) {
                this.m_21563_().m_24950_(e.m_20185_(), e.m_142469_().f_82289_ + 0.25, e.m_20189_(), 100.0f, 100.0f);
                this.f_20883_ = this.getTargetYaw();
                this.f_20885_ = this.getTargetYaw();
                this.m_146926_(this.getTargetPitch());
                float speed = 10.0f;
                this.targetTongueDistance = this.m_20270_(e) * 16.0f - (float)(e.m_142469_().f_82291_ - e.m_142469_().f_82288_) * 16.0f;
                if (this.tongueDistance > this.targetTongueDistance) {
                    speed *= 2.0f;
                }
                this.tongueDistance = MathUtils.approachValue(this.tongueDistance, this.targetTongueDistance, speed);
            } else {
                this.targetTongueDistance = 0.0f;
                this.tongueDistance = MathUtils.approachValue(this.tongueDistance, 0.0f, 20.0f);
            }
        } else {
            this.targetTongueDistance = 0.0f;
            this.tongueDistance = MathUtils.approachValue(this.tongueDistance, 0.0f, 20.0f);
        }
    }

    public boolean isTongueReady() {
        float yaw = Math.abs((this.f_20883_ + 1.0f) % 360.0f - this.getTargetYaw());
        boolean dis = Math.abs(this.tongueDistance - this.targetTongueDistance) < 5.0f;
        return dis && (yaw < 4.0f || yaw >= 360.0f);
    }

    public float getTargetYaw() {
        double xx = this.f_21365_.m_24969_() - this.m_20185_();
        double zz = this.f_21365_.m_24971_() - this.m_20189_();
        return (float)(Mth.m_14136_((double)zz, (double)xx) * 57.2957763671875) - 90.0f;
    }

    public float getTargetPitch() {
        double xx = this.f_21365_.m_24969_() - this.m_20185_();
        double yy = this.f_21365_.m_24970_() - this.m_20188_();
        double zz = this.f_21365_.m_24971_() - this.m_20189_();
        double sqrt = Mth.m_14116_((float)((float)(xx * xx + zz * zz)));
        return (float)(-(Mth.m_14136_((double)yy, (double)sqrt) * 57.2957763671875));
    }

    public boolean canUseTongue() {
        return !this.m_20159_();
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(BMItems.TOAD_FOOD);
    }

    protected void m_8024_() {
        super.m_8024_();
        --this.eatCooldown;
        if (this.eatCooldown <= 0 && !this.hasTongueEntity()) {
            List targets = this.f_19853_.m_6443_(ToadTargetEntity.class, this.m_142469_().m_82377_(3.0, 3.0, 3.0), e -> this.m_142582_((Entity)e) && !e.isBeingEaten());
            ToadTargetEntity closest = (ToadTargetEntity)this.f_19853_.m_45982_(targets, this.predicate, (LivingEntity)this, this.m_20185_(), this.m_20186_(), this.m_20189_());
            if (!this.canUseTongue() || closest == null || closest.m_20159_() || targets.isEmpty()) {
                this.clearTongueEntity();
            } else {
                this.eatCooldown = 350;
                this.setTongueEntity(closest);
            }
        } else {
            Entity e2 = this.f_19853_.m_6815_(this.getTongueEntityID());
            if (!this.canUseTongue() || e2 == null || !e2.m_6084_()) {
                this.clearTongueEntity();
            }
        }
        if (this.ticksUntilJump > 0) {
            --this.ticksUntilJump;
        }
        if (this.ticksUntilJump <= 0 && this.f_21342_.m_24995_()) {
            this.ticksUntilJump = RandomUtil.randomRange(20, 100);
            this.m_6135_();
            AttributeInstance entityAttributeInstance = this.m_21051_(Attributes.f_22279_);
            entityAttributeInstance.m_22120_(JUMP_SPEED_BOOST);
            entityAttributeInstance.m_22118_(JUMP_SPEED_BOOST_MOD);
            this.m_5496_(this.getJumpSound(), this.m_6121_(), ((this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f) * 0.8f);
        }
        if (this.f_19861_ && !this.onGroundPrev) {
            this.m_21051_(Attributes.f_22279_).m_22130_(JUMP_SPEED_BOOST_MOD);
        }
        this.onGroundPrev = this.f_19861_;
    }

    protected SoundEvent getJumpSound() {
        return BMEffects.TOAD_JUMP.get();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return ToadEntity.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("HasBaby", this.hasBaby);
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.hasBaby = compoundTag.m_128471_("HasBaby");
    }

    public void setHasBaby(boolean hasBaby) {
        this.hasBaby = hasBaby;
    }

    public void m_27563_(ServerLevel serverLevel, Animal other) {
        ServerPlayer player = this.m_27592_();
        if (player == null && other.m_27592_() != null) {
            player = other.m_27592_();
        }
        if (player != null) {
            player.m_36220_(Stats.f_12937_);
            CriteriaTriggers.f_10581_.m_147278_(player, (Animal)this, other, null);
        }
        this.setHasBaby(true);
        this.m_146762_(6000);
        other.m_146762_(6000);
        this.m_27594_();
        other.m_27594_();
        serverLevel.m_7605_((Entity)this, (byte)18);
        if (serverLevel.m_46469_().m_46207_(GameRules.f_46135_)) {
            serverLevel.m_7967_((Entity)new ExperienceOrb((Level)serverLevel, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_21187_().nextInt(7) + 1));
        }
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return BMEffects.TOAD_CROAK.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return BMEffects.TOAD_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return BMEffects.TOAD_HURT.get();
    }

    private static class LookAtTongueTarget
    extends Goal {
        private final ToadEntity toad;

        public LookAtTongueTarget(ToadEntity entity) {
            this.toad = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.toad.hasTongueEntity();
        }

        public boolean m_8045_() {
            return this.toad.hasTongueEntity();
        }
    }

    public class MakeTadpoleGoal
    extends MoveToBlockGoal {
        private final ToadEntity toad;

        public MakeTadpoleGoal(ToadEntity toad, double speed, int range) {
            super((PathfinderMob)toad, speed, range, 5);
            this.toad = toad;
        }

        public boolean m_8036_() {
            return this.toad.hasBaby && super.m_8036_();
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.toad.hasBaby;
        }

        public void m_8037_() {
            super.m_8037_();
            BlockPos blockPos = this.f_25598_.m_20097_();
            if (this.m_6669_().m_123314_((Vec3i)this.toad.m_20097_(), 2.0)) {
                ToadEntity.this.m_21573_().m_26519_((double)((float)this.m_6669_().m_123341_() + 0.5f), (double)this.m_6669_().m_123342_(), (double)((float)this.m_6669_().m_123343_() + 0.5f), 1.0);
            }
            if (this.toad.m_20069_()) {
                ServerLevel world = (ServerLevel)this.toad.f_19853_;
                this.toad.setHasBaby(false);
                TadpoleEntity tadpole = (TadpoleEntity)((EntityType)BMEntities.TADPOLE.get()).m_20615_((Level)world);
                if (tadpole != null) {
                    world.m_5594_(null, blockPos, BMEffects.TOAD_HAVE_BABY.get(), SoundSource.BLOCKS, 0.3f, 0.9f + world.f_46441_.nextFloat() * 0.2f);
                    tadpole.m_6863_(true);
                    tadpole.m_7678_(this.toad.m_20185_(), this.toad.m_20186_(), this.toad.m_20189_(), 0.0f, 0.0f);
                    world.m_47205_((Entity)tadpole);
                }
            }
        }

        public double m_8052_() {
            return 0.0;
        }

        protected boolean m_6465_(LevelReader levelReader, BlockPos blockPos) {
            FluidState state = levelReader.m_6425_(blockPos);
            return state.m_76170_() && state.m_205070_(FluidTags.f_13131_) && levelReader.m_8055_(blockPos.m_7494_()).m_60795_();
        }
    }
}

