/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity;

import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.jetbrains.annotations.Nullable;
import party.lemons.biomemakeover.entity.ToadTargetEntity;
import party.lemons.biomemakeover.entity.ai.FlyWanderGoal;
import party.lemons.biomemakeover.init.BMBlocks;
import party.lemons.biomemakeover.init.BMEntities;
import party.lemons.biomemakeover.init.BMItems;
import party.lemons.biomemakeover.util.NetworkUtil;

public class LightningBugEntity
extends ToadTargetEntity
implements FlyingAnimal {
    private LightningBugEntity leader;
    private int groupSize = 1;
    public float scale = this.f_19796_.nextFloat();
    public float prevRed = -1.0f;
    public float prevGreen = -1.0f;
    public float prevBlue = -1.0f;
    private boolean isAlternate = false;

    public LightningBugEntity(EntityType<? extends LightningBugEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 16.0f);
        this.m_21441_(BlockPathTypes.COCOA, -1.0f);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
        this.f_19797_ += level.f_46441_.nextInt(10000);
    }

    public LightningBugEntity(Level level, boolean isAlternate) {
        this((EntityType<? extends LightningBugEntity>)((EntityType)BMEntities.LIGHTNING_BUG_ALTERNATE.get()), level);
        this.isAlternate = true;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LightningBugEntity.m_21552_().m_22268_(Attributes.f_22280_, 0.6).m_22268_(Attributes.f_22276_, 3.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack heldStack = player.m_21120_(hand);
        if (!(heldStack.m_41619_() || heldStack.m_41720_() != Items.f_42590_ && heldStack.m_41720_() != Items.f_42612_)) {
            if (!this.f_19853_.m_5776_()) {
                ItemStack result = ItemUtils.m_41813_((ItemStack)heldStack, (Player)player, (ItemStack)new ItemStack(heldStack.m_41720_() == Items.f_42590_ ? (ItemLike)BMBlocks.LIGHTNING_BUG_BOTTLE.get() : (ItemLike)BMItems.LIGHTNING_BOTTLE.get()));
                player.m_21008_(hand, result);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                player.m_5496_(SoundEvents.f_11770_, 1.0f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void m_6075_() {
        if (this.f_19803_ && !this.isAlternate) {
            for (int i = 0; i < this.f_19796_.nextInt(5); ++i) {
                LightningBugEntity alternate = (LightningBugEntity)((EntityType)BMEntities.LIGHTNING_BUG_ALTERNATE.get()).m_20615_(this.f_19853_);
                alternate.isAlternate = true;
                alternate.m_6027_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                this.f_19853_.m_7967_((Entity)alternate);
            }
        }
        super.m_6075_();
    }

    public float m_5610_(BlockPos blockPos, LevelReader levelReader) {
        return levelReader.m_8055_(blockPos).m_60795_() ? 10.0f : 0.0f;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(8, (Goal)new FlyWanderGoal(this));
        this.f_21345_.m_25352_(9, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new FollowGroupLeaderGoal(this));
    }

    public boolean m_142535_(float f, float g, DamageSource damageSource) {
        return false;
    }

    protected void m_7840_(double d, boolean bl, BlockState blockState, BlockPos blockPos) {
    }

    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation birdNavigation = new FlyingPathNavigation((Mob)this, level){

            public boolean m_6342_(BlockPos blockPos) {
                return !this.f_26495_.m_8055_(blockPos.m_7495_()).m_60795_();
            }
        };
        birdNavigation.m_26443_(true);
        birdNavigation.m_7008_(false);
        birdNavigation.m_26440_(false);
        return birdNavigation;
    }

    public boolean hasLeader() {
        return this.leader != null && this.leader.m_6084_();
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
    }

    public LightningBugEntity joinGroupOf(LightningBugEntity groupLeader) {
        this.leader = groupLeader;
        groupLeader.increaseGroupSize();
        return groupLeader;
    }

    public void leaveGroup() {
        this.leader.decreaseGroupSize();
        this.leader = null;
    }

    private void increaseGroupSize() {
        ++this.groupSize;
    }

    private void decreaseGroupSize() {
        --this.groupSize;
    }

    public boolean canHaveMoreInGroup() {
        return this.hasOthersInGroup() && this.groupSize < this.getMaxGroupSize();
    }

    public boolean hasOthersInGroup() {
        return this.groupSize > 1;
    }

    public boolean isCloseEnoughToLeader() {
        return this.m_20280_((Entity)this.leader) <= 121.0;
    }

    public void m_8119_() {
        List list;
        super.m_8119_();
        if (this.hasOthersInGroup() && this.f_19853_.f_46441_.nextInt(200) == 1 && (list = this.f_19853_.m_45976_(LightningBugEntity.class, this.m_142469_().m_82377_(8.0, 8.0, 8.0))).size() <= 1) {
            this.groupSize = 1;
        }
    }

    public int getMaxGroupSize() {
        return super.m_5792_();
    }

    public int m_5792_() {
        return this.getMaxGroupSize();
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_19796_.nextInt(200) == 0) {
            NetworkUtil.doLightningEntity(this.f_19853_, (LivingEntity)this, 2);
        }
    }

    public void moveTowardLeader() {
        if (this.hasLeader()) {
            this.m_21573_().m_5624_((Entity)this.leader, 1.0);
        }
    }

    public void pullInOthers(Stream<LightningBugEntity> fish) {
        fish.limit(this.getMaxGroupSize() - this.groupSize).filter(e -> e != this).forEach(e -> e.joinGroupOf(this));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        if ((spawnGroupData = super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag)) == null) {
            spawnGroupData = new GroupInfo(this);
        } else {
            this.joinGroupOf(((GroupInfo)spawnGroupData).leader);
        }
        return spawnGroupData;
    }

    public boolean m_142592_() {
        return true;
    }

    public static boolean checkSpawnRules(EntityType<? extends LightningBugEntity> entityType, LevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, Random random) {
        return levelAccessor.m_8055_(blockPos.m_7495_()).m_204336_(BlockTags.f_184228_) && levelAccessor.m_45524_(blockPos, 0) > 8;
    }

    private static class FollowGroupLeaderGoal
    extends Goal {
        private final LightningBugEntity entity;
        private int moveDelay;
        private int checkSurroundingDelay;

        public FollowGroupLeaderGoal(LightningBugEntity entity) {
            this.entity = entity;
            this.checkSurroundingDelay = this.getSurroundingSearchDelay(entity);
        }

        protected int getSurroundingSearchDelay(LightningBugEntity entity) {
            return 200 + entity.m_21187_().nextInt(200) % 20;
        }

        public boolean m_8036_() {
            if (this.entity.hasOthersInGroup()) {
                return false;
            }
            if (this.entity.hasLeader()) {
                return true;
            }
            if (this.checkSurroundingDelay > 0) {
                --this.checkSurroundingDelay;
                return false;
            }
            this.checkSurroundingDelay = this.getSurroundingSearchDelay(this.entity);
            Predicate<LightningBugEntity> predicate = e -> e.canHaveMoreInGroup() || !e.hasLeader();
            List list = this.entity.f_19853_.m_6443_(LightningBugEntity.class, this.entity.m_142469_().m_82377_(8.0, 8.0, 8.0), predicate);
            LightningBugEntity e2 = list.stream().filter(LightningBugEntity::canHaveMoreInGroup).findAny().orElse(this.entity);
            e2.pullInOthers(list.stream().filter(lnb -> !lnb.hasLeader()));
            return this.entity.hasLeader();
        }

        public boolean m_8045_() {
            return this.entity.hasLeader() && this.entity.isCloseEnoughToLeader();
        }

        public void m_8056_() {
            this.moveDelay = 0;
        }

        public void m_8041_() {
            this.entity.leaveGroup();
        }

        public void m_8037_() {
            if (--this.moveDelay <= 0) {
                this.moveDelay = 10;
                this.entity.moveTowardLeader();
            }
        }
    }

    public record GroupInfo(LightningBugEntity leader) implements SpawnGroupData
    {
    }
}

