/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.crafting.witch;

import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import party.lemons.biomemakeover.crafting.witch.QuestItem;
import party.lemons.biomemakeover.crafting.witch.QuestRarity;

public class WitchQuest {
    private final ItemStack[] requiredItems;
    private float rarityPoints;

    public WitchQuest(Random random, List<QuestItem> items) {
        this.requiredItems = new ItemStack[items.size()];
        for (int i = 0; i < items.size(); ++i) {
            QuestItem qi = items.get(i);
            this.rarityPoints += qi.getPoints();
            this.requiredItems[i] = qi.createStack(random);
        }
    }

    public WitchQuest(CompoundTag tag) {
        this.rarityPoints = tag.m_128457_("Points");
        ListTag items = tag.m_128437_("Items", 10);
        this.requiredItems = new ItemStack[items.size()];
        for (int i = 0; i < items.size(); ++i) {
            this.requiredItems[i] = ItemStack.m_41712_((CompoundTag)items.m_128728_(i));
        }
    }

    public WitchQuest(FriendlyByteBuf buffer) {
        this.rarityPoints = buffer.readFloat();
        int length = buffer.readByte() & 0xFF;
        this.requiredItems = new ItemStack[length];
        for (int i = 0; i < length; ++i) {
            this.requiredItems[i] = buffer.m_130267_();
        }
    }

    public ItemStack[] getRequiredItems() {
        return this.requiredItems;
    }

    public boolean hasItems(Container inventory) {
        int size = this.getRequiredItems().length;
        for (int i = 0; i < size; ++i) {
            ItemStack st = this.getRequiredItems()[i];
            int count = inventory.m_18947_(st.m_41720_());
            if (count >= st.m_41613_()) continue;
            return false;
        }
        return true;
    }

    public void consumeItems(Inventory inventory) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack invStack = inventory.m_8020_(i);
            if (invStack.m_41619_()) continue;
            for (ItemStack stack : this.getRequiredItems()) {
                if (stack.m_41619_() || stack.m_41720_() != invStack.m_41720_()) continue;
                if (stack.m_41613_() <= invStack.m_41613_()) {
                    invStack.m_41774_(stack.m_41613_());
                    stack.m_41764_(0);
                    continue;
                }
                stack.m_41774_(invStack.m_41613_());
                invStack.m_41764_(0);
            }
        }
    }

    public float getPoints() {
        return this.rarityPoints;
    }

    public String toString() {
        Object s = "WQ | ";
        for (ItemStack st : this.requiredItems) {
            s = (String)s + st.toString();
        }
        s = (String)s + " | " + QuestRarity.getRarityFromPoints(this.rarityPoints);
        return s;
    }

    public CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128350_("Points", this.rarityPoints);
        ListTag items = new ListTag();
        for (int i = 0; i < this.requiredItems.length; ++i) {
            items.add((Object)this.requiredItems[i].m_41739_(new CompoundTag()));
        }
        tag.m_128365_("Items", (Tag)items);
        return tag;
    }

    public void toPacket(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.rarityPoints);
        int length = this.requiredItems.length;
        buffer.writeByte((int)((byte)(length & 0xFF)));
        for (int i = 0; i < length; ++i) {
            buffer.m_130055_(this.requiredItems[i]);
        }
    }
}

