/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.crafting.witch;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import party.lemons.biomemakeover.init.BMItems;
import party.lemons.biomemakeover.init.BMPotions;
import party.lemons.biomemakeover.util.RandomUtil;

public enum QuestRewardTable {
    ITEMS((LazyLoadedValue<List<RewardItem>>)new LazyLoadedValue(QuestRewardTable::createItemTable)),
    POTION_INGREDIENTS((LazyLoadedValue<List<RewardItem>>)new LazyLoadedValue(QuestRewardTable::createPotionIngredientTable)),
    POTION((LazyLoadedValue<List<RewardItem>>)new LazyLoadedValue(QuestRewardTable::createPotionTable)),
    COMBO_POTION((LazyLoadedValue<List<RewardItem>>)new LazyLoadedValue(QuestRewardTable::createMultiPotionTable));

    private final LazyLoadedValue<List<RewardItem>> itemTable;

    private QuestRewardTable(LazyLoadedValue<List<RewardItem>> itemTable) {
        this.itemTable = itemTable;
    }

    public ItemStack pickRandom(Random random) {
        List rewards = (List)this.itemTable.m_13971_();
        return ((RewardItem)rewards.get(random.nextInt(rewards.size()))).getRewardStack().m_41777_();
    }

    private static List<RewardItem> createItemTable() {
        return Lists.newArrayList((Object[])new RewardItem[]{new ItemStackRewardItem(new ItemStack((ItemLike)Items.f_42590_), 1, 10), new ItemStackRewardItem(new ItemStack((ItemLike)Items.f_42525_), 4, 8), new ItemStackRewardItem(new ItemStack((ItemLike)Items.f_42403_), 2, 10), new ItemStackRewardItem(new ItemStack((ItemLike)Items.f_42451_), 7, 15), new ItemStackRewardItem(new ItemStack((ItemLike)Items.f_42591_), 5, 10), new ItemStackRewardItem(new ItemStack((ItemLike)Items.f_42501_), 8, 10), new ItemStackRewardItem(new ItemStack((ItemLike)Items.f_42398_), 10, 20), new ItemStackRewardItem(new ItemStack((ItemLike)Items.f_42616_), 1, 4), new ItemStackRewardItem(new ItemStack((ItemLike)Items.f_42534_), 1, 10), new ItemStackRewardItem(new ItemStack((ItemLike)Blocks.f_50072_), 3, 5), new ItemStackRewardItem(new ItemStack((ItemLike)Blocks.f_50073_), 3, 5), new ItemStackRewardItem(new ItemStack((ItemLike)Blocks.f_50256_), 1, 5), new ItemStackRewardItem(new ItemStack((ItemLike)BMItems.ILLUNITE_SHARD.get()), 1, 10)});
    }

    private static List<RewardItem> createPotionIngredientTable() {
        return Lists.newArrayList((Object[])new RewardItem[]{new ItemStackRewardItem(new ItemStack((ItemLike)Items.f_42592_), 6, 20), new ItemStackRewardItem(new ItemStack((ItemLike)Items.f_42451_), 12, 32), new ItemStackRewardItem(new ItemStack((ItemLike)Items.f_42525_), 5, 25), new ItemStackRewardItem(new ItemStack((ItemLike)Items.f_42403_), 5, 25), new ItemStackRewardItem(new ItemStack((ItemLike)Items.f_42591_), 5, 32), new ItemStackRewardItem(new ItemStack((ItemLike)Items.f_42546_), 5, 15), new ItemStackRewardItem(new ItemStack((ItemLike)BMItems.SOUL_EMBERS.get()), 3, 5), new ItemStackRewardItem(new ItemStack((ItemLike)Items.f_42586_), 1, 10), new ItemStackRewardItem(new ItemStack((ItemLike)Items.f_42648_), 1, 20), new ItemStackRewardItem(new ItemStack((ItemLike)BMItems.WART.get()), 1, 7)});
    }

    private static List<RewardItem> createPotionTable() {
        return Lists.newArrayList((Object[])new RewardItem[]{new PotionRewardItem(Potions.f_43603_), new PotionRewardItem(Potions.f_43604_), new PotionRewardItem(Potions.f_43605_), new PotionRewardItem(Potions.f_43606_), new PotionRewardItem(Potions.f_43607_), new PotionRewardItem(Potions.f_43608_), new PotionRewardItem(Potions.f_43609_), new PotionRewardItem(Potions.f_43610_), new PotionRewardItem(Potions.f_43611_), new PotionRewardItem(Potions.f_43612_), new PotionRewardItem(Potions.f_43613_), new PotionRewardItem(Potions.f_43614_), new PotionRewardItem(Potions.f_43615_), new PotionRewardItem(Potions.f_43616_), new PotionRewardItem(Potions.f_43617_), new PotionRewardItem(Potions.f_43618_), new PotionRewardItem(Potions.f_43619_), new PotionRewardItem(Potions.f_43620_), new PotionRewardItem(Potions.f_43621_), new PotionRewardItem(Potions.f_43622_), new PotionRewardItem(Potions.f_43623_), new PotionRewardItem(Potions.f_43581_), new PotionRewardItem(Potions.f_43582_), new PotionRewardItem(Potions.f_43583_), new PotionRewardItem(Potions.f_43584_), new PotionRewardItem(Potions.f_43585_), new PotionRewardItem(Potions.f_43586_), new PotionRewardItem(Potions.f_43587_), new PotionRewardItem(Potions.f_43588_), new PotionRewardItem(Potions.f_43589_), new PotionRewardItem(Potions.f_43590_), new PotionRewardItem(Potions.f_43591_), new PotionRewardItem(Potions.f_43592_), new PotionRewardItem(Potions.f_43593_), new PotionRewardItem(Potions.f_43594_), new PotionRewardItem(Potions.f_43595_), new PotionRewardItem(Potions.f_43596_), new PotionRewardItem(Potions.f_43597_), new PotionRewardItem(BMPotions.ANTIDOTE_POT.get()), new ItemStackRewardItem(new ItemStack((ItemLike)BMItems.SWAMP_JIVES_MUSIC_DISK.get()), 1, 1)});
    }

    private static List<RewardItem> createMultiPotionTable() {
        return Lists.newArrayList((Object[])new RewardItem[]{new PotionRewardItem(BMPotions.ADRENALINE.get()), new PotionRewardItem(BMPotions.ASSASSIN.get()), new PotionRewardItem(BMPotions.DARKNESS.get()), new PotionRewardItem(BMPotions.DOLPHIN_MASTER.get()), new PotionRewardItem(BMPotions.LIQUID_BREAD.get()), new PotionRewardItem(BMPotions.PHANTOM_SPIRIT.get()), new PotionRewardItem(BMPotions.LIGHT_FOOTED.get()), new PotionRewardItem(BMPotions.MINER.get())});
    }

    private static interface RewardItem {
        public ItemStack getRewardStack();
    }

    private record ItemStackRewardItem(ItemStack stack, int quantityMin, int quantityMax) implements RewardItem
    {
        @Override
        public ItemStack getRewardStack() {
            ItemStack reward = this.stack.m_41777_();
            reward.m_41764_(RandomUtil.randomRange(this.quantityMin, this.quantityMax));
            return reward;
        }
    }

    private record PotionRewardItem(Potion potion) implements RewardItem
    {
        @Override
        public ItemStack getRewardStack() {
            Item it = Items.f_42589_;
            if (RandomUtil.RANDOM.nextInt(4) == 0) {
                it = RandomUtil.RANDOM.nextInt(3) == 0 ? Items.f_42739_ : Items.f_42736_;
            }
            return PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)it), (Potion)this.potion);
        }
    }
}

