/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.block;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import party.lemons.biomemakeover.block.modifier.BlockModifier;
import party.lemons.biomemakeover.block.modifier.BlockWithModifiers;
import party.lemons.biomemakeover.compat.moretags.MoreTagsCompat;
import party.lemons.biomemakeover.entity.RootlingEntity;
import party.lemons.biomemakeover.init.BMEntities;
import party.lemons.biomemakeover.init.BMItems;

public class RootlingCropBlock
extends CropBlock
implements BlockWithModifiers<RootlingCropBlock> {
    public static final IntegerProperty AGE_4 = IntegerProperty.m_61631_((String)"age", (int)0, (int)4);
    private static final VoxelShape[] AGE_TO_SHAPE = new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};

    public RootlingCropBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return AGE_TO_SHAPE[(Integer)blockState.m_61143_((Property)AGE_4)];
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos blockPos, BlockState newState, boolean bl) {
        super.m_6810_(blockState, level, blockPos, newState, bl);
        if (!level.m_5776_() && newState.m_60734_() == this && this.m_52307_(newState)) {
            level.m_46961_(blockPos, false);
            RootlingEntity rootling = (RootlingEntity)((EntityType)BMEntities.ROOTLING.get()).m_20615_(level);
            rootling.m_7678_((float)blockPos.m_123341_() + 0.5f, blockPos.m_123342_(), (float)blockPos.m_123343_() + 0.5f, level.f_46441_.nextFloat(), level.f_46441_.nextFloat());
            rootling.m_20334_(0.0, 0.25, 0.0);
            rootling.randomizeFlower();
            level.m_7967_((Entity)rootling);
        }
    }

    public int m_7419_() {
        return 4;
    }

    public IntegerProperty m_7959_() {
        return AGE_4;
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        float f;
        int i;
        if (level.m_45524_(pos, 0) >= 9 && (i = this.m_52305_(state)) < this.m_7419_() && random.nextInt((int)(25.0f / (f = RootlingCropBlock.getGrowthSpeed((Block)this, (Level)level, pos))) + 1) == 0) {
            level.m_7731_(pos, this.m_52289_(i + 1), 2);
        }
    }

    protected static float getGrowthSpeed(Block block, Level world, BlockPos pos) {
        boolean bl2;
        float f = 1.0f;
        BlockPos blockPos = pos.m_7495_();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float g = 0.0f;
                BlockState blockState = world.m_8055_(blockPos.m_142082_(i, 0, j));
                if (MoreTagsCompat.CropIsFarmland(blockState)) {
                    g = 1.0f;
                    if ((Integer)blockState.m_61143_((Property)FarmBlock.f_53243_) > 0) {
                        g = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    g /= 4.0f;
                }
                f += g;
            }
        }
        BlockPos blockPos2 = pos.m_142127_();
        BlockPos blockPos3 = pos.m_142128_();
        BlockPos blockPos4 = pos.m_142125_();
        BlockPos blockPos5 = pos.m_142126_();
        boolean bl = block == world.m_8055_(blockPos4).m_60734_() || block == world.m_8055_(blockPos5).m_60734_();
        boolean bl3 = bl2 = block == world.m_8055_(blockPos2).m_60734_() || block == world.m_8055_(blockPos3).m_60734_();
        if (bl && bl2) {
            f /= 2.0f;
        } else {
            boolean bl32;
            boolean bl4 = bl32 = block == world.m_8055_(blockPos4.m_142127_()).m_60734_() || block == world.m_8055_(blockPos5.m_142127_()).m_60734_() || block == world.m_8055_(blockPos5.m_142128_()).m_60734_() || block == world.m_8055_(blockPos4.m_142128_()).m_60734_();
            if (bl32) {
                f /= 2.0f;
            }
        }
        return f;
    }

    protected ItemLike m_6404_() {
        return (ItemLike)BMItems.ROOTLING_SEEDS.get();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{this.m_7959_()});
    }

    @Override
    public RootlingCropBlock modifiers(BlockModifier ... modifiers) {
        BlockWithModifiers.init(this, modifiers);
        return this;
    }
}

