/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.foundation.data.lang;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.simibubi.create.foundation.utility.FilesHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.util.GsonHelper;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import plus.dragons.createenchantmentindustry.foundation.data.lang.LangPartials;

public class LangMerger
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    static final String CATEGORY_HEADER = "\t\"_\": \"->------------------------]  %s  [------------------------<-\",";
    private DataGenerator gen;
    private List<Object> mergedLangData;
    private Map<String, List<Object>> populatedLangData;
    private Map<String, Map<String, String>> allLocalizedEntries;
    private Map<String, MutableInt> missingTranslationTally;
    private Map<String, MutableInt> existingButActuallyMissingTranslationTally;
    private List<String> langIgnore;

    public LangMerger(DataGenerator gen) {
        this.gen = gen;
        this.mergedLangData = new ArrayList<Object>();
        this.langIgnore = new ArrayList<String>();
        this.allLocalizedEntries = new HashMap<String, Map<String, String>>();
        this.populatedLangData = new HashMap<String, List<Object>>();
        this.missingTranslationTally = new HashMap<String, MutableInt>();
        this.existingButActuallyMissingTranslationTally = new HashMap<String, MutableInt>();
    }

    private void populateLangIgnore() {
    }

    private boolean shouldIgnore(String key) {
        for (String string : this.langIgnore) {
            if (!key.startsWith(string)) continue;
            return true;
        }
        return false;
    }

    public String m_6055_() {
        return "Lang merger";
    }

    public void m_6865_(HashCache cache) throws IOException {
        String key;
        Path path = this.gen.m_123916_().resolve("assets/create_enchantment_industry/lang/en_us.json");
        for (Pair<String, JsonElement> pair : this.getAllLocalizationFiles()) {
            key = (String)pair.getKey();
            if (!((JsonElement)pair.getRight()).isJsonObject()) continue;
            HashMap localizedEntries = new HashMap();
            JsonObject jsonobject = ((JsonElement)pair.getRight()).getAsJsonObject();
            this.existingButActuallyMissingTranslationTally.put(key, new MutableInt(0));
            jsonobject.entrySet().stream().forEachOrdered(entry -> {
                String key2 = (String)entry.getKey();
                if (key2.startsWith("_")) {
                    return;
                }
                String value = ((JsonElement)entry.getValue()).getAsString();
                if (value.startsWith("UNLOCALIZED: ")) {
                    this.existingButActuallyMissingTranslationTally.get(key).increment();
                }
                localizedEntries.put(key2, value);
            });
            this.allLocalizedEntries.put(key, localizedEntries);
            this.populatedLangData.put(key, new ArrayList());
            this.missingTranslationTally.put(key, new MutableInt(0));
        }
        this.collectExistingEntries(path);
        this.collectEntries();
        if (this.mergedLangData.isEmpty()) {
            return;
        }
        this.save(cache, this.mergedLangData, -1, path, "Merging en_us.json with hand-written lang entries...");
        for (Map.Entry entry2 : this.populatedLangData.entrySet()) {
            key = (String)entry2.getKey();
            Path populatedLangPath = this.gen.m_123916_().resolve("assets/create_enchantment_industry/lang/unfinished/" + key);
            this.save(cache, (List)entry2.getValue(), this.missingTranslationTally.get(key).intValue() + this.existingButActuallyMissingTranslationTally.get(key).intValue(), populatedLangPath, "Populating " + key + " with missing entries...");
        }
    }

    private void collectExistingEntries(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            LOGGER.warn("Nothing to merge! It appears no lang was generated before me.");
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            JsonObject jsonobject = (JsonObject)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonObject.class);
            this.addAll("Game Elements", jsonobject);
        }
    }

    protected void addAll(String header, JsonObject jsonobject) {
        if (jsonobject == null) {
            return;
        }
        header = String.format(CATEGORY_HEADER, header);
        this.writeData("\n");
        this.writeData(header);
        this.writeData("\n\n");
        MutableObject previousKey = new MutableObject((Object)"");
        jsonobject.entrySet().stream().forEachOrdered(entry -> {
            String key = (String)entry.getKey();
            if (this.shouldIgnore(key)) {
                return;
            }
            String value = ((JsonElement)entry.getValue()).getAsString();
            if (!((String)previousKey.getValue()).isEmpty() && this.shouldAddLineBreak(key, (String)previousKey.getValue())) {
                this.writeData("\n");
            }
            this.writeEntry(key, value);
            previousKey.setValue((Object)key);
        });
        this.writeData("\n");
    }

    private void writeData(String data) {
        this.mergedLangData.add(data);
        this.populatedLangData.values().forEach(l -> l.add(data));
    }

    private void writeEntry(String key, String value) {
        this.mergedLangData.add(new LangEntry(key, value));
        this.populatedLangData.forEach((k, l) -> {
            ForeignLangEntry entry = new ForeignLangEntry(key, value, this.allLocalizedEntries.get(k));
            if (entry.isMissing()) {
                this.missingTranslationTally.get(k).increment();
            }
            l.add(entry);
        });
    }

    protected boolean shouldAddLineBreak(String key, String previousKey) {
        if (key.endsWith(".tooltip")) {
            return true;
        }
        if (key.startsWith("create_enchantment_industry.ponder") && key.endsWith("header")) {
            return true;
        }
        key = key.replaceFirst("\\.", "");
        previousKey = previousKey.replaceFirst("\\.", "");
        String[] split = key.split("\\.");
        String[] split2 = previousKey.split("\\.");
        if (split.length == 0 || split2.length == 0) {
            return false;
        }
        return !split[0].equals(split2[0]);
    }

    private List<Pair<String, JsonElement>> getAllLocalizationFiles() {
        ArrayList<Pair<String, JsonElement>> list = new ArrayList<Pair<String, JsonElement>>();
        String filepath = "assets/create_enchantment_industry/lang/";
        try (InputStream resourceStream = ClassLoader.getSystemResourceAsStream(filepath);){
            String readLine;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(resourceStream));
            while ((readLine = bufferedReader.readLine()) != null) {
                if (!readLine.endsWith(".json") || readLine.startsWith("en_us") || readLine.startsWith("en_ud")) continue;
                list.add((Pair<String, JsonElement>)Pair.of((Object)readLine, (Object)FilesHelper.loadJsonResource((String)(filepath + readLine))));
            }
        }
        catch (IOException | NullPointerException e) {
            e.printStackTrace();
        }
        return list;
    }

    private void collectEntries() {
        for (LangPartials partial : LangPartials.values()) {
            this.addAll(partial.getDisplay(), partial.provide().getAsJsonObject());
        }
    }

    private void save(HashCache cache, List<Object> dataIn, int missingKeys, Path target, String message) throws IOException {
        String data = this.createString(dataIn, missingKeys);
        String hash = DataProvider.f_123918_.hashUnencodedChars((CharSequence)data).toString();
        if (!Objects.equals(cache.m_123938_(target), hash) || !Files.exists(target, new LinkOption[0])) {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            try (BufferedWriter bufferedwriter = Files.newBufferedWriter(target, new OpenOption[0]);){
                LOGGER.info(message);
                bufferedwriter.write(data);
                bufferedwriter.close();
            }
        }
        cache.m_123940_(target, hash);
    }

    protected String createString(List<Object> data, int missingKeys) {
        StringBuilder builder = new StringBuilder();
        builder.append("{\n");
        if (missingKeys != -1) {
            builder.append("\t\"_\": \"Missing Localizations: ").append(missingKeys).append("\",\n");
        }
        data.forEach(builder::append);
        builder.append("\t\"_\": \"Thank you for translating Create: Enchantment Industry!\"\n\n");
        builder.append("}");
        return builder.toString();
    }

    private class LangEntry {
        static final String ENTRY_FORMAT = "\t\"%s\": %s,\n";
        private String key;
        private String value;

        LangEntry(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return String.format(ENTRY_FORMAT, this.key, GSON.toJson((Object)this.value, String.class));
        }
    }

    private class ForeignLangEntry
    extends LangEntry {
        private boolean missing;

        ForeignLangEntry(String key, String value, Map<String, String> localizationMap) {
            super(key, localizationMap.getOrDefault(key, "UNLOCALIZED: " + value));
            this.missing = !localizationMap.containsKey(key);
        }

        public boolean isMissing() {
            return this.missing;
        }
    }
}

