/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.compat.quark;

import com.simibubi.create.foundation.utility.LangBuilder;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import plus.dragons.createenchantmentindustry.EnchantmentIndustry;
import plus.dragons.createenchantmentindustry.api.PrintEntryRegisterEvent;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.enchanter.Enchanting;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.printer.PrintEntry;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.printer.Printing;
import plus.dragons.createenchantmentindustry.entry.CeiFluids;
import plus.dragons.createenchantmentindustry.foundation.config.CeiConfigs;
import plus.dragons.createenchantmentindustry.foundation.utility.CeiLang;

public class QuarkCompat {
    public static void registerPrintEntry() {
        if (ModList.get().isLoaded("quark")) {
            MinecraftForge.EVENT_BUS.addListener(QuarkCompat::register);
        }
    }

    private static void register(PrintEntryRegisterEvent event) {
        event.register(new PrintEntry(){
            private final ResourceLocation id = new ResourceLocation("quark", "ancient_tome");

            @Override
            @NotNull
            public ResourceLocation id() {
                return EnchantmentIndustry.genRL("ancient_tome");
            }

            @Override
            public boolean match(@NotNull ItemStack toPrint) {
                return ((Holder)ForgeRegistries.ITEMS.getHolder((IForgeRegistryEntry)toPrint.m_41720_()).get()).m_203373_(this.id);
            }

            @Override
            public boolean valid(@NotNull ItemStack target, @NotNull ItemStack tested) {
                return tested.m_150930_(Items.f_42690_);
            }

            @Override
            public int requiredInkAmount(@NotNull ItemStack target) {
                Enchantment enchantment = 1.getTomeEnchantment(target);
                return enchantment.m_6183_(1) + Enchanting.rarityLevel(enchantment.m_44699_());
            }

            @Override
            @NotNull
            public Fluid requiredInkType(@NotNull ItemStack target) {
                return (Fluid)CeiFluids.HYPER_EXPERIENCE.get();
            }

            @Override
            public boolean isTooExpensive(@NotNull ItemStack target, int limit) {
                return limit < this.requiredInkAmount(target);
            }

            @Override
            public void addToGoggleTooltip(@NotNull List<Component> tooltip, boolean isPlayerSneaking, @NotNull ItemStack target) {
                LangBuilder b = CeiLang.itemName(target).style(ChatFormatting.DARK_PURPLE);
                b.forGoggles(tooltip, 1);
                boolean tooExpensive = Printing.isTooExpensive(this, target, (Integer)CeiConfigs.SERVER.copierTankCapacity.get());
                if (tooExpensive) {
                    tooltip.add((Component)new TextComponent("     ").m_7220_((Component)CeiLang.translate("gui.goggles.too_expensive", new Object[0]).component()).m_130940_(ChatFormatting.RED));
                } else {
                    tooltip.add((Component)new TextComponent("     ").m_7220_((Component)CeiLang.translate("gui.goggles.xp_consumption", String.valueOf(this.requiredInkAmount(target))).component()).m_130940_(ChatFormatting.AQUA));
                }
                Enchantment e = 1.getTomeEnchantment(target);
                if (e != null) {
                    tooltip.add((Component)new TextComponent("     ").m_7220_(1.getFullTooltipText(e)).m_130940_(ChatFormatting.GRAY));
                }
            }

            @Override
            @NotNull
            public MutableComponent getDisplaySourceContent(@NotNull ItemStack target) {
                LangBuilder ret = CeiLang.itemName(target);
                Enchantment e = 1.getTomeEnchantment(target);
                if (e != null) {
                    ret.text(" / ");
                    ret.add(1.getFullTooltipText(e).m_6881_());
                }
                return ret.component();
            }

            private static Enchantment getTomeEnchantment(ItemStack stack) {
                ListTag list = EnchantedBookItem.m_41163_((ItemStack)stack);
                for (int i = 0; i < list.size(); ++i) {
                    CompoundTag nbt = list.m_128728_(i);
                    Enchantment enchant = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ResourceLocation.m_135820_((String)nbt.m_128461_("id")));
                    if (enchant == null) continue;
                    return enchant;
                }
                return null;
            }

            public static Component getFullTooltipText(Enchantment ench) {
                return new TranslatableComponent("quark.misc.ancient_tome_tooltip", new Object[]{new TranslatableComponent(ench.m_44704_()), new TranslatableComponent("enchantment.level." + (ench.m_6586_() + 1))});
            }
        });
    }
}

