/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.debugify.mixins.basic.client.mc197260;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.FixCategory;
import java.util.stream.IntStream;
import net.minecraft.client.model.ArmorStandArmorModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ArmorStandRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.level.LightLayer;
import org.spongepowered.asm.mixin.Mixin;

@BugFix(id="MC-197260", category=FixCategory.BASIC, env=BugFix.Env.CLIENT)
@Mixin(value={ArmorStandRenderer.class})
public abstract class ArmorStandEntityRendererMixin
extends LivingEntityRenderer<ArmorStand, ArmorStandArmorModel> {
    public ArmorStandEntityRendererMixin(EntityRendererProvider.Context ctx, ArmorStandArmorModel model, float shadowRadius) {
        super(ctx, (EntityModel)model, shadowRadius);
    }

    public void render(ArmorStand livingEntity, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int providedLightLevel) {
        int maxLightLevel = Math.max(providedLightLevel, IntStream.of(-1, 2, 3).map(operand -> {
            BlockPos pos = livingEntity.m_142538_().m_142082_(0, operand, 0);
            return LightTexture.m_109885_((int)livingEntity.f_19853_.m_45517_(LightLayer.BLOCK, pos), (int)livingEntity.f_19853_.m_45517_(LightLayer.SKY, pos));
        }).max().orElse(providedLightLevel));
        super.m_7392_((LivingEntity)livingEntity, f, g, matrixStack, vertexConsumerProvider, maxLightLevel);
    }
}

