/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.debugify.mixins.basic.client.mc148149;

import dev.isxander.debugify.Debugify;
import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.FixCategory;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@BugFix(id="MC-148149", category=FixCategory.BASIC, env=BugFix.Env.CLIENT, fabricConflicts={"fastopenlinksandfolders"})
@Mixin(value={Util.OS.class})
public abstract class OperatingSystemMixin {
    @Shadow
    public abstract void m_137650_(URL var1);

    @Inject(method={"open(Ljava/net/URI;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void openUri(URI uri, CallbackInfo ci) {
        CompletableFuture.runAsync(() -> {
            try {
                this.m_137650_(uri.toURL());
            }
            catch (MalformedURLException e) {
                Debugify.logger.error("Couldn't open uri '" + uri + "'");
                e.printStackTrace();
            }
        });
        ci.cancel();
    }

    @Inject(method={"open(Ljava/io/File;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void openFile(File file, CallbackInfo ci) {
        CompletableFuture.runAsync(() -> {
            try {
                this.m_137650_(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                Debugify.logger.error("Couldn't open file '" + file + "'");
                e.printStackTrace();
            }
        });
        ci.cancel();
    }
}

