/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.proxy;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.zerono.mods.extremereactors.ExtremeReactors;
import it.zerono.mods.extremereactors.api.reactor.ModeratorsRegistry;
import it.zerono.mods.extremereactors.api.reactor.ReactantMappingsRegistry;
import it.zerono.mods.extremereactors.api.turbine.CoilMaterialRegistry;
import it.zerono.mods.extremereactors.config.Config;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.compat.patchouli.PatchouliCompat;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.CachedSprites;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.ChargingPortScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.FluidPortScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.client.model.FluidizerGlassModelBuilder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.client.model.FluidizerModelBuilder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.client.screen.FluidizerControllerScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.client.screen.FluidizerSolidInjectorScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.FuelRodsLayout;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.ClientFuelRodsLayout;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.model.ReactorFuelRodBlockColor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.model.ReactorFuelRodModelBuilder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.model.ReactorGlassModelBuilder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.model.ReactorModelBuilder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.screen.ReactorControlRodScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.screen.ReactorControllerScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.screen.ReactorFluidAccessPortScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.screen.ReactorRedstonePortScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.screen.ReactorSolidAccessPortScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.variant.IMultiblockReactorVariant;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.variant.ReactorVariant;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.client.model.ReprocessorGlassModelBuilder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.client.model.ReprocessorIOModelBuilder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.client.model.ReprocessorModelBuilder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.client.render.ReprocessorCollectorRender;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.client.screen.ReprocessorAccessPortScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.client.screen.ReprocessorControllerScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.model.TurbineGlassModelBuilder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.model.TurbineModelBuilder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.model.TurbineRotorModelBuilder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.render.rotor.RotorBearingEntityRenderer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.screen.TurbineControllerScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.screen.TurbineRedstonePortScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.variant.IMultiblockTurbineVariant;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.variant.TurbineVariant;
import it.zerono.mods.extremereactors.proxy.IProxy;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.client.model.BlockVariantsModelBuilder;
import it.zerono.mods.zerocore.lib.client.model.ICustomModelBuilder;
import it.zerono.mods.zerocore.lib.client.model.ModBakedModelSupplier;
import it.zerono.mods.zerocore.lib.compat.Mods;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class ClientProxy
implements IProxy,
ResourceManagerReloadListener {
    private static final ModBakedModelSupplier s_bakedModelSupplier = new ModBakedModelSupplier();
    private final List<ICustomModelBuilder> _modelBuilders = ClientProxy.initModels();
    private Map<Item, Set<Component>> _apiTooltipCache;

    public ClientProxy() {
        IEventBus bus = (IEventBus)Mod.EventBusSubscriber.Bus.MOD.bus().get();
        bus.register((Object)this);
        bus = (IEventBus)Mod.EventBusSubscriber.Bus.FORGE.bus().get();
        bus.addListener(this::onItemTooltip);
        bus.addListener(EventPriority.LOWEST, this::onVanillaTagsUpdated);
        bus.addListener(this::onTextureStitchPre);
        CodeHelper.addResourceReloadListener((PreparableReloadListener)this);
    }

    public static Supplier<BakedModel> getModelSupplier(ResourceLocation modelId) {
        return s_bakedModelSupplier.getOrCreate(modelId);
    }

    @SubscribeEvent
    public void onClientInit(FMLClientSetupEvent event) {
        CachedSprites.initialize();
        event.enqueueWork(() -> {
            ClientProxy.registerRenderTypes();
            ClientProxy.registerTileRenderers();
            ClientProxy.registerScreens();
            Mods.PATCHOULI.ifPresent(PatchouliCompat::initialize);
        });
    }

    @SubscribeEvent
    public void onRegisterModels(ModelRegistryEvent event) {
        this._modelBuilders.forEach(ICustomModelBuilder::onRegisterModels);
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        this._modelBuilders.forEach(builder -> builder.onBakeModels(event));
    }

    @SubscribeEvent
    public void onTextureStitchPre(TextureStitchEvent.Pre event) {
        if (!event.getAtlas().m_118330_().equals((Object)InventoryMenu.f_39692_)) {
            return;
        }
        event.addSprite(CachedSprites.GUI_CHARGINGPORT_SLOT_ID);
    }

    public void onItemTooltip(ItemTooltipEvent event) {
        if (!((Boolean)Config.CLIENT.disableApiTooltips.get()).booleanValue() && event.getFlags().m_7050_()) {
            event.getToolTip().addAll(this.getApiTooltipCache().getOrDefault(event.getItemStack().m_41720_(), Collections.emptySet()));
        }
    }

    @SubscribeEvent
    public void onColorHandlerEvent(ColorHandlerEvent.Block event) {
        event.getBlockColors().m_92589_((BlockColor)new ReactorFuelRodBlockColor(), new Block[]{(Block)Content.Blocks.REACTOR_FUELROD_BASIC.get(), (Block)Content.Blocks.REACTOR_FUELROD_REINFORCED.get()});
    }

    @Override
    public FuelRodsLayout createFuelRodsLayout(Direction direction, int length) {
        return new ClientFuelRodsLayout(direction, length);
    }

    public void m_6213_(ResourceManager resourceManager) {
        this.invalidateApiTooltipCache();
    }

    private static List<ICustomModelBuilder> initModels() {
        return (List)Streams.concat((Stream[])new Stream[]{Arrays.stream(ReactorVariant.values()).flatMap(v -> Stream.of(new ICustomModelBuilder[]{new ReactorModelBuilder((ReactorVariant)v), new ReactorGlassModelBuilder((IMultiblockReactorVariant)v), new ReactorFuelRodModelBuilder((IMultiblockReactorVariant)v)})), Arrays.stream(TurbineVariant.values()).flatMap(v -> Stream.of(new BlockVariantsModelBuilder[]{new TurbineModelBuilder((TurbineVariant)v), new TurbineGlassModelBuilder((IMultiblockTurbineVariant)v), new TurbineRotorModelBuilder((IMultiblockTurbineVariant)v)})), Stream.of(new BlockVariantsModelBuilder[]{new ReprocessorModelBuilder(), new ReprocessorIOModelBuilder(), new ReprocessorGlassModelBuilder(), new FluidizerModelBuilder(), new FluidizerGlassModelBuilder()})}).collect(ImmutableList.toImmutableList());
    }

    private static void registerScreens() {
        ClientProxy.registerScreen(Content.ContainerTypes.REACTOR_CONTROLLER, ReactorControllerScreen::new);
        ClientProxy.registerScreen(Content.ContainerTypes.REACTOR_SOLID_ACCESSPORT, ReactorSolidAccessPortScreen::new);
        ClientProxy.registerScreen(Content.ContainerTypes.REACTOR_FLUID_ACCESSPORT, ReactorFluidAccessPortScreen::new);
        ClientProxy.registerScreen(Content.ContainerTypes.REACTOR_REDSTONEPORT, ReactorRedstonePortScreen::new);
        ClientProxy.registerScreen(Content.ContainerTypes.REACTOR_CONTROLROD, ReactorControlRodScreen::new);
        ClientProxy.registerScreen(Content.ContainerTypes.REACTOR_CHARGINGPORT, (container, inventory, title) -> new ChargingPortScreen(container, inventory, title, ExtremeReactors.newID("reactor/part-forgechargingport")));
        ClientProxy.registerScreen(Content.ContainerTypes.REACTOR_FLUIDPORT, (container, inventory, title) -> new FluidPortScreen(container, inventory, title, ExtremeReactors.newID("reactor/part-forgefluidport")));
        ClientProxy.registerScreen(Content.ContainerTypes.TURBINE_CONTROLLER, TurbineControllerScreen::new);
        ClientProxy.registerScreen(Content.ContainerTypes.TURBINE_CHARGINGPORT, (container, inventory, title) -> new ChargingPortScreen(container, inventory, title, ExtremeReactors.newID("turbine/part-forgechargingport")));
        ClientProxy.registerScreen(Content.ContainerTypes.TURBINE_FLUIDPORT, (container, inventory, title) -> new FluidPortScreen(container, inventory, title, ExtremeReactors.newID("turbine/part-forgefluidport")));
        ClientProxy.registerScreen(Content.ContainerTypes.TURBINE_REDSTONEPORT, TurbineRedstonePortScreen::new);
        ClientProxy.registerScreen(Content.ContainerTypes.REPROCESSOR_CONTROLLER, ReprocessorControllerScreen::new);
        ClientProxy.registerScreen(Content.ContainerTypes.REPROCESSOR_ACCESSPORT, ReprocessorAccessPortScreen::new);
        ClientProxy.registerScreen(Content.ContainerTypes.FLUIDIZER_SOLID_INJECTOR, FluidizerSolidInjectorScreen::new);
        ClientProxy.registerScreen(Content.ContainerTypes.FLUIDIZER_CONTROLLER, FluidizerControllerScreen::new);
    }

    private static void registerRenderTypes() {
        ClientProxy.registerRenderType(RenderType.m_110466_(), new Supplier[]{Content.Blocks.REACTOR_GLASS_BASIC, Content.Blocks.REACTOR_GLASS_REINFORCED, Content.Blocks.TURBINE_GLASS_BASIC, Content.Blocks.TURBINE_GLASS_REINFORCED, Content.Blocks.REPROCESSOR_GLASS, Content.Blocks.FLUIDIZER_GLASS});
        ClientProxy.registerRenderType(RenderType.m_110463_(), new Supplier[]{Content.Blocks.TURBINE_ROTORBLADE_BASIC, Content.Blocks.TURBINE_ROTORBLADE_REINFORCED, Content.Blocks.TURBINE_ROTORSHAFT_BASIC, Content.Blocks.TURBINE_ROTORSHAFT_REINFORCED});
    }

    private static void registerTileRenderers() {
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)Content.TileEntityTypes.TURBINE_ROTORBEARING.get()), RotorBearingEntityRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)Content.TileEntityTypes.REPROCESSOR_COLLECTOR.get()), ReprocessorCollectorRender::new);
    }

    private static <M extends AbstractContainerMenu, U extends Screen> void registerScreen(Supplier<? extends MenuType<? extends M>> type, MenuScreens.ScreenConstructor<M, U> factory) {
        MenuScreens.m_96206_(type.get(), factory);
    }

    @SafeVarargs
    private static void registerRenderType(RenderType type, Supplier<? extends Block> ... blocks) {
        for (Supplier<? extends Block> block : blocks) {
            ItemBlockRenderTypes.setRenderLayer((Block)block.get(), (RenderType)type);
        }
    }

    private void onVanillaTagsUpdated(TagsUpdatedEvent event) {
        this.invalidateApiTooltipCache();
    }

    private Map<Item, Set<Component>> getApiTooltipCache() {
        if (null == this._apiTooltipCache) {
            this._apiTooltipCache = ClientProxy.buildApiTooltipCache();
        }
        return this._apiTooltipCache;
    }

    private void invalidateApiTooltipCache() {
        this._apiTooltipCache = null;
    }

    private static Map<Item, Set<Component>> buildApiTooltipCache() {
        HashMap wipCache = Maps.newHashMap();
        ReactantMappingsRegistry.fillReactantsTooltips(wipCache, (NonNullSupplier<Set<Component>>)((NonNullSupplier)Sets::newHashSet));
        ModeratorsRegistry.fillModeratorsTooltips(wipCache, (NonNullSupplier<Set<Component>>)((NonNullSupplier)Sets::newHashSet));
        CoilMaterialRegistry.fillCoilsTooltips(wipCache, (NonNullSupplier<Set<Component>>)((NonNullSupplier)Sets::newHashSet));
        return new Object2ObjectArrayMap((Map)wipCache);
    }
}

