/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part;

import it.zerono.mods.extremereactors.config.Config;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.MultiblockTurbine;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.TurbinePartType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineRotorBearingEntity;
import it.zerono.mods.zerocore.base.multiblock.part.GenericDeviceBlock;
import it.zerono.mods.zerocore.lib.block.multiblock.MultiblockPartBlock;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TurbineRotorBearingBlock
extends GenericDeviceBlock<MultiblockTurbine, TurbinePartType> {
    public TurbineRotorBearingBlock(MultiblockPartBlock.MultiblockPartProperties<TurbinePartType> properties) {
        super(properties);
    }

    public boolean m_6104_(BlockState state, BlockState adjacentBlockState, Direction side) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState state, Level world, BlockPos position, Random random) {
        if (((Boolean)Config.CLIENT.disableTurbineParticles.get()).booleanValue()) {
            return;
        }
        TurbineRotorBearingBlock.getTile((BlockGetter)world, position).ifPresent(bearing -> this.animateTick((TurbineRotorBearingEntity)((Object)bearing), world, position, random));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(TurbineRotorBearingEntity bearing, Level world, BlockPos pos, Random random) {
        bearing.getMultiblockController().filter(turbine -> !turbine.isInteriorInvisible()).filter(MultiblockTurbine::isAssembledAndActive).ifPresent(turbine -> turbine.forBoundingBoxCoordinates((min, max) -> {
            int numParticles = Math.min(20, Math.max(1, turbine.getFluidConsumedLastTick() / 40));
            BlockPos minCoord = min.m_142082_(1, 1, 1);
            BlockPos maxCoord = max.m_142082_(-1, -1, -1);
            Direction inwardsDir = bearing.getOutwardDirection().map(Direction::m_122424_).orElse(Direction.UP);
            int offsetX = inwardsDir.m_122429_();
            int offsetY = inwardsDir.m_122430_();
            int offsetZ = inwardsDir.m_122431_();
            SimpleParticleType particle = ParticleTypes.f_123796_;
            int minX = minCoord.m_123341_();
            int minY = minCoord.m_123342_();
            int minZ = minCoord.m_123343_();
            int maxX = maxCoord.m_123341_();
            int maxY = maxCoord.m_123342_();
            int maxZ = maxCoord.m_123343_();
            if (offsetX != 0) {
                minX = maxX = pos.m_123341_() + offsetX;
            } else if (offsetY != 0) {
                minY = maxY = pos.m_123342_() + offsetY;
            } else {
                minZ = maxZ = pos.m_123343_() + offsetZ;
            }
            for (int i = 0; i < numParticles; ++i) {
                int particleX = minX + (int)(random.nextFloat() * (float)(maxX - minX + 1));
                int particleY = minY + (int)(random.nextFloat() * (float)(maxY - minY + 1));
                int particleZ = minZ + (int)(random.nextFloat() * (float)(maxZ - minZ + 1));
                WorldHelper.spawnVanillaParticles((Level)world, (ParticleOptions)particle, (int)1, (int)numParticles, (int)particleX, (int)particleY, (int)particleZ, (int)0, (int)0, (int)0);
            }
        }));
    }

    private static Optional<TurbineRotorBearingEntity> getTile(BlockGetter world, BlockPos position) {
        return WorldHelper.getTile((BlockGetter)world, (BlockPos)position).filter(te -> te instanceof TurbineRotorBearingEntity).map(te -> (TurbineRotorBearingEntity)((Object)te));
    }
}

