/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part;

import it.zerono.mods.extremereactors.Log;
import it.zerono.mods.extremereactors.api.IMapping;
import it.zerono.mods.extremereactors.api.reactor.Reactant;
import it.zerono.mods.extremereactors.api.reactor.ReactantMappingsRegistry;
import it.zerono.mods.extremereactors.api.reactor.ReactantType;
import it.zerono.mods.extremereactors.gamecontent.CommonConstants;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.IFuelSource;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.MultiblockReactor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.ReactantHelper;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.container.ReactorSolidAccessPortContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.AbstractReactorEntity;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.DebuggableHelper;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.block.INeighborChangeListener;
import it.zerono.mods.zerocore.lib.block.TileCommandDispatcher;
import it.zerono.mods.zerocore.lib.data.IIoEntity;
import it.zerono.mods.zerocore.lib.data.IoDirection;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.item.ItemHelper;
import it.zerono.mods.zerocore.lib.item.inventory.handler.ItemHandlerModifiableForwarder;
import it.zerono.mods.zerocore.lib.item.inventory.handler.TileEntityItemStackHandler;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockController;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class ReactorSolidAccessPortEntity
extends AbstractReactorEntity
implements IFuelSource<ItemStack>,
IIoEntity,
INeighborChangeListener,
MenuProvider {
    private static Capability<IItemHandler> ITEM_HANDLER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IItemHandler>(){});
    private final TileEntityItemStackHandler _fuelInventory;
    private final TileEntityItemStackHandler _wasteInventory;
    private final LazyOptional<IItemHandlerModifiable> _fuelCapability;
    private final LazyOptional<IItemHandlerModifiable> _wasteCapability;
    private IoDirection _direction;

    public ReactorSolidAccessPortEntity(BlockPos position, BlockState blockState) {
        super((BlockEntityType)Content.TileEntityTypes.REACTOR_SOLID_ACCESSPORT.get(), position, blockState);
        this.setIoDirection(IoDirection.Input);
        this._fuelInventory = new TileEntityItemStackHandler((BlockEntity)this, 1);
        this._wasteInventory = new TileEntityItemStackHandler((BlockEntity)this, 1);
        this._fuelCapability = LazyOptional.of(this::createFuelCapability);
        this._wasteCapability = LazyOptional.of(this::createWasteCapability);
        this.setCommandDispatcher(TileCommandDispatcher.builder().addServerHandler(CommonConstants.COMMAND_SET_INPUT, tile -> tile.setIoDirection(IoDirection.Input)).addServerHandler(CommonConstants.COMMAND_SET_OUTPUT, tile -> tile.setIoDirection(IoDirection.Output)).addServerHandler(CommonConstants.COMMAND_DUMP_FUEL, ReactorSolidAccessPortEntity::handleCommandEjectFuel).addServerHandler(CommonConstants.COMMAND_DUMP_WASTE, ReactorSolidAccessPortEntity::handleCommandEjectWaste).build((AbstractModBlockEntity)this));
    }

    public IItemHandlerModifiable getItemStackHandler(ReactantType type) {
        return type.isFuel() ? this._fuelInventory : this._wasteInventory;
    }

    public void onItemsReceived() {
        this.distributeItems();
        this.markChunkDirty();
    }

    @Override
    protected int getUpdatedModelVariantIndex() {
        int connectedOffset = this.isMachineAssembled() && this.getNeighborCapability().isPresent() ? 1 : 0;
        return this.getIoDirection().isInput() ? 2 + connectedOffset : 0 + connectedOffset;
    }

    @Override
    public ItemStack getFuelStack() {
        return this.getStack(ReactantType.Fuel);
    }

    @Override
    public ItemStack consumeFuelSource(ItemStack sourceToConsume) {
        ItemStack sourceStack = this.getStack(ReactantType.Fuel);
        if (!sourceStack.m_41619_() && !sourceToConsume.m_41619_()) {
            return this._fuelInventory.extractItem(0, Math.min(sourceStack.m_41613_(), sourceToConsume.m_41613_()), false);
        }
        return ItemStack.f_41583_;
    }

    @Override
    public int emitReactant(Reactant reactant, int amount) {
        if (amount <= 0) {
            return 0;
        }
        ItemStack outputStack = this.getStack(ReactantType.Waste);
        int outputStackMaxSize = Math.min(this._wasteInventory.getSlotLimit(0), outputStack.m_41741_());
        if (!outputStack.m_41619_() && outputStack.m_41613_() >= outputStackMaxSize) {
            return 0;
        }
        if (!outputStack.m_41619_()) {
            IMapping mapping = ReactantMappingsRegistry.getFromSolid(outputStack).orElse(null);
            if (null == mapping || !reactant.equals(mapping.getProduct())) {
                return 0;
            }
            int amountToProduce = Math.min(mapping.getSourceAmount(amount), outputStackMaxSize - outputStack.m_41613_());
            if (amountToProduce <= 0) {
                return 0;
            }
            int reactantToConsume = mapping.getProductAmount(amountToProduce);
            if (reactantToConsume <= 0) {
                return 0;
            }
            outputStack.m_41769_(amountToProduce);
            this.onItemsReceived();
            return reactantToConsume;
        }
        IMapping bestMapping = null;
        List mappings = ReactantMappingsRegistry.getToSolid(reactant).orElse(null);
        if (null != mappings) {
            int bestReactantAmount = 0;
            for (IMapping mapping : mappings) {
                int potentialProducts = mapping.getProductAmount(amount);
                int potentialReactant = mapping.getSourceAmount(potentialProducts);
                if (null != bestMapping && bestReactantAmount >= potentialReactant) continue;
                bestMapping = mapping;
                bestReactantAmount = potentialReactant;
            }
        }
        if (null == bestMapping) {
            Log.LOGGER.warn(Log.REACTOR, "There are no mapped item types for reactant {}. Nothing to emit here.", (Object)reactant);
            return 0;
        }
        int itemsToProduce = Math.min(bestMapping.getProductAmount(amount), outputStackMaxSize);
        if (itemsToProduce <= 0) {
            return 0;
        }
        int reactantConsumed = bestMapping.getSourceAmount(itemsToProduce);
        itemsToProduce = bestMapping.getProductAmount(reactantConsumed);
        ItemStack newItem = ReactantMappingsRegistry.getSolidStackFrom(bestMapping, 1);
        if (newItem.m_41619_()) {
            Log.LOGGER.warn(Log.REACTOR, "Can't create a stack from tag {}. Nothing to emit here.", bestMapping.getProduct());
            return 0;
        }
        ItemHelper.stackSetSize((ItemStack)newItem, (int)itemsToProduce);
        this._wasteInventory.setStackInSlot(0, newItem);
        this.onItemsReceived();
        return reactantConsumed;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
        return new ReactorSolidAccessPortContainer(windowId, inventory, this);
    }

    public Component m_5446_() {
        return super.getPartDisplayName();
    }

    public IoDirection getIoDirection() {
        return this._direction;
    }

    public void setIoDirection(IoDirection direction) {
        if (this.getIoDirection() == direction) {
            return;
        }
        this._direction = direction;
        this.notifyBlockUpdate();
        this.callOnLogicalSide(() -> {
            this.notifyOutwardNeighborsOfStateChange();
            this.distributeItems();
            this.m_6596_();
        }, () -> ((ReactorSolidAccessPortEntity)this).markForRenderUpdate());
        this.notifyNeighborsOfTileChange();
    }

    public void onBlockReplaced(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        ItemHelper.inventoryDropItems((IItemHandlerModifiable)this.getItemStackHandler(ReactantType.Fuel), (Level)world, (BlockPos)pos);
        ItemHelper.inventoryDropItems((IItemHandlerModifiable)this.getItemStackHandler(ReactantType.Waste), (Level)world, (BlockPos)pos);
    }

    public void onNeighborBlockChanged(BlockState state, BlockPos neighborPosition, boolean isMoving) {
        this.requestClientRenderUpdate();
    }

    public void onNeighborTileChanged(BlockState state, BlockPos neighborPosition) {
        this.requestClientRenderUpdate();
    }

    public void syncDataFrom(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataFrom(data, syncReason);
        this.setIoDirection(IoDirection.read((CompoundTag)data, (String)"iodir", (IoDirection)IoDirection.Input));
        if (syncReason.isFullSync()) {
            if (data.m_128441_("invin")) {
                this._fuelInventory.deserializeNBT(data.m_128469_("invin"));
            }
            if (data.m_128441_("invout")) {
                this._wasteInventory.deserializeNBT(data.m_128469_("invout"));
            }
        }
    }

    public CompoundTag syncDataTo(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataTo(data, syncReason);
        IoDirection.write((CompoundTag)data, (String)"iodir", (IoDirection)this.getIoDirection());
        if (syncReason.isFullSync()) {
            data.m_128365_("invin", (Tag)this._fuelInventory.serializeNBT());
            data.m_128365_("invout", (Tag)this._wasteInventory.serializeNBT());
        }
        return data;
    }

    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        super.getDebugMessages(side, messages);
        this.getIoDirection().getDebugMessages(side, messages);
        messages.add((Object)this.getItemStackHandler(ReactantType.Fuel), DebuggableHelper::getDebugMessagesFor, "Fuel");
        messages.add((Object)this.getItemStackHandler(ReactantType.Waste), DebuggableHelper::getDebugMessagesFor, "Waste");
    }

    public boolean canOpenGui(Level world, BlockPos position, BlockState state) {
        return true;
    }

    public void onPostMachineAssembled(MultiblockReactor controller) {
        super.onPostMachineAssembled((AbstractCuboidMultiblockController)controller);
        this.listenForControllerDataUpdates();
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (!this.m_58901_() && ITEM_HANDLER_CAPABILITY == capability) {
            if (this.getIoDirection().isInput()) {
                return this._fuelCapability.cast();
            }
            return this._wasteCapability.cast();
        }
        return super.getCapability(capability, side);
    }

    public void m_7651_() {
        super.m_7651_();
        this._fuelCapability.invalidate();
        this._wasteCapability.invalidate();
    }

    private ItemStack getStack(ReactantType type) {
        return this.getItemStackHandler(type).getStackInSlot(0);
    }

    private void setStack(ReactantType type, ItemStack stack) {
        this.getItemStackHandler(type).setStackInSlot(0, stack);
    }

    private void distributeItems() {
        if (this.getIoDirection().isInput()) {
            return;
        }
        this.callOnLogicalServer(() -> this.getNeighborCapability().ifPresent(itemHandler -> {
            this.setStack(ReactantType.Waste, ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)this.getStack(ReactantType.Waste), (boolean)false));
            this.markChunkDirty();
        }));
    }

    private LazyOptional<IItemHandler> getNeighborCapability() {
        return CodeHelper.optionalFlatMap((Optional)this.getPartWorld(), (Optional)this.getOutwardDirection(), (world, direction) -> WorldHelper.getTile((Level)world, (BlockPos)this.getWorldPosition().m_142300_(direction)).map(te -> te.getCapability(ITEM_HANDLER_CAPABILITY, direction.m_122424_()))).orElse(LazyOptional.empty());
    }

    @Nonnull
    private IItemHandlerModifiable createFuelCapability() {
        return new ItemHandlerModifiableForwarder(this.getItemStackHandler(ReactantType.Fuel)){

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                return this.isItemValid(slot, stack) ? super.insertItem(slot, stack, simulate) : stack;
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                return ReactantHelper.isValidSource(ReactantType.Fuel, stack);
            }
        };
    }

    @Nonnull
    private IItemHandlerModifiable createWasteCapability() {
        return new ItemHandlerModifiableForwarder(this.getItemStackHandler(ReactantType.Waste)){

            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return stack;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return false;
            }
        };
    }

    private void handleCommandEjectFuel(CompoundTag options) {
        this.getMultiblockController().ifPresent(c -> c.ejectFuel(options.m_128441_("void") && options.m_128471_("void")));
    }

    private void handleCommandEjectWaste(CompoundTag options) {
        this.getMultiblockController().ifPresent(c -> c.ejectWaste(options.m_128441_("void") && options.m_128471_("void")));
    }
}

