/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.zerono.mods.extremereactors.api.reactor.ReactantType;
import it.zerono.mods.extremereactors.gamecontent.CommonConstants;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.CachedSprites;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.MultiblockReactor;
import it.zerono.mods.zerocore.base.multiblock.client.screen.AbstractMultiblockScreen;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.control.MultiValueGaugeBar;
import it.zerono.mods.zerocore.lib.data.geometry.Rectangle;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class FuelGaugeBar
extends MultiValueGaugeBar<ReactantType> {
    private static final MutableComponent EMPTY = new TranslatableComponent("gui.bigreactors.generic.empty");
    private final MultiblockReactor _reactor;
    private final List<Component> _tooltipsLines;
    private final List<Object> _tooltipsObjects;

    public FuelGaugeBar(ModContainerScreen<? extends ModContainer> gui, String name, MultiblockReactor reactor) {
        super(gui, name, (double)reactor.getCapacity(), (Enum)ReactantType.Waste, (Enum)ReactantType.Fuel, (Enum[])new ReactantType[0]);
        this.setBarSprite(ReactantType.Fuel, CachedSprites.REACTOR_FUEL_COLUMN_FLOWING);
        this.setBarSprite(ReactantType.Waste, CachedSprites.REACTOR_FUEL_COLUMN_FLOWING);
        this._reactor = reactor;
        this._tooltipsLines = ImmutableList.of((Object)new TranslatableComponent("gui.bigreactors.reactor.controller.fuelbar.line1").m_6270_(AbstractMultiblockScreen.STYLE_TOOLTIP_TITLE), (Object)new TranslatableComponent("gui.bigreactors.reactor.controller.fuelbar.line2"), (Object)new TranslatableComponent("gui.bigreactors.reactor.controller.fuelbar.line3"), (Object)CodeHelper.TEXT_EMPTY_LINE, (Object)new TranslatableComponent("gui.bigreactors.reactor.controller.fuelbar.line4", new Object[]{String.format(ChatFormatting.DARK_AQUA + ChatFormatting.BOLD + "%d", this._reactor.getFuelRodsCount())}), (Object)new TranslatableComponent("gui.bigreactors.reactor.controller.fuelbar.line5", new Object[]{ChatFormatting.DARK_AQUA + ChatFormatting.BOLD + CodeHelper.formatAsMillibuckets((float)this._reactor.getCapacity())}), (Object)new TranslatableComponent("gui.bigreactors.reactor.controller.fuelbar.line6"), (Object)new TranslatableComponent("gui.bigreactors.reactor.controller.fuelbar.line7"), (Object)new TranslatableComponent("gui.bigreactors.reactor.controller.fuelbar.line8"));
        this._tooltipsObjects = ImmutableList.of(() -> new TextComponent(String.format("%.2f%%", this.getFillRatio() * 100.0)).m_6270_(AbstractMultiblockScreen.STYLE_TOOLTIP_VALUE), () -> new TextComponent(String.format("%.2f%%", Float.valueOf(this._reactor.getFuelContainer().isEmpty() ? 0.0f : (float)this._reactor.getFuelContainer().getWasteAmount() / (float)(this.getFuelAmount() + this.getWasteAmount()) * 100.0f))).m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE), () -> (this.getFuelAmount() > 0 ? new TextComponent(CodeHelper.formatAsMillibuckets((float)this.getFuelAmount())) : EMPTY).m_6270_(AbstractMultiblockScreen.STYLE_TOOLTIP_VALUE), () -> (this.getWasteAmount() > 0 ? new TextComponent(CodeHelper.formatAsMillibuckets((float)this.getWasteAmount())) : EMPTY).m_6270_(AbstractMultiblockScreen.STYLE_TOOLTIP_VALUE), () -> new TextComponent(CodeHelper.formatAsMillibuckets((float)(this.getFuelAmount() + this.getWasteAmount()))).m_6270_(AbstractMultiblockScreen.STYLE_TOOLTIP_VALUE));
    }

    public List<Component> getTooltips() {
        return this._tooltipsLines;
    }

    public List<Object> getTooltipsObjects() {
        return this._tooltipsObjects;
    }

    protected int paintValueRect(PoseStack matrix, ReactantType reactantType, Rectangle rect, int skip) {
        RenderSystem.m_69478_();
        int r = super.paintValueRect(matrix, (Enum)reactantType, rect, skip);
        RenderSystem.m_69461_();
        return r;
    }

    private int getFuelAmount() {
        return this._reactor.getFuelContainer().getFuelAmount();
    }

    private int getWasteAmount() {
        return this._reactor.getFuelContainer().getWasteAmount();
    }
}

