/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.fluid;

import it.zerono.mods.extremereactors.gamecontent.CommonConstants;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.Reactants;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public abstract class ReactantFluid
extends ForgeFlowingFluid {
    private final NonNullConsumer<LivingEntity> _effectProvider;

    protected ReactantFluid(Supplier<Source> source, Supplier<Flowing> flowing, Supplier<Block> block, Supplier<? extends Item> bucket, int colour, NonNullConsumer<LivingEntity> effectProvider) {
        super(new ForgeFlowingFluid.Properties(source, flowing, FluidAttributes.builder((ResourceLocation)CommonConstants.FLUID_TEXTURE_SOURCE_WATER, (ResourceLocation)CommonConstants.FLUID_TEXTURE_FLOWING_WATER).overlay(CommonConstants.FLUID_TEXTURE_OVERLAY_WATER).sound(SoundEvents.f_11781_, SoundEvents.f_11778_).density(2000).luminosity(5).color(0xFF000000 | colour)).bucket(bucket).block(block));
        this._effectProvider = effectProvider;
    }

    protected void applyEffect(LivingEntity entity) {
        this._effectProvider.accept((Object)entity);
    }

    public static class Block
    extends LiquidBlock {
        final Supplier<? extends ReactantFluid> _fluidSupplier;

        public Block(Supplier<? extends ReactantFluid> fluid) {
            super(fluid, BlockBehaviour.Properties.m_60939_((Material)Material.f_76305_).m_60953_(state -> 6).m_60978_(100.0f).m_60993_());
            this._fluidSupplier = fluid;
        }

        public void m_7892_(BlockState state, Level world, BlockPos position, Entity entity) {
            super.m_7892_(state, world, position, entity);
            if (entity instanceof LivingEntity && (Integer)state.m_61143_((Property)f_54688_) > 0) {
                this._fluidSupplier.get().applyEffect((LivingEntity)entity);
            }
        }
    }

    public static class Source
    extends ReactantFluid {
        public Source(Reactants reactant, Supplier<Source> sourceFluid, Supplier<Flowing> flowingFluid, Supplier<Block> block, Supplier<? extends Item> bucket) {
            super(sourceFluid, flowingFluid, block, bucket, reactant.getColour(), reactant);
        }

        public int m_7430_(FluidState state) {
            return 8;
        }

        public boolean m_7444_(FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends ReactantFluid {
        public Flowing(Reactants reactant, Supplier<Source> sourceFluid, Supplier<Flowing> flowingFluid, Supplier<Block> block, Supplier<? extends Item> bucket) {
            super(sourceFluid, flowingFluid, block, bucket, reactant.getColour(), reactant);
        }

        protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.m_7180_(builder);
            builder.m_61104_(new Property[]{f_75948_});
        }

        public int m_7430_(FluidState state) {
            return (Integer)state.m_61143_((Property)f_75948_);
        }

        public boolean m_7444_(FluidState state) {
            return false;
        }
    }
}

