/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.compat.jei.fluidizer;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.zerono.mods.extremereactors.ExtremeReactors;
import it.zerono.mods.extremereactors.config.Config;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.compat.jei.ExtremeReactorsJeiPlugin;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.CommonIcons;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.MultiblockFluidizer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.FluidizerFluidMixingRecipe;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.FluidizerSolidMixingRecipe;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.FluidizerSolidRecipe;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.IFluidizerRecipe;
import it.zerono.mods.zerocore.base.BaseHelper;
import it.zerono.mods.zerocore.base.CommonConstants;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.block.ModBlock;
import it.zerono.mods.zerocore.lib.client.gui.Orientation;
import it.zerono.mods.zerocore.lib.client.gui.Padding;
import it.zerono.mods.zerocore.lib.compat.jei.AbstractModRecipeCategory;
import it.zerono.mods.zerocore.lib.compat.jei.drawable.ProgressBarDrawable;
import it.zerono.mods.zerocore.lib.data.geometry.Rectangle;
import it.zerono.mods.zerocore.lib.recipe.ModRecipe;
import it.zerono.mods.zerocore.lib.recipe.ingredient.FluidStackRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.ingredient.ItemStackRecipeIngredient;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.fluids.FluidStack;

public abstract class FluidizerRecipeCategory<T extends ModRecipe>
extends AbstractModRecipeCategory<T> {
    private final Rectangle _powerBarArea;
    private final ProgressBarDrawable _powerBar;
    private final IDrawableAnimated _leftProgressBar;
    private final IDrawableAnimated _rightProgressBar;
    private final Map<Rectangle, List<Component>> _tooltips = new Object2ObjectArrayMap(4);

    public static FluidizerRecipeCategory<FluidizerSolidRecipe> solid(IGuiHelper guiHelper) {
        return new FluidizerRecipeCategory<FluidizerSolidRecipe>(ExtremeReactorsJeiPlugin.FLUIDIZER_SOLID_JEI_RECIPE_TYPE, IFluidizerRecipe.Type.Solid, "compat.bigreactors.jei.fluidizer.recipecategory.solid.title", guiHelper, Content.Blocks.FLUIDIZER_SOLIDINJECTOR){

            @Override
            public void setRecipe(IRecipeLayoutBuilder builder, FluidizerSolidRecipe recipe, IFocusGroup focuses) {
                super.setRecipe(builder, recipe, focuses);
                builder.addSlot(RecipeIngredientRole.INPUT, 26, 47).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, ((ItemStackRecipeIngredient)recipe.getIngredient()).getMatchingElements());
            }
        };
    }

    public static FluidizerRecipeCategory<FluidizerSolidMixingRecipe> solidMixing(IGuiHelper guiHelper) {
        return new FluidizerRecipeCategory<FluidizerSolidMixingRecipe>(ExtremeReactorsJeiPlugin.FLUIDIZER_SOLIDMIXING_JEI_RECIPE_TYPE, IFluidizerRecipe.Type.SolidMixing, "compat.bigreactors.jei.fluidizer.recipecategory.solidmixing.title", guiHelper, Content.Blocks.FLUIDIZER_SOLIDINJECTOR){

            @Override
            public void setRecipe(IRecipeLayoutBuilder builder, FluidizerSolidMixingRecipe recipe, IFocusGroup focuses) {
                super.setRecipe(builder, recipe, focuses);
                builder.addSlot(RecipeIngredientRole.INPUT, 26, 47).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, ((ItemStackRecipeIngredient)recipe.getIngredient1()).getMatchingElements());
                builder.addSlot(RecipeIngredientRole.INPUT, 116, 47).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, ((ItemStackRecipeIngredient)recipe.getIngredient2()).getMatchingElements());
            }
        };
    }

    public static FluidizerRecipeCategory<FluidizerFluidMixingRecipe> fluidMixing(IGuiHelper guiHelper) {
        return new FluidizerRecipeCategory<FluidizerFluidMixingRecipe>(ExtremeReactorsJeiPlugin.FLUIDIZER_FLUIDMIXING_JEI_RECIPE_TYPE, IFluidizerRecipe.Type.FluidMixing, "compat.bigreactors.jei.fluidizer.recipecategory.fluidmixing.title", guiHelper, Content.Blocks.FLUIDIZER_FLUIDINJECTOR){

            @Override
            public void setRecipe(IRecipeLayoutBuilder builder, FluidizerFluidMixingRecipe recipe, IFocusGroup focuses) {
                super.setRecipe(builder, recipe, focuses);
                builder.addSlot(RecipeIngredientRole.INPUT, 26, 23).setFluidRenderer(FluidizerFluidMixingRecipe.getMaxResultAmount(), false, 16, 64).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, ((FluidStackRecipeIngredient)recipe.getIngredient1()).getMatchingElements());
                builder.addSlot(RecipeIngredientRole.INPUT, 116, 23).setFluidRenderer(FluidizerFluidMixingRecipe.getMaxResultAmount(), false, 16, 64).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, ((FluidStackRecipeIngredient)recipe.getIngredient2()).getMatchingElements());
            }
        };
    }

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        int energyCost = (Integer)Config.COMMON.fluidizer.energyPerRecipeTick.get() * ((IFluidizerRecipe)recipe).getEnergyUsageMultiplier() * ((IFluidizerRecipe)recipe).getRecipeType().getTicks();
        this._powerBar.setProgress(MultiblockFluidizer.ENERGY_CAPACITY.doubleValue(), (double)energyCost);
        this.addTooltips(this._powerBarArea, new Component[]{new TranslatableComponent("compat.bigreactors.jei.common.recipecategory.energy.tooltip.title").m_6270_(CommonConstants.STYLE_TOOLTIP_TITLE), CodeHelper.TEXT_EMPTY_LINE, new TextComponent(String.format("%d FE", energyCost)).m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE)});
        FluidStack output = ((IFluidizerRecipe)recipe).getResult().getResult();
        this.addTooltips(71, 47, new Component[]{BaseHelper.getFluidNameOrEmpty((FluidStack)output).m_6270_(CommonConstants.STYLE_TOOLTIP_TITLE), CodeHelper.TEXT_EMPTY_LINE, new TextComponent(String.format("%d mB", output.getAmount())).m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE)});
        builder.addSlot(RecipeIngredientRole.OUTPUT, 71, 23).setFluidRenderer(20000, false, 16, 64).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, (List)ObjectLists.singleton((Object)((IFluidizerRecipe)recipe).getResult().getResult()));
    }

    public void draw(ModRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack matrix, double mouseX, double mouseY) {
        this._powerBar.draw(matrix, this._powerBarArea.getX1(), this._powerBarArea.getY1());
        if (null != this._leftProgressBar) {
            this._leftProgressBar.draw(matrix, 45, 47);
        }
        if (null != this._rightProgressBar) {
            this._rightProgressBar.draw(matrix, 89, 47);
        }
    }

    public List<Component> getTooltipStrings(ModRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        return this._tooltips.entrySet().stream().filter(e -> ((Rectangle)e.getKey()).contains(mouseX, mouseY)).map(Map.Entry::getValue).findAny().orElse((List)ObjectLists.emptyList());
    }

    protected FluidizerRecipeCategory(RecipeType<T> jeiRecipeType, IFluidizerRecipe.Type recipeType, String titleKey, IGuiHelper guiHelper, Supplier<? extends ModBlock> iconSupplier) {
        super(jeiRecipeType, (Component)new TranslatableComponent(titleKey), iconSupplier.get().createItemStack(), guiHelper, (IDrawable)FluidizerRecipeCategory.background(recipeType, guiHelper));
        this._powerBarArea = new Rectangle(6, 23, 16, 64);
        this._powerBar = new ProgressBarDrawable((NonNullSupplier)CommonIcons.PowerBar, 0, Padding.ZERO, this._powerBarArea.Width, this._powerBarArea.Height, Orientation.BottomToTop);
        ResourceLocation texture = ExtremeReactors.newID("textures/gui/jei/fluidizer.png");
        IDrawableStatic leftBar = guiHelper.createDrawable(texture, 0, 176, 24, 16);
        IDrawableStatic rightBar = guiHelper.createDrawable(texture, 0, 192, 24, 16);
        switch (recipeType) {
            case Solid: {
                this._leftProgressBar = guiHelper.createAnimatedDrawable(leftBar, recipeType.getTicks(), IDrawableAnimated.StartDirection.LEFT, false);
                this._rightProgressBar = null;
                break;
            }
            case SolidMixing: 
            case FluidMixing: {
                this._leftProgressBar = guiHelper.createAnimatedDrawable(leftBar, recipeType.getTicks(), IDrawableAnimated.StartDirection.LEFT, false);
                this._rightProgressBar = guiHelper.createAnimatedDrawable(rightBar, recipeType.getTicks(), IDrawableAnimated.StartDirection.RIGHT, false);
                break;
            }
            default: {
                this._rightProgressBar = null;
                this._leftProgressBar = null;
            }
        }
    }

    protected void addTooltips(int x, int y, Component ... text) {
        this.addTooltips(new Rectangle(x, y, 18, 18), text);
    }

    protected void addTooltips(Rectangle area, Component ... text) {
        this._tooltips.put(area, (List<Component>)new ObjectArrayList((Object[])text));
    }

    private static IDrawableStatic background(IFluidizerRecipe.Type recipeType, IGuiHelper guiHelper) {
        int ordinal = recipeType.ordinal() - 1;
        return guiHelper.drawableBuilder(ExtremeReactors.newID("textures/gui/jei/fluidizer.png"), 1 == ordinal ? 128 : 0, 2 == ordinal ? 88 : 0, 128, 88).addPadding(5, 5, 5, 5).build();
    }
}

