/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.networking;

import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public abstract class BlockEntityConfigurationPacket<BE extends SyncedBlockEntity>
extends SimplePacketBase {
    protected BlockPos pos;

    public BlockEntityConfigurationPacket(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        this.readSettings(buffer);
    }

    public BlockEntityConfigurationPacket(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        this.writeSettings(buffer);
    }

    @Override
    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            Level world = player.f_19853_;
            if (world == null || !world.m_46749_(this.pos)) {
                return;
            }
            if (!this.pos.m_123314_((Vec3i)player.m_142538_(), (double)this.maxRange())) {
                return;
            }
            BlockEntity blockEntity = world.m_7702_(this.pos);
            if (blockEntity instanceof SyncedBlockEntity) {
                this.applySettings(player, (SyncedBlockEntity)blockEntity);
                if (!this.causeUpdate()) {
                    return;
                }
                ((SyncedBlockEntity)blockEntity).sendData();
                blockEntity.m_6596_();
            }
        });
        return true;
    }

    protected int maxRange() {
        return 20;
    }

    protected abstract void writeSettings(FriendlyByteBuf var1);

    protected abstract void readSettings(FriendlyByteBuf var1);

    protected void applySettings(ServerPlayer player, BE be) {
        this.applySettings(be);
    }

    protected boolean causeUpdate() {
        return true;
    }

    protected abstract void applySettings(BE var1);
}

