/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.thresholdSwitch;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPackets;
import com.simibubi.create.content.redstone.thresholdSwitch.ConfigureThresholdSwitchPacket;
import com.simibubi.create.content.redstone.thresholdSwitch.ThresholdSwitchBlockEntity;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ThresholdSwitchScreen
extends AbstractSimiScreen {
    private ScrollInput offBelow;
    private ScrollInput onAbove;
    private IconButton confirmButton;
    private IconButton flipSignals;
    private final Component invertSignal = Lang.translateDirect("gui.threshold_switch.invert_signal", new Object[0]);
    private final ItemStack renderedItem = new ItemStack((ItemLike)AllBlocks.THRESHOLD_SWITCH.get());
    private AllGuiTextures background = AllGuiTextures.STOCKSWITCH;
    private ThresholdSwitchBlockEntity blockEntity;
    private int lastModification;
    private LerpedFloat cursor;
    private LerpedFloat cursorLane;

    public ThresholdSwitchScreen(ThresholdSwitchBlockEntity be) {
        super((Component)Lang.translateDirect("gui.threshold_switch.title", new Object[0]));
        this.blockEntity = be;
        this.lastModification = -1;
    }

    @Override
    protected void m_7856_() {
        this.setWindowSize(this.background.width, this.background.height);
        this.setWindowOffset(-20, 0);
        super.m_7856_();
        int x = this.guiLeft;
        int y = this.guiTop;
        this.cursor = LerpedFloat.linear().startWithValue(this.blockEntity.getLevelForDisplay());
        this.cursorLane = LerpedFloat.linear().startWithValue(this.blockEntity.getState() ? 1.0 : 0.0);
        this.offBelow = new ScrollInput(x + 36, y + 42, 102, 18).withRange(0, 100).titled(Components.empty()).calling(state -> {
            this.lastModification = 0;
            this.offBelow.titled(Lang.translateDirect("gui.threshold_switch.move_to_upper_at", state));
            if (this.onAbove.getState() <= state) {
                this.onAbove.setState(state + 1);
                this.onAbove.onChanged();
            }
        }).setState((int)(this.blockEntity.offWhenBelow * 100.0f));
        this.onAbove = new ScrollInput(x + 36, y + 20, 102, 18).withRange(1, 101).titled(Components.empty()).calling(state -> {
            this.lastModification = 0;
            this.onAbove.titled(Lang.translateDirect("gui.threshold_switch.move_to_lower_at", state));
            if (this.offBelow.getState() >= state) {
                this.offBelow.setState(state - 1);
                this.offBelow.onChanged();
            }
        }).setState((int)(this.blockEntity.onWhenAbove * 100.0f));
        this.onAbove.onChanged();
        this.offBelow.onChanged();
        this.m_142416_(this.onAbove);
        this.m_142416_(this.offBelow);
        this.confirmButton = new IconButton(x + this.background.width - 33, y + this.background.height - 24, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> this.m_7379_());
        this.m_142416_(this.confirmButton);
        this.flipSignals = new IconButton(x + this.background.width - 62, y + this.background.height - 24, AllIcons.I_FLIP);
        this.flipSignals.withCallback(() -> this.send(!this.blockEntity.isInverted()));
        this.flipSignals.setToolTip(this.invertSignal);
        this.m_142416_(this.flipSignals);
    }

    @Override
    protected void renderWindow(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.render(ms, x, y, (GuiComponent)this);
        AllGuiTextures.STOCKSWITCH_POWERED_LANE.render(ms, x + 37, y + (this.blockEntity.isInverted() ? 20 : 42), (GuiComponent)this);
        AllGuiTextures.STOCKSWITCH_UNPOWERED_LANE.render(ms, x + 37, y + (this.blockEntity.isInverted() ? 42 : 20), (GuiComponent)this);
        this.f_96547_.m_92889_(ms, this.f_96539_, (float)(x + (this.background.width - 8) / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2), (float)(y + 4), 5841956);
        AllGuiTextures sprite = AllGuiTextures.STOCKSWITCH_INTERVAL;
        float lowerBound = this.offBelow.getState();
        float upperBound = this.onAbove.getState();
        sprite.bind();
        this.m_93228_(ms, (int)((float)x + upperBound) + 37, y + 20, (int)((float)sprite.startX + upperBound), sprite.startY, (int)((float)sprite.width - upperBound), sprite.height);
        this.m_93228_(ms, x + 37, y + 42, sprite.startX, sprite.startY, (int)lowerBound, sprite.height);
        AllGuiTextures.STOCKSWITCH_ARROW_UP.render(ms, (int)((float)x + lowerBound + 36.0f) - 2, y + 37, (GuiComponent)this);
        AllGuiTextures.STOCKSWITCH_ARROW_DOWN.render(ms, (int)((float)x + upperBound + 36.0f) - 3, y + 19, (GuiComponent)this);
        if (this.blockEntity.currentLevel != -1.0f) {
            AllGuiTextures cursor = AllGuiTextures.STOCKSWITCH_CURSOR;
            ms.m_85836_();
            ms.m_85837_((double)Math.min(99.0f, this.cursor.getValue(partialTicks) * (float)sprite.width), (double)(this.cursorLane.getValue(partialTicks) * 22.0f), 0.0);
            cursor.render(ms, x + 34, y + 21, (GuiComponent)this);
            ms.m_85849_();
        }
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of(this.renderedItem).at(x + this.background.width + 6, y + this.background.height - 56, -200.0f)).scale(5.0).render(ms);
    }

    @Override
    public void m_96624_() {
        super.m_96624_();
        this.cursor.chase(this.blockEntity.getLevelForDisplay(), 0.25, LerpedFloat.Chaser.EXP);
        this.cursor.tickChaser();
        this.cursorLane.chase(this.blockEntity.getState() ? 1.0 : 0.0, 0.25, LerpedFloat.Chaser.EXP);
        this.cursorLane.tickChaser();
        if (this.lastModification >= 0) {
            ++this.lastModification;
        }
        if (this.lastModification >= 20) {
            this.lastModification = -1;
            this.send(this.blockEntity.isInverted());
        }
    }

    public void m_7861_() {
        this.send(this.blockEntity.isInverted());
    }

    protected void send(boolean invert) {
        AllPackets.getChannel().sendToServer((Object)new ConfigureThresholdSwitchPacket(this.blockEntity.m_58899_(), (float)this.offBelow.getState() / 100.0f, (float)this.onAbove.getState() / 100.0f, invert));
    }
}

