/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.funnel;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.logistics.funnel.FunnelBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.foundation.block.render.ReducedDestroyEffects;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IBlockRenderProperties;

public abstract class AbstractFunnelBlock
extends Block
implements IBE<FunnelBlockEntity>,
IWrenchable,
ProperWaterloggedBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    protected AbstractFunnelBlock(BlockBehaviour.Properties p_i48377_1_) {
        super(p_i48377_1_);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IBlockRenderProperties> consumer) {
        consumer.accept(new ReducedDestroyEffects());
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.withWater((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(context.m_43725_().m_46753_(context.m_8083_()))), context);
    }

    public FluidState m_5888_(BlockState pState) {
        return this.fluidState(pState);
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        this.updateWater(pLevel, pState, pCurrentPos);
        return pState;
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{POWERED, WATERLOGGED}));
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (worldIn.f_46443_) {
            return;
        }
        InvManipulationBehaviour behaviour = BlockEntityBehaviour.get((BlockGetter)worldIn, pos, InvManipulationBehaviour.TYPE);
        if (behaviour != null) {
            behaviour.onNeighborChanged(fromPos);
        }
        if (!worldIn.m_183326_().m_183588_(pos, (Object)this)) {
            worldIn.m_186460_(pos, (Block)this, 0);
        }
    }

    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random r) {
        boolean previouslyPowered = (Boolean)state.m_61143_((Property)POWERED);
        if (previouslyPowered != worldIn.m_46753_(pos)) {
            worldIn.m_7731_(pos, (BlockState)state.m_61122_((Property)POWERED), 2);
        }
    }

    public static ItemStack tryInsert(Level worldIn, BlockPos pos, ItemStack toInsert, boolean simulate) {
        BlockEntity blockEntity;
        FilteringBehaviour filter = BlockEntityBehaviour.get((BlockGetter)worldIn, pos, FilteringBehaviour.TYPE);
        InvManipulationBehaviour inserter = BlockEntityBehaviour.get((BlockGetter)worldIn, pos, InvManipulationBehaviour.TYPE);
        if (inserter == null) {
            return toInsert;
        }
        if (filter != null && !filter.test(toInsert)) {
            return toInsert;
        }
        if (simulate) {
            inserter.simulate();
        }
        ItemStack insert = inserter.insert(toInsert);
        if (!simulate && insert.m_41613_() != toInsert.m_41613_() && (blockEntity = worldIn.m_7702_(pos)) instanceof FunnelBlockEntity) {
            FunnelBlockEntity funnelBlockEntity = (FunnelBlockEntity)blockEntity;
            funnelBlockEntity.onTransfer(toInsert);
            if (funnelBlockEntity.hasFlap()) {
                funnelBlockEntity.flap(true);
            }
        }
        return insert;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Block block = world.m_8055_(pos.m_142300_(AbstractFunnelBlock.getFunnelFacing(state).m_122424_())).m_60734_();
        return !(block instanceof AbstractFunnelBlock);
    }

    @Nullable
    public static boolean isFunnel(BlockState state) {
        return state.m_60734_() instanceof AbstractFunnelBlock;
    }

    @Nullable
    public static Direction getFunnelFacing(BlockState state) {
        if (!(state.m_60734_() instanceof AbstractFunnelBlock)) {
            return null;
        }
        return ((AbstractFunnelBlock)state.m_60734_()).getFacing(state);
    }

    protected abstract Direction getFacing(BlockState var1);

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_() && !AbstractFunnelBlock.isFunnel(newState) || !newState.m_155947_()) {
            IBE.onRemove(state, world, pos, newState);
        }
    }

    @Override
    public Class<FunnelBlockEntity> getBlockEntityClass() {
        return FunnelBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends FunnelBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.FUNNEL.get();
    }
}

