/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.waterwheel;

import com.jozufozu.flywheel.core.StitchedSprite;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.waterwheel.LargeWaterWheelBlock;
import com.simibubi.create.content.kinetics.waterwheel.WaterWheelBlock;
import com.simibubi.create.content.kinetics.waterwheel.WaterWheelBlockEntity;
import com.simibubi.create.content.kinetics.waterwheel.WaterWheelModelKey;
import com.simibubi.create.foundation.model.BakedModelHelper;
import com.simibubi.create.foundation.render.BakedModelRenderHelper;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.render.SuperByteBufferCache;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.registries.ForgeRegistries;

public class WaterWheelRenderer<T extends WaterWheelBlockEntity>
extends KineticBlockEntityRenderer<T> {
    public static final SuperByteBufferCache.Compartment<WaterWheelModelKey> WATER_WHEEL = new SuperByteBufferCache.Compartment();
    public static final StitchedSprite OAK_PLANKS_TEMPLATE = new StitchedSprite(new ResourceLocation("block/oak_planks"));
    public static final StitchedSprite OAK_LOG_TEMPLATE = new StitchedSprite(new ResourceLocation("block/oak_log"));
    public static final StitchedSprite OAK_LOG_TOP_TEMPLATE = new StitchedSprite(new ResourceLocation("block/oak_log_top"));
    private static final String[] LOG_SUFFIXES = new String[]{"_log", "_stem"};
    protected final boolean large;

    public WaterWheelRenderer(BlockEntityRendererProvider.Context context, boolean large) {
        super(context);
        this.large = large;
    }

    public static <T extends WaterWheelBlockEntity> WaterWheelRenderer<T> standard(BlockEntityRendererProvider.Context context) {
        return new WaterWheelRenderer<T>(context, false);
    }

    public static <T extends WaterWheelBlockEntity> WaterWheelRenderer<T> large(BlockEntityRendererProvider.Context context) {
        return new WaterWheelRenderer<T>(context, true);
    }

    @Override
    protected SuperByteBuffer getRotatedModel(T be, BlockState state) {
        WaterWheelModelKey key = new WaterWheelModelKey(this.large, state, ((WaterWheelBlockEntity)be).material);
        return CreateClient.BUFFER_CACHE.get(WATER_WHEEL, key, () -> {
            BakedModel model = WaterWheelRenderer.generateModel(key);
            BlockState state1 = key.state();
            Direction dir = key.large() ? Direction.m_122387_((Direction.Axis)((Direction.Axis)state1.m_61143_((Property)LargeWaterWheelBlock.AXIS)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE) : (Direction)state1.m_61143_((Property)WaterWheelBlock.FACING);
            PoseStack transform = CachedBufferer.rotateToFaceVertical(dir).get();
            return BakedModelRenderHelper.standardModelRender(model, Blocks.f_50016_.m_49966_(), transform);
        });
    }

    public static BakedModel generateModel(WaterWheelModelKey key) {
        boolean extension;
        BakedModel template = key.large() ? ((extension = ((Boolean)key.state().m_61143_((Property)LargeWaterWheelBlock.EXTENSION)).booleanValue()) ? AllPartialModels.LARGE_WATER_WHEEL_EXTENSION.get() : AllPartialModels.LARGE_WATER_WHEEL.get()) : AllPartialModels.WATER_WHEEL.get();
        return WaterWheelRenderer.generateModel(template, key.material());
    }

    public static BakedModel generateModel(BakedModel template, BlockState planksBlockState) {
        Block planksBlock = planksBlockState.m_60734_();
        ResourceLocation id = RegisteredObjects.getKeyOrThrow(planksBlock);
        String path = id.m_135815_();
        if (path.endsWith("_planks")) {
            String namespace = id.m_135827_();
            String wood = path.substring(0, path.length() - 7);
            BlockState logBlockState = WaterWheelRenderer.getLogBlockState(namespace, wood);
            Reference2ReferenceOpenHashMap map = new Reference2ReferenceOpenHashMap();
            map.put(OAK_PLANKS_TEMPLATE.get(), WaterWheelRenderer.getSpriteOnSide(planksBlockState, Direction.UP));
            map.put(OAK_LOG_TEMPLATE.get(), WaterWheelRenderer.getSpriteOnSide(logBlockState, Direction.SOUTH));
            map.put(OAK_LOG_TOP_TEMPLATE.get(), WaterWheelRenderer.getSpriteOnSide(logBlockState, Direction.UP));
            return BakedModelHelper.generateModel(template, ((Map)map)::get);
        }
        return BakedModelHelper.generateModel(template, sprite -> null);
    }

    private static BlockState getLogBlockState(String namespace, String wood) {
        for (String suffix : LOG_SUFFIXES) {
            Optional<BlockState> state = ForgeRegistries.BLOCKS.getHolder(new ResourceLocation(namespace, wood + suffix)).map(Holder::m_203334_).map(Block::m_49966_);
            if (!state.isPresent()) continue;
            return state.get();
        }
        return Blocks.f_49999_.m_49966_();
    }

    private static TextureAtlasSprite getSpriteOnSide(BlockState state, Direction side) {
        BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(state);
        if (model == null) {
            return null;
        }
        Random random = new Random(42L);
        List quads = model.getQuads(state, side, random, (IModelData)EmptyModelData.INSTANCE);
        if (!quads.isEmpty()) {
            return ((BakedQuad)quads.get(0)).m_173410_();
        }
        random.setSeed(42L);
        quads = model.getQuads(state, null, random, (IModelData)EmptyModelData.INSTANCE);
        if (!quads.isEmpty()) {
            for (BakedQuad quad : quads) {
                if (quad.m_111306_() != side) continue;
                return quad.m_173410_();
            }
        }
        return model.getParticleIcon((IModelData)EmptyModelData.INSTANCE);
    }
}

