/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.fan;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityInstance;
import com.simibubi.create.content.kinetics.base.flwdata.RotatingData;
import com.simibubi.create.content.kinetics.fan.EncasedFanBlockEntity;
import com.simibubi.create.foundation.render.AllMaterialSpecs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class FanInstance
extends KineticBlockEntityInstance<EncasedFanBlockEntity> {
    protected final RotatingData shaft;
    protected final RotatingData fan;
    final Direction direction;
    private final Direction opposite;

    public FanInstance(MaterialManager materialManager, EncasedFanBlockEntity blockEntity) {
        super(materialManager, blockEntity);
        this.direction = (Direction)this.blockState.m_61143_((Property)BlockStateProperties.f_61372_);
        this.opposite = this.direction.m_122424_();
        this.shaft = (RotatingData)this.getRotatingMaterial().getModel(AllPartialModels.SHAFT_HALF, this.blockState, this.opposite).createInstance();
        this.fan = (RotatingData)materialManager.defaultCutout().material(AllMaterialSpecs.ROTATING).getModel(AllPartialModels.ENCASED_FAN_INNER, this.blockState, this.opposite).createInstance();
        this.setup(this.shaft);
        this.setup(this.fan, this.getFanSpeed());
    }

    private float getFanSpeed() {
        float speed = ((EncasedFanBlockEntity)this.blockEntity).getSpeed() * 5.0f;
        if (speed > 0.0f) {
            speed = Mth.m_14036_((float)speed, (float)80.0f, (float)1280.0f);
        }
        if (speed < 0.0f) {
            speed = Mth.m_14036_((float)speed, (float)-1280.0f, (float)-80.0f);
        }
        return speed;
    }

    public void update() {
        this.updateRotation(this.shaft);
        this.updateRotation(this.fan, this.getFanSpeed());
    }

    public void updateLight() {
        BlockPos behind = this.pos.m_142300_(this.opposite);
        this.relight(behind, new FlatLit[]{this.shaft});
        BlockPos inFront = this.pos.m_142300_(this.direction);
        this.relight(inFront, new FlatLit[]{this.fan});
    }

    public void remove() {
        this.shaft.delete();
        this.fan.delete();
    }
}

