/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.decoration.placard;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.decoration.placard.PlacardBlockEntity;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.logistics.filter.FilterItem;
import com.simibubi.create.content.schematics.requirement.ISpecialBlockItemRequirement;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.ItemHandlerHelper;

public class PlacardBlock
extends FaceAttachedHorizontalDirectionalBlock
implements ProperWaterloggedBlock,
IBE<PlacardBlockEntity>,
ISpecialBlockItemRequirement,
IWrenchable {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public PlacardBlock(BlockBehaviour.Properties p_53182_) {
        super(p_53182_);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{f_53179_, f_54117_, WATERLOGGED, POWERED}));
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return PlacardBlock.canAttachLenient(pLevel, pPos, PlacardBlock.m_53200_((BlockState)pState).m_122424_());
    }

    public static boolean canAttachLenient(LevelReader pReader, BlockPos pPos, Direction pDirection) {
        BlockPos blockpos = pPos.m_142300_(pDirection);
        return !pReader.m_8055_(blockpos).m_60812_((BlockGetter)pReader, blockpos).m_83281_();
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState stateForPlacement = super.m_5573_(pContext);
        if (stateForPlacement == null) {
            return null;
        }
        if (stateForPlacement.m_61143_((Property)f_53179_) == AttachFace.FLOOR) {
            stateForPlacement = (BlockState)stateForPlacement.m_61124_((Property)f_54117_, (Comparable)((Direction)stateForPlacement.m_61143_((Property)f_54117_)).m_122424_());
        }
        return this.withWater(stateForPlacement, pContext);
    }

    public boolean m_7899_(BlockState pState) {
        return true;
    }

    public int m_6378_(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        return (Boolean)pBlockState.m_61143_((Property)POWERED) != false ? 15 : 0;
    }

    public int m_6376_(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        return (Boolean)pBlockState.m_61143_((Property)POWERED) != false && PlacardBlock.m_53200_((BlockState)pBlockState) == pSide ? 15 : 0;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AllShapes.PLACARD.get(PlacardBlock.m_53200_((BlockState)pState));
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        this.updateWater(pLevel, pState, pCurrentPos);
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public FluidState m_5888_(BlockState pState) {
        return this.fluidState(pState);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player player, InteractionHand pHand, BlockHitResult pHit) {
        if (player.m_6144_()) {
            return InteractionResult.PASS;
        }
        if (pLevel.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack inHand = player.m_21120_(pHand);
        return this.onBlockEntityUse((BlockGetter)pLevel, pPos, pte -> {
            ItemStack inBlock = pte.getHeldItem();
            if (!player.m_36326_() || inHand.m_41619_() || !inBlock.m_41619_()) {
                boolean test;
                if (inBlock.m_41619_()) {
                    return InteractionResult.FAIL;
                }
                if (inHand.m_41619_()) {
                    return InteractionResult.FAIL;
                }
                if (((Boolean)pState.m_61143_((Property)POWERED)).booleanValue()) {
                    return InteractionResult.FAIL;
                }
                boolean bl = test = inBlock.m_41720_() instanceof FilterItem ? FilterItem.test(pLevel, inHand, inBlock) : ItemHandlerHelper.canItemStacksStack((ItemStack)inHand, (ItemStack)inBlock);
                if (!test) {
                    AllSoundEvents.DENY.play(pLevel, null, (Vec3i)pPos, 1.0f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
                AllSoundEvents.CONFIRM.play(pLevel, null, (Vec3i)pPos, 1.0f, 1.0f);
                pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
                PlacardBlock.updateNeighbours(pState, pLevel, pPos);
                pte.poweredTicks = 19;
                pte.notifyUpdate();
                return InteractionResult.SUCCESS;
            }
            pLevel.m_5594_(null, pPos, SoundEvents.f_12013_, SoundSource.BLOCKS, 1.0f, 1.0f);
            pte.setHeldItem(ItemHandlerHelper.copyStackWithSize((ItemStack)inHand, (int)1));
            if (!player.m_7500_()) {
                inHand.m_41774_(1);
                if (inHand.m_41619_()) {
                    player.m_21008_(pHand, ItemStack.f_41583_);
                }
            }
            return InteractionResult.SUCCESS;
        });
    }

    public static Direction connectedDirection(BlockState state) {
        return PlacardBlock.m_53200_((BlockState)state);
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        boolean blockChanged;
        boolean bl = blockChanged = !pState.m_60713_(pNewState.m_60734_());
        if (!pIsMoving && blockChanged && ((Boolean)pState.m_61143_((Property)POWERED)).booleanValue()) {
            PlacardBlock.updateNeighbours(pState, pLevel, pPos);
        }
        if (pState.m_155947_() && (blockChanged || !pNewState.m_155947_())) {
            if (!pIsMoving) {
                this.withBlockEntityDo((BlockGetter)pLevel, pPos, be -> Block.m_49840_((Level)pLevel, (BlockPos)pPos, (ItemStack)be.getHeldItem()));
            }
            pLevel.m_46747_(pPos);
        }
    }

    public static void updateNeighbours(BlockState pState, Level pLevel, BlockPos pPos) {
        pLevel.m_46672_(pPos, pState.m_60734_());
        pLevel.m_46672_(pPos.m_142300_(PlacardBlock.m_53200_((BlockState)pState).m_122424_()), pState.m_60734_());
    }

    public void m_6256_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        if (pLevel.f_46443_) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)pLevel, pPos, pte -> {
            ItemStack heldItem = pte.getHeldItem();
            if (heldItem.m_41619_()) {
                return;
            }
            pPlayer.m_150109_().m_150079_(heldItem);
            pLevel.m_5594_(null, pPos, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, 1.0f);
            pte.setHeldItem(ItemStack.f_41583_);
        });
    }

    @Override
    public ItemRequirement getRequiredItems(BlockState state, BlockEntity be) {
        PlacardBlockEntity pbe;
        ItemStack heldItem;
        ItemStack placardStack = AllBlocks.PLACARD.asStack();
        if (be instanceof PlacardBlockEntity && !(heldItem = (pbe = (PlacardBlockEntity)be).getHeldItem()).m_41619_()) {
            return new ItemRequirement(List.of(new ItemRequirement.StackRequirement(placardStack, ItemRequirement.ItemUseType.CONSUME), new ItemRequirement.StrictNbtStackRequirement(heldItem, ItemRequirement.ItemUseType.CONSUME)));
        }
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, placardStack);
    }

    @Override
    public Class<PlacardBlockEntity> getBlockEntityClass() {
        return PlacardBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends PlacardBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.PLACARD.get();
    }
}

