/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.elevator;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ContraptionHandler;
import com.simibubi.create.content.contraptions.ContraptionHandlerClient;
import com.simibubi.create.content.contraptions.actors.contraptionControls.ContraptionControlsBlockEntity;
import com.simibubi.create.content.contraptions.actors.contraptionControls.ContraptionControlsMovement;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.elevator.ElevatorContraption;
import com.simibubi.create.foundation.utility.Couple;
import java.lang.ref.WeakReference;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.MutablePair;

public class ElevatorControlsHandler {
    private static ContraptionControlsBlockEntity.ControlsSlot slot = new ElevatorControlsSlot();

    @OnlyIn(value=Dist.CLIENT)
    public static boolean onScroll(double delta) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return false;
        }
        if (player.m_5833_()) {
            return false;
        }
        if (mc.f_91073_ == null) {
            return false;
        }
        Couple<Vec3> rayInputs = ContraptionHandlerClient.getRayInputs(player);
        Vec3 origin = (Vec3)rayInputs.getFirst();
        Vec3 target = (Vec3)rayInputs.getSecond();
        AABB aabb = new AABB(origin, target).m_82400_(16.0);
        Collection<WeakReference<AbstractContraptionEntity>> contraptions = ContraptionHandler.loadedContraptions.get((LevelAccessor)mc.f_91073_).values();
        for (WeakReference<AbstractContraptionEntity> ref : contraptions) {
            BlockHitResult rayTraceResult;
            Contraption contraption;
            AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)((Object)ref.get());
            if (contraptionEntity == null || !((contraption = contraptionEntity.getContraption()) instanceof ElevatorContraption)) continue;
            ElevatorContraption ec = (ElevatorContraption)contraption;
            if (!contraptionEntity.m_142469_().m_82381_(aabb) || (rayTraceResult = ContraptionHandlerClient.rayTraceContraption(origin, target, contraptionEntity)) == null) continue;
            BlockPos pos = rayTraceResult.m_82425_();
            StructureTemplate.StructureBlockInfo info = contraption.getBlocks().get(pos);
            if (info == null || !AllBlocks.CONTRAPTION_CONTROLS.has(info.f_74676_) || !slot.testHit(info.f_74676_, rayTraceResult.m_82450_().m_82546_(Vec3.m_82528_((Vec3i)pos)))) continue;
            MovementContext ctx = null;
            for (MutablePair<StructureTemplate.StructureBlockInfo, MovementContext> pair : contraption.getActors()) {
                if (!info.equals(pair.left)) continue;
                ctx = (MovementContext)pair.right;
                break;
            }
            if (!(ctx.temporaryData instanceof ContraptionControlsMovement.ElevatorFloorSelection)) {
                ctx.temporaryData = new ContraptionControlsMovement.ElevatorFloorSelection();
            }
            ContraptionControlsMovement.ElevatorFloorSelection efs = (ContraptionControlsMovement.ElevatorFloorSelection)ctx.temporaryData;
            int prev = efs.currentIndex;
            efs.currentIndex = (int)((double)efs.currentIndex + delta);
            ContraptionControlsMovement.tickFloorSelection(efs, ec);
            if (prev != efs.currentIndex && !ec.namesList.isEmpty()) {
                float pitch = (float)efs.currentIndex / (float)ec.namesList.size();
                pitch = Mth.m_14179_((float)pitch, (float)1.0f, (float)1.5f);
                AllSoundEvents.SCROLL_VALUE.play(mc.f_91074_.f_19853_, (Player)mc.f_91074_, (Vec3i)new BlockPos(contraptionEntity.toGlobalVector(rayTraceResult.m_82450_(), 1.0f)), 1.0f, pitch);
            }
            return true;
        }
        return false;
    }

    private static class ElevatorControlsSlot
    extends ContraptionControlsBlockEntity.ControlsSlot {
        private ElevatorControlsSlot() {
        }

        @Override
        public boolean testHit(BlockState state, Vec3 localHit) {
            Vec3 offset = this.getLocalOffset(state);
            if (offset == null) {
                return false;
            }
            return localHit.m_82554_(offset) < (double)this.scale * 0.85;
        }
    }
}

