/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.elevator;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPackets;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.ContraptionType;
import com.simibubi.create.content.contraptions.actors.contraptionControls.ContraptionControlsMovement;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.elevator.ElevatorColumn;
import com.simibubi.create.content.contraptions.elevator.ElevatorContactBlockEntity;
import com.simibubi.create.content.contraptions.elevator.ElevatorFloorListPacket;
import com.simibubi.create.content.contraptions.pulley.PulleyContraption;
import com.simibubi.create.content.redstone.contact.RedstoneContactBlock;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.IntAttached;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ElevatorContraption
extends PulleyContraption {
    protected ElevatorColumn.ColumnCoords column;
    protected int contactYOffset;
    public boolean arrived;
    private int namesListVersion = -1;
    public List<IntAttached<Couple<String>>> namesList = ImmutableList.of();
    public int clientYTarget;
    public int maxContactY;
    public int minContactY;
    private int contacts;

    public ElevatorContraption() {
    }

    public ElevatorContraption(int initialOffset) {
        super(initialOffset);
    }

    @Override
    public void tickStorage(AbstractContraptionEntity entity) {
        super.tickStorage(entity);
        if (entity.f_19797_ % 10 != 0) {
            return;
        }
        ElevatorColumn.ColumnCoords coords = this.getGlobalColumn();
        ElevatorColumn column = ElevatorColumn.get((LevelAccessor)entity.f_19853_, coords);
        if (column == null) {
            return;
        }
        if (column.namesListVersion == this.namesListVersion) {
            return;
        }
        this.namesList = column.compileNamesList();
        this.namesListVersion = column.namesListVersion;
        AllPackets.getChannel().send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new ElevatorFloorListPacket(entity, this.namesList));
    }

    @Override
    protected void disableActorOnStart(MovementContext context) {
    }

    public ElevatorColumn.ColumnCoords getGlobalColumn() {
        return this.column.relative(this.anchor);
    }

    public Integer getCurrentTargetY(Level level) {
        ElevatorColumn.ColumnCoords coords = this.getGlobalColumn();
        ElevatorColumn column = ElevatorColumn.get((LevelAccessor)level, coords);
        if (column == null) {
            return null;
        }
        int targetedYLevel = column.targetedYLevel;
        if (this.isTargetUnreachable(targetedYLevel)) {
            return null;
        }
        return targetedYLevel;
    }

    public boolean isTargetUnreachable(int contactY) {
        return contactY < this.minContactY || contactY > this.maxContactY;
    }

    @Override
    public boolean assemble(Level world, BlockPos pos) throws AssemblyException {
        if (!this.searchMovedStructure(world, pos, null)) {
            return false;
        }
        if (this.blocks.size() <= 0) {
            return false;
        }
        if (this.contacts == 0) {
            throw new AssemblyException((Component)Lang.translateDirect("gui.assembly.exception.no_contacts", new Object[0]));
        }
        if (this.contacts > 1) {
            throw new AssemblyException((Component)Lang.translateDirect("gui.assembly.exception.too_many_contacts", new Object[0]));
        }
        ElevatorColumn column = ElevatorColumn.get((LevelAccessor)world, this.getGlobalColumn());
        if (column != null && column.isActive()) {
            throw new AssemblyException((Component)Lang.translateDirect("gui.assembly.exception.column_conflict", new Object[0]));
        }
        this.startMoving(world);
        return true;
    }

    @Override
    protected Pair<StructureTemplate.StructureBlockInfo, BlockEntity> capture(Level world, BlockPos pos) {
        BlockState blockState = world.m_8055_(pos);
        if (!AllBlocks.REDSTONE_CONTACT.has(blockState)) {
            return super.capture(world, pos);
        }
        Direction facing = (Direction)blockState.m_61143_((Property)RedstoneContactBlock.f_52588_);
        if (facing.m_122434_() == Direction.Axis.Y) {
            return super.capture(world, pos);
        }
        ++this.contacts;
        BlockPos local = this.toLocalPos(pos.m_142300_(facing));
        this.column = new ElevatorColumn.ColumnCoords(local.m_123341_(), local.m_123343_(), facing.m_122424_());
        this.contactYOffset = local.m_123342_();
        return super.capture(world, pos);
    }

    public int getContactYOffset() {
        return this.contactYOffset;
    }

    public void broadcastFloorData(Level level, BlockPos contactPos) {
        ElevatorColumn column = ElevatorColumn.get((LevelAccessor)level, this.getGlobalColumn());
        BlockEntity blockEntity = this.world.m_7702_(contactPos);
        if (!(blockEntity instanceof ElevatorContactBlockEntity)) {
            return;
        }
        ElevatorContactBlockEntity ecbe = (ElevatorContactBlockEntity)blockEntity;
        if (column != null) {
            column.floorReached((LevelAccessor)level, ecbe.shortName);
        }
    }

    @Override
    public CompoundTag writeNBT(boolean spawnPacket) {
        CompoundTag tag = super.writeNBT(spawnPacket);
        tag.m_128379_("Arrived", this.arrived);
        tag.m_128365_("Column", (Tag)this.column.write());
        tag.m_128405_("ContactY", this.contactYOffset);
        tag.m_128405_("MaxContactY", this.maxContactY);
        tag.m_128405_("MinContactY", this.minContactY);
        return tag;
    }

    @Override
    public void readNBT(Level world, CompoundTag nbt, boolean spawnData) {
        this.arrived = nbt.m_128471_("Arrived");
        this.column = ElevatorColumn.ColumnCoords.read(nbt.m_128469_("Column"));
        this.contactYOffset = nbt.m_128451_("ContactY");
        this.maxContactY = nbt.m_128451_("MaxContactY");
        this.minContactY = nbt.m_128451_("MinContactY");
        super.readNBT(world, nbt, spawnData);
    }

    @Override
    public ContraptionType getType() {
        return ContraptionType.ELEVATOR;
    }

    public void setClientYTarget(int clientYTarget) {
        if (this.clientYTarget == clientYTarget) {
            return;
        }
        this.clientYTarget = clientYTarget;
        this.syncControlDisplays();
    }

    public void syncControlDisplays() {
        if (this.namesList.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.namesList.size(); ++i) {
            if ((Integer)this.namesList.get(i).getFirst() != this.clientYTarget) continue;
            this.setAllControlsToFloor(i);
        }
    }

    public void setAllControlsToFloor(int floorIndex) {
        for (MutablePair pair : this.actors) {
            Object object;
            if (pair.right == null || !((object = ((MovementContext)pair.right).temporaryData) instanceof ContraptionControlsMovement.ElevatorFloorSelection)) continue;
            ContraptionControlsMovement.ElevatorFloorSelection efs = (ContraptionControlsMovement.ElevatorFloorSelection)object;
            efs.currentIndex = floorIndex;
        }
    }
}

