/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.compat.jei;

import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.lib.compat.jei.Drawables;
import cofh.thermal.lib.util.recipes.ThermalRecipe;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public abstract class ThermalRecipeCategory<T extends ThermalRecipe>
implements IRecipeCategory<T> {
    protected final int ENERGY_X = 2;
    protected final int ENERGY_Y = 10;
    protected final int EXP_X = 20;
    protected final int EXP_Y = 10;
    protected final ResourceLocation uid;
    protected IDrawable background;
    protected IDrawable icon;
    protected Component name;
    protected IDrawableStatic energyBackground;
    protected IDrawableStatic progressBackground;
    protected IDrawableStatic progressFluidBackground;
    protected IDrawableStatic speedBackground;
    protected IDrawableAnimated energy;
    protected IDrawableAnimated progress;
    protected IDrawableAnimated progressFluid;
    protected IDrawableAnimated speed;

    public ThermalRecipeCategory(IGuiHelper guiHelper, ItemStack icon, ResourceLocation uid) {
        this.uid = uid;
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)icon);
        this.energyBackground = Drawables.getDrawables(guiHelper).getEnergyEmpty();
        this.energy = guiHelper.createAnimatedDrawable(Drawables.getDrawables(guiHelper).getEnergyFill(), 400, IDrawableAnimated.StartDirection.TOP, true);
    }

    public ResourceLocation getUid() {
        return this.uid;
    }

    public Component getTitle() {
        return this.name;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(T recipe, IRecipeSlotsView recipeSlotsView, PoseStack matrixStack, double mouseX, double mouseY) {
        if (((ThermalRecipe)((Object)recipe)).getEnergy() > 0) {
            this.energyBackground.draw(matrixStack, 2, 10);
            this.energy.draw(matrixStack, 2, 10);
        }
    }

    public List<Component> getTooltipStrings(T recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (((ThermalRecipe)((Object)recipe)).getEnergy() > 0 && mouseX > 2.0 && mouseX < (double)(2 + this.energy.getWidth() - 1) && mouseY > 10.0 && mouseY < (double)(10 + this.energy.getHeight() - 1)) {
            tooltip.add((Component)StringHelper.getTextComponent((String)"info.cofh.energy").m_130946_(": " + StringHelper.format((long)((ThermalRecipe)((Object)recipe)).getEnergy()) + " RF"));
        }
        return tooltip;
    }
}

