/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.block.entity;

import cofh.core.util.control.IReconfigurableTile;
import cofh.core.util.control.ITransferControllableTile;
import cofh.core.util.control.ReconfigControlModule;
import cofh.core.util.control.ReconfigControlModuleLimited;
import cofh.core.util.control.TransferControlModule;
import cofh.lib.api.control.IReconfigurable;
import cofh.lib.util.constants.BlockStatePropertiesCoFH;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermal.lib.block.entity.AugmentableBlockEntity;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.ModelDataManager;

public abstract class StorageCellBlockEntity
extends AugmentableBlockEntity
implements IReconfigurableTile,
ITransferControllableTile {
    protected int compareTracker;
    protected int levelTracker;
    protected int inputTracker;
    protected int outputTracker;
    public int amountInput;
    public int amountOutput;
    protected ReconfigControlModule reconfigControl = new ReconfigControlModuleLimited((IReconfigurableTile)this);
    protected TransferControlModule transferControl = new TransferControlModule((ITransferControllableTile)this);

    public StorageCellBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        this.reconfigControl.setFacing((Direction)state.m_61143_((Property)BlockStatePropertiesCoFH.FACING_HORIZONTAL));
    }

    public int getComparatorInputOverride() {
        return this.compareTracker;
    }

    public void m_142339_(Level level) {
        super.m_142339_(level);
        this.updateHandlers();
    }

    public void m_155250_(BlockState state) {
        super.m_155250_(state);
        this.updateSideCache();
    }

    @Override
    public ItemStack createItemStackTag(ItemStack stack) {
        CompoundTag nbt = stack.m_41698_("BlockEntityTag");
        nbt.m_128405_("AmountIn", this.amountInput);
        nbt.m_128405_("AmountOut", this.amountOutput);
        return super.createItemStackTag(stack);
    }

    public abstract int getMaxInput();

    public abstract int getMaxOutput();

    protected void updateSideCache() {
        Direction curFacing;
        Direction prevFacing = this.getFacing();
        if (prevFacing != (curFacing = (Direction)this.m_58900_().m_61143_((Property)BlockStatePropertiesCoFH.FACING_HORIZONTAL))) {
            this.reconfigControl.setFacing(curFacing);
            int iPrev = prevFacing.m_122411_();
            int iFace = curFacing.m_122411_();
            IReconfigurable.SideConfig[] sides = new IReconfigurable.SideConfig[6];
            if (iPrev == BlockHelper.SIDE_RIGHT[iFace]) {
                for (int i = 0; i < 6; ++i) {
                    sides[i] = this.reconfigControl.getSideConfig()[BlockHelper.ROTATE_CLOCK_Y[i]];
                }
            } else if (iPrev == BlockHelper.SIDE_LEFT[iFace]) {
                for (int i = 0; i < 6; ++i) {
                    sides[i] = this.reconfigControl.getSideConfig()[BlockHelper.ROTATE_COUNTER_Y[i]];
                }
            } else if (iPrev == BlockHelper.SIDE_OPPOSITE[iFace]) {
                for (int i = 0; i < 6; ++i) {
                    sides[i] = this.reconfigControl.getSideConfig()[BlockHelper.INVERT_AROUND_Y[i]];
                }
            }
            this.reconfigControl.setSideConfig(sides);
        }
        this.updateHandlers();
    }

    protected abstract void updateTrackers(boolean var1);

    public int getLevelTracker() {
        return this.levelTracker;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.f_58857_.m_7726_().m_7827_().m_142202_(this.f_58858_);
        ModelDataManager.requestModelDataRefresh((BlockEntity)this);
    }

    public FriendlyByteBuf getConfigPacket(FriendlyByteBuf buffer) {
        super.getConfigPacket(buffer);
        buffer.writeInt(this.amountInput);
        buffer.writeInt(this.amountOutput);
        return buffer;
    }

    public void handleConfigPacket(FriendlyByteBuf buffer) {
        super.handleConfigPacket(buffer);
        this.amountInput = MathHelper.clamp((int)buffer.readInt(), (int)0, (int)this.getMaxInput());
        this.amountOutput = MathHelper.clamp((int)buffer.readInt(), (int)0, (int)this.getMaxOutput());
        this.markChunkUnsaved();
    }

    @Override
    public FriendlyByteBuf getControlPacket(FriendlyByteBuf buffer) {
        super.getControlPacket(buffer);
        this.reconfigControl.writeToBuffer(buffer);
        this.transferControl.writeToBuffer(buffer);
        buffer.writeInt(this.compareTracker);
        buffer.writeInt(this.levelTracker);
        return buffer;
    }

    @Override
    public void handleControlPacket(FriendlyByteBuf buffer) {
        super.handleControlPacket(buffer);
        this.reconfigControl.readFromBuffer(buffer);
        this.transferControl.readFromBuffer(buffer);
        this.compareTracker = buffer.readInt();
        this.levelTracker = buffer.readInt();
        ModelDataManager.requestModelDataRefresh((BlockEntity)this);
    }

    @Override
    public FriendlyByteBuf getGuiPacket(FriendlyByteBuf buffer) {
        super.getGuiPacket(buffer);
        buffer.writeInt(this.amountInput);
        buffer.writeInt(this.amountOutput);
        return buffer;
    }

    @Override
    public void handleGuiPacket(FriendlyByteBuf buffer) {
        super.handleGuiPacket(buffer);
        this.amountInput = buffer.readInt();
        this.amountOutput = buffer.readInt();
    }

    @Override
    public FriendlyByteBuf getStatePacket(FriendlyByteBuf buffer) {
        super.getStatePacket(buffer);
        buffer.writeInt(this.compareTracker);
        buffer.writeInt(this.levelTracker);
        return buffer;
    }

    @Override
    public void handleStatePacket(FriendlyByteBuf buffer) {
        int prevLight = this.getLightValue();
        super.handleStatePacket(buffer);
        this.compareTracker = buffer.readInt();
        this.levelTracker = buffer.readInt();
        if (prevLight != this.getLightValue()) {
            this.f_58857_.m_7726_().m_7827_().m_142202_(this.f_58858_);
        }
        ModelDataManager.requestModelDataRefresh((BlockEntity)this);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.reconfigControl.setFacing(Direction.m_122376_((int)nbt.m_128445_("Facing")));
        this.reconfigControl.read(nbt);
        this.transferControl.read(nbt);
        this.amountInput = nbt.m_128451_("AmountIn");
        this.amountOutput = nbt.m_128451_("AmountOut");
        this.updateTrackers(false);
        this.updateHandlers();
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128344_("Facing", (byte)this.reconfigControl.getFacing().m_122411_());
        this.reconfigControl.write(nbt);
        this.transferControl.write(nbt);
        nbt.m_128405_("AmountIn", this.amountInput);
        nbt.m_128405_("AmountOut", this.amountOutput);
    }

    @Override
    protected void finalizeAttributes(Map<Enchantment, Integer> enchantmentMap) {
        super.finalizeAttributes(enchantmentMap);
        this.amountInput = MathHelper.clamp((int)this.amountInput, (int)0, (int)this.getMaxInput());
        this.amountOutput = MathHelper.clamp((int)this.amountOutput, (int)0, (int)this.getMaxOutput());
    }

    public ReconfigControlModule reconfigControl() {
        return this.reconfigControl;
    }

    public TransferControlModule transferControl() {
        return this.transferControl;
    }

    @Override
    public void onControlUpdate() {
        this.updateTrackers(false);
        super.onControlUpdate();
    }

    @Override
    public void readConveyableData(Player player, CompoundTag tag) {
        this.reconfigControl.readSettings(tag);
        this.transferControl.readSettings(tag);
        super.readConveyableData(player, tag);
    }

    @Override
    public void writeConveyableData(Player player, CompoundTag tag) {
        this.reconfigControl.writeSettings(tag);
        this.transferControl.writeSettings(tag);
        super.writeConveyableData(player, tag);
    }
}

