/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.block.entity.device;

import cofh.core.client.renderer.model.ModelUtils;
import cofh.core.util.helpers.AugmentDataHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.lib.api.StorageGroup;
import cofh.lib.api.block.entity.ITickableTile;
import cofh.lib.client.sounds.ConditionalSoundInstance;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.core.init.TCoreSounds;
import cofh.thermal.core.init.TCoreTileEntities;
import cofh.thermal.core.inventory.container.device.DeviceWaterGenContainer;
import cofh.thermal.lib.block.entity.DeviceBlockEntity;
import cofh.thermal.lib.common.ThermalAugmentRules;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class DeviceWaterGenTile
extends DeviceBlockEntity
implements ITickableTile.IServerTickable {
    public static final BiPredicate<ItemStack, List<ItemStack>> AUG_VALIDATOR = ThermalAugmentRules.createAllowValidator("Upgrade", "Fluid", "Filter");
    protected static final int GENERATION_RATE = 250;
    protected static final Supplier<FluidStack> WATER = () -> new FluidStack((Fluid)Fluids.f_76193_, 0);
    protected ItemStorageCoFH fillSlot = new ItemStorageCoFH(1, FluidHelper::hasFluidHandlerCap);
    protected FluidStorageCoFH tank = new FluidStorageCoFH(4000, e -> false).setEmptyFluid(WATER).setEnabled(() -> this.isActive);
    protected boolean cached;
    protected boolean valid;

    public DeviceWaterGenTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TCoreTileEntities.DEVICE_WATER_GEN_TILE.get(), pos, state);
        this.inventory.addSlot(this.fillSlot, StorageGroup.INTERNAL);
        this.tankInv.addTank(this.tank, StorageGroup.OUTPUT);
        this.addAugmentSlots(ThermalCoreConfig.deviceAugments);
        this.initHandlers();
        this.renderFluid = new FluidStack((Fluid)Fluids.f_76193_, 1000);
    }

    @Override
    protected void updateValidity() {
        BlockPos[] cardinals;
        if (this.f_58857_ == null || !this.f_58857_.isAreaLoaded(this.f_58858_, 1)) {
            return;
        }
        int adjWaterSource = 0;
        this.valid = false;
        for (BlockPos adj : cardinals = new BlockPos[]{this.f_58858_.m_142127_(), this.f_58858_.m_142128_(), this.f_58858_.m_142125_(), this.f_58858_.m_142126_()}) {
            FluidState state = this.f_58857_.m_6425_(adj);
            if (!state.m_76152_().equals(Fluids.f_76193_)) continue;
            ++adjWaterSource;
        }
        if (adjWaterSource > 1) {
            this.valid = true;
        } else {
            this.tank.clear();
        }
        this.cached = true;
    }

    @Override
    protected void updateActiveState() {
        if (!this.cached) {
            this.updateValidity();
        }
        super.updateActiveState();
    }

    @Override
    protected boolean isValid() {
        return this.valid;
    }

    protected void fillFluid() {
        if (!this.fillSlot.isEmpty()) {
            this.fillSlot.getItemStack().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null).ifPresent(c -> {
                this.tank.drain(c.fill(new FluidStack(this.tank.getFluidStack(), (int)(1000.0f * this.baseMod)), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                this.fillSlot.setItemStack(c.getContainer());
            });
        }
    }

    public void tickServer() {
        this.updateActiveState();
        if (this.isActive) {
            this.tank.modify((int)(250.0f * this.baseMod));
            this.fillFluid();
        }
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(ModelUtils.FLUID, (Object)this.renderFluid).build();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new DeviceWaterGenContainer(i, this.f_58857_, this.f_58858_, inventory, player);
    }

    protected Object getSound() {
        return new ConditionalSoundInstance((SoundEvent)TCoreSounds.SOUND_DEVICE_WATER_GEN.get(), SoundSource.AMBIENT, (BlockEntity)this, () -> !this.f_58859_ && this.isActive);
    }

    @Override
    protected Predicate<ItemStack> augValidator() {
        return item -> AugmentDataHelper.hasAugmentData((ItemStack)item) && AUG_VALIDATOR.test((ItemStack)item, this.getAugmentsAsList());
    }
}

