/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.block.entity;

import cofh.core.fluid.PotionFluid;
import cofh.core.util.filter.EmptyFilter;
import cofh.core.util.filter.IFilter;
import cofh.core.util.helpers.AugmentDataHelper;
import cofh.core.util.helpers.AugmentableHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.lib.api.StorageGroup;
import cofh.lib.api.block.entity.ITickableTile;
import cofh.lib.energy.EnergyStorageCoFH;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.core.init.TCoreTileEntities;
import cofh.thermal.core.inventory.container.TinkerBenchContainer;
import cofh.thermal.lib.block.entity.AugmentableBlockEntity;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.util.ThermalEnergyHelper;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TinkerBenchBlockEntity
extends AugmentableBlockEntity
implements ITickableTile.IServerTickable {
    public static final BiPredicate<ItemStack, List<ItemStack>> AUG_VALIDATOR = ThermalAugmentRules.createAllowValidator("Upgrade", "RF", "Fluid");
    public static final int BASE_CAPACITY = 500000;
    public static final int BASE_XFER = 1000;
    protected static final byte REPLENISH = 0;
    protected static final byte AUGMENT = 1;
    protected int numPlayersUsing;
    protected ItemStorageCoFH tinkerSlot = new ItemStorageCoFH(1, item -> AugmentableHelper.isAugmentableItem((ItemStack)item) || ThermalEnergyHelper.hasEnergyHandlerCap(item) || FluidHelper.hasFluidHandlerCap((ItemStack)item));
    protected ItemStorageCoFH chargeSlot = new ItemStorageCoFH(1, ThermalEnergyHelper::hasEnergyHandlerCap);
    protected ItemStorageCoFH tankSlot = new ItemStorageCoFH(1, item -> FluidHelper.hasFluidHandlerCap((ItemStack)item) || item.m_41720_() == Items.f_42589_);
    protected FluidStorageCoFH tank = new FluidStorageCoFH(8000);
    protected byte mode;
    protected boolean pause;

    public TinkerBenchBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TCoreTileEntities.TINKER_BENCH_TILE.get(), pos, state);
        this.energyStorage = new EnergyStorageCoFH(500000, 1000);
        this.inventory.addSlot(this.tinkerSlot, StorageGroup.INTERNAL);
        this.inventory.addSlot(this.chargeSlot, StorageGroup.INTERNAL);
        this.inventory.addSlot(this.tankSlot, StorageGroup.INTERNAL);
        this.tankInv.addTank(this.tank, StorageGroup.INPUT);
        this.addAugmentSlots(ThermalCoreConfig.storageAugments);
        this.initHandlers();
    }

    public void tickServer() {
        if (this.redstoneControl.getState()) {
            this.chargeEnergy();
            this.fillFluid();
        }
    }

    public void addPlayerUsing() {
        ++this.numPlayersUsing;
    }

    public void removePlayerUsing() {
        --this.numPlayersUsing;
    }

    public void setPause(boolean pause) {
        this.pause = pause;
    }

    public boolean allowAugmentation() {
        return this.mode == 1;
    }

    public void toggleTinkerSlotMode() {
        this.mode = (byte)(this.mode + 1);
        this.mode = (byte)(this.mode % 2);
    }

    protected void chargeEnergy() {
        int maxTransfer;
        if (!this.chargeSlot.isEmpty()) {
            maxTransfer = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getSpace());
            this.chargeSlot.getItemStack().getCapability(ThermalEnergyHelper.getBaseEnergySystem(), null).ifPresent(c -> this.energyStorage.receiveEnergy(c.extractEnergy(maxTransfer, false), false));
        }
        if (!this.tinkerSlot.isEmpty() && this.mode == 0 && !this.pause) {
            maxTransfer = Math.min(this.energyStorage.getMaxExtract(), this.energyStorage.getEnergyStored());
            this.tinkerSlot.getItemStack().getCapability(ThermalEnergyHelper.getBaseEnergySystem(), null).ifPresent(c -> this.energyStorage.extractEnergy(c.receiveEnergy(maxTransfer, false), false));
        }
    }

    protected void fillFluid() {
        if (!this.tankSlot.isEmpty()) {
            ItemStack tankStack = this.tankSlot.getItemStack();
            if (tankStack.m_41720_() == Items.f_42589_) {
                FluidStack potion = PotionFluid.getPotionFluidFromItem((int)250, (ItemStack)tankStack);
                if (this.tank.fill(potion, IFluidHandler.FluidAction.SIMULATE) == 250) {
                    this.tank.fill(potion, IFluidHandler.FluidAction.EXECUTE);
                    this.tankSlot.setItemStack(new ItemStack((ItemLike)Items.f_42590_));
                }
            } else {
                tankStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null).ifPresent(c -> {
                    int toFill = this.tank.fill(new FluidStack(c.getFluidInTank(0), 1000), IFluidHandler.FluidAction.SIMULATE);
                    if (toFill > 0) {
                        this.tank.fill(c.drain(toFill, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                        this.tankSlot.setItemStack(c.getContainer());
                    }
                });
            }
        }
        if (!this.tinkerSlot.isEmpty() && this.mode == 0 && !this.pause) {
            this.tinkerSlot.getItemStack().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null).ifPresent(c -> {
                this.tank.drain(c.fill(new FluidStack(this.tank.getFluidStack(), Math.min(this.tank.getAmount(), 1000)), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                this.tinkerSlot.setItemStack(c.getContainer());
            });
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new TinkerBenchContainer(i, this.f_58857_, this.f_58858_, inventory, player);
    }

    public boolean canOpenGui() {
        return this.numPlayersUsing <= 0;
    }

    @Override
    public FriendlyByteBuf getGuiPacket(FriendlyByteBuf buffer) {
        super.getGuiPacket(buffer);
        buffer.writeByte((int)this.mode);
        return buffer;
    }

    @Override
    public void handleGuiPacket(FriendlyByteBuf buffer) {
        super.handleGuiPacket(buffer);
        this.mode = buffer.readByte();
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.mode = nbt.m_128445_("Mode");
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128344_("Mode", this.mode);
    }

    @Override
    protected Predicate<ItemStack> augValidator() {
        return item -> AugmentDataHelper.hasAugmentData((ItemStack)item) && AUG_VALIDATOR.test((ItemStack)item, this.getAugmentsAsList());
    }

    @Override
    public IFilter getFilter() {
        return EmptyFilter.INSTANCE;
    }

    @Override
    public boolean openGui(ServerPlayer player) {
        return false;
    }

    @Override
    public boolean openFilterGui(ServerPlayer player) {
        return false;
    }
}

