/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.impl.simple;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.configured.api.IConfigEntry;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.api.ValueEntry;
import com.mrcrayfish.configured.api.simple.EnumProperty;
import com.mrcrayfish.configured.api.simple.ListProperty;
import com.mrcrayfish.configured.impl.simple.SimpleConfigManager;
import com.mrcrayfish.configured.impl.simple.SimpleEnumValue;
import com.mrcrayfish.configured.impl.simple.SimpleListValue;
import com.mrcrayfish.configured.impl.simple.SimpleValue;
import java.util.List;
import javax.annotation.Nullable;

public class SimpleFolderEntry
implements IConfigEntry {
    private final String label;
    private final SimpleConfigManager.PropertyMap map;
    private final boolean root;
    private List<IConfigEntry> entries;

    public SimpleFolderEntry(String label, SimpleConfigManager.PropertyMap map, boolean root) {
        this.label = label;
        this.map = map;
        this.root = root;
    }

    @Override
    public List<IConfigEntry> getChildren() {
        if (this.entries == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            this.map.getConfigMaps().forEach(pair -> builder.add((Object)new SimpleFolderEntry((String)pair.getLeft(), (SimpleConfigManager.PropertyMap)pair.getRight(), false)));
            this.map.getConfigProperties().forEach(property -> {
                if (property instanceof ListProperty) {
                    ListProperty listProperty = (ListProperty)property;
                    builder.add((Object)new ValueEntry(new SimpleListValue(listProperty)));
                } else if (property instanceof EnumProperty) {
                    EnumProperty enumProperty = (EnumProperty)property;
                    builder.add((Object)new ValueEntry(new SimpleEnumValue(enumProperty)));
                } else {
                    builder.add((Object)new ValueEntry(new SimpleValue(property)));
                }
            });
            this.entries = builder.build();
        }
        return this.entries;
    }

    @Override
    public boolean isRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    @Nullable
    public IConfigValue<?> getValue() {
        return null;
    }

    @Override
    public String getEntryName() {
        return this.label;
    }
}

