/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.internal.teams;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import shetiphian.core.ShetiPhianCore;
import shetiphian.core.internal.teams.PlayerTeam;
import shetiphian.core.internal.teams.TeamSaveData;

public class TeamHelper {
    static TeamSaveData SAVEDATA = new TeamSaveData();
    static final Map<UUID, PlayerTeam> PLAYER_TEAM = new HashMap<UUID, PlayerTeam>();

    public static Set<String> getTeams() {
        return TeamHelper.SAVEDATA.TEAMS.keySet();
    }

    public static boolean doesTeamExist(String id) {
        return TeamHelper.SAVEDATA.TEAMS.containsKey(id);
    }

    public static Component getTeamDisplayName(String id) {
        return TeamHelper.doesTeamExist(id) ? TeamHelper.SAVEDATA.TEAMS.get(id).getDisplayName() : new TextComponent("?-bad-id-?");
    }

    public static PlayerTeam getTeam(String id) {
        return TeamHelper.SAVEDATA.TEAMS.get(id);
    }

    public static PlayerTeam getTeam(Player player) {
        return TeamHelper.getTeam(player.m_142081_());
    }

    public static PlayerTeam getTeam(UUID player) {
        return PLAYER_TEAM.getOrDefault(player, null);
    }

    static List<UUID> deleteTeam(String id) {
        PlayerTeam team = TeamHelper.SAVEDATA.TEAMS.get(id);
        if (team != null) {
            List<UUID> members = team.getMembers();
            members.forEach(PLAYER_TEAM::remove);
            TeamHelper.SAVEDATA.TEAMS.remove(id);
            TeamHelper.markDirty();
            return members;
        }
        return Collections.emptyList();
    }

    public static void load(MinecraftServer server, ServerLevel world) {
        ShetiPhianCore.LOGGER.info("Loading Teams Data");
        SAVEDATA = (TeamSaveData)world.m_8895_().m_164861_(TeamSaveData::load, TeamSaveData::new, "shetiphiancore_teams");
        SAVEDATA.migrate(server);
        ShetiPhianCore.LOGGER.info("Finished Loading Teams Data");
    }

    public static void markDirty() {
        SAVEDATA.m_77762_();
    }
}

