/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.inventory;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.items.wrapper.InvWrapper;

public interface ISidedWrapper {
    public SidedWrapper getSidedWrapper();

    public static class SidedWrapper {
        private List<InvWrapper> invWrappers = new ArrayList<InvWrapper>();
        byte[] indexSide = new byte[]{-1, -1, -1, -1, -1, -1};
        byte defaultIndex = (byte)-1;

        public SidedWrapper(int defaultIndex, InvWrapper ... wrappers) {
            this.invWrappers.clear();
            if (wrappers != null) {
                for (InvWrapper wrapper : wrappers) {
                    if (wrapper == null || this.invWrappers.contains(wrapper)) continue;
                    this.invWrappers.add(wrapper);
                }
            }
            this.defaultIndex = this.trim(defaultIndex);
        }

        public void setFaceIndex(Direction facing, int index) {
            if (facing != null) {
                this.indexSide[facing.m_122411_()] = this.trim(index);
            }
        }

        private byte trim(int index) {
            return (byte)(index > -1 && index < this.invWrappers.size() ? index : -1);
        }

        public byte[] getIndexes() {
            return this.indexSide;
        }

        public InvWrapper getWrapper(Direction blockFacing, Direction side) {
            try {
                if (blockFacing != null && side != null) {
                    if (side.m_122434_() != Direction.Axis.Y) {
                        switch (blockFacing) {
                            case NORTH: {
                                return this.invWrappers.get(this.indexSide[side.m_122424_().m_122411_()]);
                            }
                            case WEST: {
                                return this.invWrappers.get(this.indexSide[side.m_122428_().m_122411_()]);
                            }
                            case EAST: {
                                return this.invWrappers.get(this.indexSide[side.m_122427_().m_122411_()]);
                            }
                        }
                    }
                    return this.invWrappers.get(this.indexSide[side.m_122411_()]);
                }
                return this.invWrappers.get(this.defaultIndex);
            }
            catch (Exception ignored) {
                return null;
            }
        }

        public int getWrapperCount() {
            return this.invWrappers.size();
        }

        public void writeToNBT(CompoundTag nbtTag) {
            nbtTag.m_128382_("sidedWrapper", this.indexSide);
        }

        public void readFromNBT(CompoundTag nbtTag) {
            byte[] indexes;
            if (nbtTag.m_128441_("sidedWrapper") && (indexes = nbtTag.m_128463_("sidedWrapper")).length == 6) {
                this.indexSide = indexes;
            }
        }
    }
}

