/*
 * Decompiled with CFR 0.152.
 */
package com.tabithastrong.compactstorage.inventory;

import com.tabithastrong.compactstorage.inventory.BackpackInventory;
import com.tabithastrong.compactstorage.screen.CompactChestScreenHandler;
import io.netty.buffer.Unpooled;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class BackpackInventoryHandlerFactory
implements MenuProvider {
    public InteractionHand hand;
    public ItemStack backpackStack;

    public BackpackInventoryHandlerFactory(Player player, InteractionHand hand) {
        this.hand = hand;
        this.backpackStack = player.m_21120_(hand);
    }

    public void writeScreenOpeningData(FriendlyByteBuf buf) {
        buf.writeInt(1);
        buf.writeInt(this.hand.ordinal());
    }

    public Component m_5446_() {
        return this.backpackStack.m_41788_() ? this.backpackStack.m_41786_() : new TranslatableComponent("container.compact_storage.backpack");
    }

    public static BackpackInventory getBackpackInventory(Player player, InteractionHand hand) {
        ItemStack backpackStack = player.m_21120_(hand);
        if (backpackStack.m_41782_() && backpackStack.m_41783_().m_128441_("Backpack")) {
            CompoundTag backpackTag = backpackStack.m_41783_().m_128469_("Backpack");
            return new BackpackInventory(backpackTag, hand, player);
        }
        return new BackpackInventory(new CompoundTag(), hand, player);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
        BackpackInventory backpackInventory = BackpackInventoryHandlerFactory.getBackpackInventory(player, this.hand);
        return new CompactChestScreenHandler(syncId, inv, this.writeToByteBuf());
    }

    private FriendlyByteBuf writeToByteBuf() {
        FriendlyByteBuf packetByteBuf = new FriendlyByteBuf(Unpooled.buffer());
        packetByteBuf.writeInt(1);
        packetByteBuf.writeInt(this.hand == InteractionHand.MAIN_HAND ? 0 : 1);
        return packetByteBuf;
    }
}

