/*
 * Decompiled with CFR 0.152.
 */
package com.tabithastrong.compactstorage.block.entity;

import com.tabithastrong.compactstorage.CompactStorage;
import com.tabithastrong.compactstorage.block.CompactBarrelBlock;
import com.tabithastrong.compactstorage.inventory.CompactStorageItemHandler;
import com.tabithastrong.compactstorage.screen.CompactChestScreenHandler;
import com.tabithastrong.compactstorage.util.CompactStorageInventoryImpl;
import io.netty.buffer.Unpooled;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class CompactBarrelBlockEntity
extends RandomizableContainerBlockEntity
implements CompactStorageInventoryImpl {
    private CompactStorageItemHandler inventory;
    private LazyOptional<IItemHandler> inventoryHandlerLazyOptional = LazyOptional.of(() -> this.inventory);
    public int inventoryWidth = 9;
    public int inventoryHeight = 6;
    public int playersUsing = 0;
    public int playersUsingOld = 0;
    public boolean isOpen = false;

    public CompactBarrelBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)CompactStorage.COMPACT_BARREL_ENTITY_TYPE.get(), blockPos, blockState);
        this.inventory = new CompactStorageItemHandler(this.inventoryWidth * this.inventoryHeight);
    }

    public int m_6643_() {
        return this.inventoryWidth * this.inventoryHeight;
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.inventory.getStacks();
    }

    protected void m_6520_(NonNullList<ItemStack> stackList) {
        this.inventory = new CompactStorageItemHandler(stackList);
    }

    protected Component m_6820_() {
        return new TranslatableComponent("container.barrel");
    }

    protected AbstractContainerMenu m_6555_(int syncId, Inventory playerInventory) {
        return new CompactChestScreenHandler(syncId, playerInventory, this.writeToByteBuf());
    }

    @Override
    public int getInventoryWidth() {
        return this.inventoryWidth;
    }

    @Override
    public int getInventoryHeight() {
        return this.inventoryHeight;
    }

    public void m_5856_(Player player) {
        super.m_5856_(player);
        if (!player.m_5833_()) {
            ++this.playersUsing;
        }
    }

    public void m_5785_(Player player) {
        super.m_5785_(player);
        if (!player.m_5833_()) {
            --this.playersUsing;
        }
    }

    public void resizeInventory() {
        NonNullList<ItemStack> stacks = this.inventory.getStacks();
        this.inventory.setSize(this.inventoryWidth * this.inventoryHeight);
        for (int i = 0; i < stacks.size(); ++i) {
            this.inventory.setStackInSlot(i, (ItemStack)stacks.get(i));
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventoryWidth = nbt.m_128441_("inventory_width") ? nbt.m_128451_("inventory_width") : 9;
        this.inventoryHeight = nbt.m_128441_("inventory_height") ? nbt.m_128451_("inventory_height") : 3;
        this.inventory = new CompactStorageItemHandler(this.inventoryWidth * this.inventoryHeight);
        if (nbt.m_128441_("Inventory")) {
            this.inventory.deserializeNBT(nbt.m_128469_("Inventory"));
        } else if (nbt.m_128441_("Items")) {
            this.inventory.deserializeNBT(nbt);
        }
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        nbt.m_128405_("inventory_width", this.inventoryWidth);
        nbt.m_128405_("inventory_height", this.inventoryHeight);
    }

    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public static void tick(Level world, BlockPos pos, BlockState state, CompactBarrelBlockEntity compactChestBlockEntity) {
        if (compactChestBlockEntity.playersUsing > 0 && compactChestBlockEntity.playersUsingOld == 0) {
            compactChestBlockEntity.isOpen = true;
            world.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11725_, SoundSource.BLOCKS, 1.0f, 0.9f, true);
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)CompactBarrelBlock.OPEN, (Comparable)Boolean.valueOf(true)));
        } else if (compactChestBlockEntity.playersUsing == 0 && compactChestBlockEntity.playersUsingOld != 0) {
            compactChestBlockEntity.isOpen = false;
            world.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11724_, SoundSource.BLOCKS, 1.0f, 0.9f, true);
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)CompactBarrelBlock.OPEN, (Comparable)Boolean.valueOf(false)));
        }
        compactChestBlockEntity.playersUsingOld = compactChestBlockEntity.playersUsing;
    }

    public FriendlyByteBuf writeToByteBuf() {
        FriendlyByteBuf packetByteBuf = new FriendlyByteBuf(Unpooled.buffer());
        this.writeScreenOpeningData(packetByteBuf);
        return packetByteBuf;
    }

    public AbstractContainerMenu m_7208_(int syncId, Inventory playerInventory, Player playerEntity) {
        return new CompactChestScreenHandler(syncId, playerInventory, this.writeToByteBuf());
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    public void writeScreenOpeningData(FriendlyByteBuf buf) {
        buf.writeInt(0);
        buf.m_130064_(this.f_58858_);
    }

    public boolean increaseSize(int x, int y) {
        if (this.inventoryWidth > 23 && x > 0 || this.inventoryHeight > 11 && y > 0) {
            return false;
        }
        this.inventoryWidth += x;
        this.inventoryHeight += y;
        this.resizeInventory();
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 1);
        return true;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryHandlerLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }
}

