/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.wct.magnet_card;

import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.upgrades.IUpgradeableItem;
import de.mari_023.ae2wtlib.AE2wtlib;
import de.mari_023.ae2wtlib.AE2wtlibConfig;
import de.mari_023.ae2wtlib.Platform;
import de.mari_023.ae2wtlib.networking.c2s.ServerNetworkManager;
import de.mari_023.ae2wtlib.networking.s2c.RestockAmountPacket;
import de.mari_023.ae2wtlib.terminal.ItemWT;
import de.mari_023.ae2wtlib.wct.CraftingTerminalHandler;
import de.mari_023.ae2wtlib.wct.magnet_card.MagnetHost;
import de.mari_023.ae2wtlib.wct.magnet_card.MagnetSettings;
import java.util.HashMap;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class MagnetHandler {
    public void doMagnet(MinecraftServer server) {
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            MagnetHandler.doMagnet(player);
        }
    }

    public static void doMagnet(ServerPlayer player) {
        MagnetHandler.handleMagnet((Player)player);
        MagnetHandler.sendRestockAble(player);
    }

    private static void sendRestockAble(ServerPlayer player) {
        try {
            CraftingTerminalHandler handler = CraftingTerminalHandler.getCraftingTerminalHandler((Player)player);
            if (player.m_7500_() || !ItemWT.getBoolean(handler.getCraftingTerminal(), "restock") || !handler.inRange()) {
                return;
            }
            HashMap<Item, Long> items = new HashMap<Item, Long>();
            if (handler.getTargetGrid() == null || handler.getTargetGrid().getStorageService().getInventory() == null) {
                return;
            }
            KeyCounter storageList = handler.getTargetGrid().getStorageService().getInventory().getAvailableStacks();
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack stack = player.m_150109_().m_8020_(i);
                if (stack.m_41619_() || items.containsKey(stack.m_41720_())) continue;
                AEItemKey key = AEItemKey.of((ItemStack)stack);
                if (key == null) {
                    items.put(stack.m_41720_(), 0L);
                    continue;
                }
                items.put(stack.m_41720_(), storageList.get((AEKey)key));
            }
            ServerNetworkManager.sendToClient(player, new RestockAmountPacket(items));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private static void handleMagnet(Player player) {
        CraftingTerminalHandler ctHandler = CraftingTerminalHandler.getCraftingTerminalHandler(player);
        if (!MagnetHandler.getMagnetSettings(ctHandler.getCraftingTerminal()).isActive()) {
            return;
        }
        MagnetHost magnetHost = ctHandler.getMagnetHost();
        if (magnetHost == null) {
            return;
        }
        List entityItems = player.m_183503_().m_6443_(ItemEntity.class, player.m_142469_().m_82400_(AE2wtlibConfig.INSTANCE.magnetCardRange()), EntitySelector.f_20402_);
        if (player.m_6144_()) {
            return;
        }
        for (ItemEntity entityItemNearby : entityItems) {
            AEItemKey item = AEItemKey.of((ItemStack)entityItemNearby.m_32055_());
            if (item == null || !magnetHost.getPickupFilter().matchesFilter((AEKey)item, magnetHost.getPickupMode()) || Platform.preventRemoteMovement(entityItemNearby)) continue;
            entityItemNearby.m_6123_(player);
        }
    }

    public static void saveMagnetSettings(ItemStack terminal, MagnetSettings magnetSettings) {
        IUpgradeableItem upgradeableItem;
        Item item = terminal.m_41720_();
        if (item instanceof IUpgradeableItem && (upgradeableItem = (IUpgradeableItem)item).getUpgrades(terminal).isInstalled((ItemLike)AE2wtlib.MAGNET_CARD)) {
            terminal.m_41784_().m_128365_("magnet_settings", (Tag)magnetSettings.toTag());
        }
    }

    public static MagnetSettings getMagnetSettings(ItemStack terminal) {
        IUpgradeableItem upgradeableItem;
        Item item = terminal.m_41720_();
        if (item instanceof IUpgradeableItem && (upgradeableItem = (IUpgradeableItem)item).getUpgrades(terminal).isInstalled((ItemLike)AE2wtlib.MAGNET_CARD)) {
            return new MagnetSettings((CompoundTag)terminal.m_41784_().m_128423_("magnet_settings"));
        }
        return new MagnetSettings();
    }
}

