/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.terminal;

import appeng.api.features.Locatables;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.helpers.WirelessTerminalMenuHost;
import appeng.items.tools.powered.WirelessTerminalItem;
import appeng.menu.ISubMenu;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import de.mari_023.ae2wtlib.AE2wtlib;
import de.mari_023.ae2wtlib.AE2wtlibConfig;
import de.mari_023.ae2wtlib.wut.WUTHandler;
import java.util.function.BiConsumer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public abstract class WTMenuHost
extends WirelessTerminalMenuHost
implements InternalInventoryHost {
    private final AppEngInternalInventory viewCellInventory = new AppEngInternalInventory((InternalInventoryHost)this, 5);
    private final Player myPlayer;
    private boolean rangeCheck;
    private IGridNode securityTerminalNode;
    private IUpgradeInventory upgradeInventory;

    public WTMenuHost(Player player, @Nullable Integer inventorySlot, ItemStack is, BiConsumer<Player, ISubMenu> returnToMainMenu) {
        super(player, inventorySlot, is, returnToMainMenu);
        this.myPlayer = player;
        this.upgradeInventory = UpgradeInventories.forItem((ItemStack)is, (int)WUTHandler.getUpgradeCardCount(), this::updateUpgrades);
        if (((WirelessTerminalItem)is.m_41720_()).getGridKey(is).isEmpty()) {
            return;
        }
        IActionHost actionHost = (IActionHost)Locatables.securityStations().get(player.f_19853_, ((WirelessTerminalItem)is.m_41720_()).getGridKey(is).getAsLong());
        if (actionHost != null) {
            this.securityTerminalNode = actionHost.getActionableNode();
        }
    }

    public void updateUpgrades(ItemStack stack, IUpgradeInventory upgrades) {
        this.upgradeInventory = upgrades;
    }

    protected void readFromNbt() {
        this.viewCellInventory.readFromNBT(this.getItemStack().m_41784_(), "viewcells");
    }

    public void saveChanges() {
        this.viewCellInventory.writeToNBT(this.getItemStack().m_41784_(), "viewcells");
    }

    public void onChangeInventory(InternalInventory inv, int slot) {
        this.saveChanges();
    }

    public IGridNode getActionableNode() {
        IGridNode node = super.getActionableNode();
        if (node != null) {
            return node;
        }
        return this.securityTerminalNode;
    }

    public boolean rangeCheck() {
        this.rangeCheck = super.rangeCheck();
        return this.rangeCheck || this.hasBoosterCard();
    }

    public boolean hasBoosterCard() {
        return this.upgradeInventory.isInstalled((ItemLike)AE2wtlib.INFINITY_BOOSTER);
    }

    public Player getPlayer() {
        return this.myPlayer;
    }

    public AppEngInternalInventory getViewCellStorage() {
        return this.viewCellInventory;
    }

    protected void setPowerDrainPerTick(double powerDrainPerTick) {
        if (this.rangeCheck) {
            super.setPowerDrainPerTick(powerDrainPerTick);
        } else {
            super.setPowerDrainPerTick(AE2wtlibConfig.INSTANCE.getOutOfRangePower());
        }
    }
}

