/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import net.blay09.mods.balm.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.api.FoodRecipeWithStatus;
import net.blay09.mods.cookingforblockheads.api.ISortButton;
import net.blay09.mods.cookingforblockheads.api.RecipeStatus;
import net.blay09.mods.cookingforblockheads.client.gui.SortButton;
import net.blay09.mods.cookingforblockheads.menu.RecipeBookMenu;
import net.blay09.mods.cookingforblockheads.menu.slot.CraftMatrixFakeSlot;
import net.blay09.mods.cookingforblockheads.menu.slot.RecipeFakeSlot;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.registry.FoodRecipeType;
import net.blay09.mods.cookingforblockheads.registry.FoodRecipeWithIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class RecipeBookScreen
extends AbstractContainerScreen<RecipeBookMenu> {
    private static final int SCROLLBAR_COLOR = -5592406;
    private static final int SCROLLBAR_Y = 8;
    private static final int SCROLLBAR_WIDTH = 7;
    private static final int SCROLLBAR_HEIGHT = 77;
    private static final ResourceLocation guiTexture = new ResourceLocation("cookingforblockheads", "textures/gui/gui.png");
    private static final int VISIBLE_ROWS = 4;
    private final RecipeBookMenu container;
    private int scrollBarScaledHeight;
    private int scrollBarXPos;
    private int scrollBarYPos;
    private int currentOffset;
    private double mouseClickY = -1.0;
    private int indexWhenClicked;
    private int lastNumberOfMoves;
    private Button btnNextRecipe;
    private Button btnPrevRecipe;
    private EditBox searchBar;
    private final List<SortButton> sortButtons = Lists.newArrayList();
    private final String[] noIngredients;
    private final String[] noSelection;

    public RecipeBookScreen(RecipeBookMenu container, Inventory playerInventory, Component displayName) {
        super((AbstractContainerMenu)container, playerInventory, displayName);
        this.container = container;
        this.noIngredients = I18n.m_118938_((String)"gui.cookingforblockheads:no_ingredients", (Object[])new Object[0]).split("\\\\n");
        this.noSelection = I18n.m_118938_((String)"gui.cookingforblockheads:no_selection", (Object[])new Object[0]).split("\\\\n");
    }

    protected void m_7856_() {
        this.f_97727_ = 174;
        super.m_7856_();
        this.f_96541_.f_91068_.m_90926_(true);
        this.btnPrevRecipe = new Button(this.f_96543_ / 2 - 79, this.f_96544_ / 2 - 51, 13, 20, (Component)new TextComponent("<"), it -> this.container.nextSubRecipe(-1));
        this.btnPrevRecipe.f_93624_ = false;
        this.m_142416_((GuiEventListener)this.btnPrevRecipe);
        this.btnNextRecipe = new Button(this.f_96543_ / 2 - 9, this.f_96544_ / 2 - 51, 13, 20, (Component)new TextComponent(">"), it -> this.container.nextSubRecipe(1));
        this.btnNextRecipe.f_93624_ = false;
        this.m_142416_((GuiEventListener)this.btnNextRecipe);
        this.searchBar = new EditBox(this.f_96541_.f_91062_, this.f_97735_ + this.f_97726_ - 78, this.f_97736_ - 5, 70, 10, this.searchBar, (Component)new TextComponent(""));
        this.m_94718_((GuiEventListener)this.searchBar);
        int yOffset = -80;
        for (ISortButton button : CookingRegistry.getSortButtons()) {
            SortButton sortButton = new SortButton(this.f_96543_ / 2 + 87, this.f_96544_ / 2 + yOffset, button, it -> this.container.setSortComparator(((SortButton)it).getComparator((Player)Minecraft.m_91087_().f_91074_)));
            this.m_142416_((GuiEventListener)sortButton);
            this.sortButtons.add(sortButton);
            yOffset += 20;
        }
        this.recalculateScrollBar();
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (delta == 0.0) {
            return false;
        }
        if (this.container.getSelection() != null && mouseX >= (double)(this.f_97735_ + 7) && mouseY >= (double)(this.f_97736_ + 17) && mouseX < (double)(this.f_97735_ + 92) && mouseY < (double)(this.f_97736_ + 95)) {
            Slot slot = ((AbstractContainerScreenAccessor)this).getHoveredSlot();
            if (slot instanceof CraftMatrixFakeSlot && ((CraftMatrixFakeSlot)slot).getVisibleStacks().size() > 1) {
                ((CraftMatrixFakeSlot)slot).scrollDisplayList(delta > 0.0 ? -1 : 1);
            }
        } else {
            this.setCurrentOffset(delta > 0.0 ? this.currentOffset - 1 : this.currentOffset + 1);
        }
        return true;
    }

    public boolean m_6348_(double mouseX, double mouseY, int state) {
        boolean result = super.m_6348_(mouseX, mouseY, state);
        if (state != -1 && this.mouseClickY != -1.0) {
            this.mouseClickY = -1.0;
            this.indexWhenClicked = 0;
            this.lastNumberOfMoves = 0;
        }
        return result;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        Slot mouseSlot;
        super.m_6375_(mouseX, mouseY, button);
        if (button == 1 && mouseX >= (double)this.searchBar.f_93620_ && mouseX < (double)(this.searchBar.f_93620_ + this.searchBar.m_5711_()) && mouseY >= (double)this.searchBar.f_93621_ && mouseY < (double)(this.searchBar.f_93621_ + this.searchBar.m_93694_())) {
            this.searchBar.m_94144_("");
            this.container.search(null);
            this.container.populateRecipeSlots();
            this.setCurrentOffset(this.currentOffset);
            return true;
        }
        if (this.searchBar.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (mouseX >= (double)this.scrollBarXPos && mouseX <= (double)(this.scrollBarXPos + 7) && mouseY >= (double)this.scrollBarYPos && mouseY <= (double)(this.scrollBarYPos + this.scrollBarScaledHeight)) {
            this.mouseClickY = mouseY;
            this.indexWhenClicked = this.currentOffset;
        }
        if ((mouseSlot = ((AbstractContainerScreenAccessor)this).getHoveredSlot()) instanceof CraftMatrixFakeSlot) {
            if (button == 0) {
                ItemStack itemStack = mouseSlot.m_7993_();
                FoodRecipeWithStatus recipe = this.container.findAvailableRecipe(itemStack);
                if (recipe != null) {
                    this.container.setSelectedRecipe(recipe, false);
                    this.setCurrentOffset(this.container.getSelectedRecipeIndex());
                } else if (!CookingRegistry.getFoodRecipes(itemStack).isEmpty()) {
                    this.container.setSelectedRecipe(new FoodRecipeWithStatus(itemStack, RecipeStatus.MISSING_INGREDIENTS), true);
                }
            } else if (button == 1) {
                ((CraftMatrixFakeSlot)mouseSlot).setLocked(!((CraftMatrixFakeSlot)mouseSlot).isLocked());
            }
            return true;
        }
        return false;
    }

    public boolean m_5534_(char c, int keyCode) {
        boolean result = super.m_5534_(c, keyCode);
        this.container.search(this.searchBar.m_94155_());
        this.container.populateRecipeSlots();
        this.setCurrentOffset(this.currentOffset);
        return result;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.f_96541_.f_91074_.m_6915_();
            return true;
        }
        if (this.searchBar.m_7933_(keyCode, scanCode, modifiers) || this.searchBar.m_93696_()) {
            this.container.search(this.searchBar.m_94155_());
            this.container.populateRecipeSlots();
            this.setCurrentOffset(this.currentOffset);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        int curY;
        int numberOfFiltersMoved;
        float pixelsPerFilter;
        if (this.container.isDirty()) {
            this.setCurrentOffset(this.currentOffset);
            this.container.setDirty(false);
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)guiTexture);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_ - 10, 0, 0, this.f_97726_, this.f_97727_ + 10);
        if (this.mouseClickY != -1.0 && (pixelsPerFilter = (float)(77 - this.scrollBarScaledHeight) / (float)Math.max(1, (int)Math.ceil((float)this.container.getItemListCount() / 3.0f) - 4)) != 0.0f && (numberOfFiltersMoved = (int)(((double)mouseY - this.mouseClickY) / (double)pixelsPerFilter)) != this.lastNumberOfMoves) {
            this.setCurrentOffset(this.indexWhenClicked + numberOfFiltersMoved);
            this.lastNumberOfMoves = numberOfFiltersMoved;
        }
        this.btnPrevRecipe.f_93624_ = this.container.hasVariants();
        this.btnPrevRecipe.f_93623_ = this.container.getSelectionIndex() > 0;
        this.btnNextRecipe.f_93624_ = this.container.hasVariants();
        this.btnNextRecipe.f_93623_ = this.container.getSelectionIndex() < this.container.getRecipeCount() - 1;
        boolean hasRecipes = this.container.getItemListCount() > 0;
        for (Button button : this.sortButtons) {
            button.f_93623_ = hasRecipes;
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Font fontRenderer = this.f_96541_.f_91062_;
        FoodRecipeWithIngredients foodRecipeWithIngredients = this.container.getSelection();
        if (foodRecipeWithIngredients == null) {
            int n = this.noSelection.length / 2;
            Objects.requireNonNull(fontRenderer);
            curY = this.f_97736_ + 39 - n * 9;
            for (String s : this.noSelection) {
                fontRenderer.m_92750_(poseStack, s, (float)(this.f_97735_ + 23 + 27) - (float)fontRenderer.m_92895_(s) / 2.0f, (float)curY, -1);
                Objects.requireNonNull(fontRenderer);
                curY += 9 + 5;
            }
        } else if (foodRecipeWithIngredients.getRecipeType() == FoodRecipeType.SMELTING) {
            this.m_93228_(poseStack, this.f_97735_ + 23, this.f_97736_ + 19, 54, 184, 54, 54);
        } else {
            this.m_93228_(poseStack, this.f_97735_ + 23, this.f_97736_ + 19, 0, 184, 54, 54);
        }
        if (foodRecipeWithIngredients != null) {
            for (CraftMatrixFakeSlot slot : this.container.getCraftingMatrixSlots()) {
                if (!slot.isLocked() || slot.getVisibleStacks().size() <= 1) continue;
                this.m_93228_(poseStack, this.f_97735_ + slot.f_40220_, this.f_97736_ + slot.f_40221_, 176, 60, 16, 16);
            }
        }
        RecipeBookScreen.m_93172_((PoseStack)poseStack, (int)this.scrollBarXPos, (int)this.scrollBarYPos, (int)(this.scrollBarXPos + 7), (int)(this.scrollBarYPos + this.scrollBarScaledHeight), (int)-5592406);
        if (this.container.getItemListCount() == 0) {
            RecipeBookScreen.m_93172_((PoseStack)poseStack, (int)(this.f_97735_ + 97), (int)(this.f_97736_ + 7), (int)(this.f_97735_ + 168), (int)(this.f_97736_ + 85), (int)-1440603614);
            int n = this.noIngredients.length / 2;
            Objects.requireNonNull(fontRenderer);
            curY = this.f_97736_ + 39 - n * 9;
            for (String s : this.noIngredients) {
                fontRenderer.m_92750_(poseStack, s, (float)(this.f_97735_ + 97 + 36) - (float)fontRenderer.m_92895_(s) / 2.0f, (float)curY, -1);
                Objects.requireNonNull(fontRenderer);
                curY += 9 + 5;
            }
        }
        this.searchBar.m_6303_(poseStack, mouseX, mouseY, partialTicks);
    }

    protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)guiTexture);
        if (CookingForBlockheadsConfig.getActive().showIngredientIcon) {
            int prevZLevel = this.m_93252_();
            this.m_93250_(300);
            for (Slot slot : this.container.f_38839_) {
                FoodRecipeWithStatus recipe;
                if (!(slot instanceof RecipeFakeSlot)) continue;
                if (CookingRegistry.isNonFoodRecipe(slot.m_7993_())) {
                    this.m_93228_(poseStack, slot.f_40220_, slot.f_40221_, 176, 76, 16, 16);
                }
                if ((recipe = ((RecipeFakeSlot)slot).getRecipe()) == null || recipe.getStatus() != RecipeStatus.MISSING_TOOLS) continue;
                this.m_93228_(poseStack, slot.f_40220_, slot.f_40221_, 176, 92, 16, 16);
            }
            this.m_93250_(prevZLevel);
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        int prevZLevel = this.m_93252_();
        this.m_93250_(300);
        for (Slot slot : this.container.f_38839_) {
            if (!(slot instanceof CraftMatrixFakeSlot) || ((CraftMatrixFakeSlot)slot).isAvailable() || slot.m_7993_().m_41619_()) continue;
            this.m_93179_(poseStack, this.f_97735_ + slot.f_40220_, this.f_97736_ + slot.f_40221_, this.f_97735_ + slot.f_40220_ + 16, this.f_97736_ + slot.f_40221_ + 16, 0x77FF4444, 0x77FF5555);
        }
        this.m_93250_(prevZLevel);
        this.container.updateSlots(partialTicks);
        for (Button button : this.sortButtons) {
            if (!(button instanceof SortButton) || !button.m_5953_((double)mouseX, (double)mouseY) || !button.f_93623_) continue;
            this.m_96597_(poseStack, ((SortButton)button).getTooltipLines(), mouseX, mouseY);
        }
        this.m_7025_(poseStack, mouseX, mouseY);
    }

    public void m_7379_() {
        super.m_7379_();
        this.f_96541_.f_91068_.m_90926_(false);
    }

    private void recalculateScrollBar() {
        int scrollBarTotalHeight = 76;
        this.scrollBarScaledHeight = (int)((double)scrollBarTotalHeight * Math.min(1.0, 4.0 / Math.ceil((float)this.container.getItemListCount() / 3.0f)));
        this.scrollBarXPos = this.f_97735_ + this.f_97726_ - 7 - 9;
        this.scrollBarYPos = this.f_97736_ + 8 + (scrollBarTotalHeight - this.scrollBarScaledHeight) * this.currentOffset / Math.max(1, (int)Math.ceil((float)this.container.getItemListCount() / 3.0f) - 4);
    }

    private void setCurrentOffset(int currentOffset) {
        this.currentOffset = Math.max(0, Math.min(currentOffset, (int)Math.ceil((float)this.container.getItemListCount() / 3.0f) - 4));
        this.container.setScrollOffset(this.currentOffset);
        this.recalculateScrollBar();
    }

    public Button[] getSortingButtons() {
        return this.sortButtons.toArray(new SortButton[0]);
    }
}

