/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.forge.integration.curios;

import com.google.common.collect.Multimap;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.client.ICurioRenderer;
import top.theillusivec4.curios.api.event.DropRulesEvent;
import top.theillusivec4.curios.api.type.capability.ICurio;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.common.item.ItemKeepIvy;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;
import vazkii.botania.common.proxy.IProxy;
import vazkii.botania.forge.CapabilityUtil;

public class CurioIntegration
extends EquipmentHandler {
    public static void init() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(CurioIntegration::sendImc);
        MinecraftForge.EVENT_BUS.addListener(CurioIntegration::keepCurioDrops);
    }

    public static void sendImc(InterModEnqueueEvent evt) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.CHARM.getMessageBuilder().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.RING.getMessageBuilder().size(2).build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BELT.getMessageBuilder().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BODY.getMessageBuilder().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.HEAD.getMessageBuilder().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.NECKLACE.getMessageBuilder().build());
    }

    public static void keepCurioDrops(DropRulesEvent event) {
        event.addOverride(stack -> {
            if (ItemKeepIvy.hasIvy(stack)) {
                stack.m_41749_("Botania_keepIvy");
                return true;
            }
            return false;
        }, ICurio.DropRule.ALWAYS_KEEP);
    }

    @Override
    protected Container getAllWornItems(LivingEntity living) {
        return CuriosApi.getCuriosHelper().getEquippedCurios(living).map(RecipeWrapper::new).orElseGet(() -> new SimpleContainer(0));
    }

    @Override
    protected ItemStack findItem(Item item, LivingEntity living) {
        return CuriosApi.getCuriosHelper().findFirstCurio(living, item).map(SlotResult::stack).orElse(ItemStack.f_41583_);
    }

    @Override
    protected ItemStack findItem(Predicate<ItemStack> pred, LivingEntity living) {
        return CuriosApi.getCuriosHelper().findFirstCurio(living, pred).map(SlotResult::stack).orElse(ItemStack.f_41583_);
    }

    public ICapabilityProvider initCapability(ItemStack stack) {
        return CapabilityUtil.makeProvider(CuriosCapability.ITEM, new Wrapper(stack));
    }

    @Override
    public void onInit(Item item) {
        IProxy.INSTANCE.runOnClient(() -> () -> CuriosRendererRegistry.register((Item)item, () -> Renderer.INSTANCE));
    }

    @Override
    public boolean isAccessory(ItemStack stack) {
        return super.isAccessory(stack) || stack.getCapability(CuriosCapability.ITEM).isPresent();
    }

    public static class Wrapper
    implements ICurio {
        private static final ICurio.SoundInfo SOUND_INFO = new ICurio.SoundInfo(ModSounds.equipBauble, 0.1f, 1.3f);
        private final ItemStack stack;

        Wrapper(ItemStack stack) {
            this.stack = stack;
        }

        private ItemBauble getItem() {
            return (ItemBauble)this.stack.m_41720_();
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public void curioTick(SlotContext slotContext) {
            this.getItem().onWornTick(this.stack, slotContext.entity());
        }

        public void onEquip(SlotContext slotContext, ItemStack previousStack) {
            this.getItem().onEquipped(this.stack, slotContext.entity());
        }

        public void onUnequip(SlotContext slotContext, ItemStack newStack) {
            this.getItem().onUnequipped(this.stack, slotContext.entity());
        }

        public boolean canEquip(SlotContext slotContext) {
            return this.getItem().canEquip(this.stack, slotContext.entity());
        }

        public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid) {
            return this.getItem().getEquippedAttributeModifiers(this.stack);
        }

        public boolean canSync(SlotContext slotContext) {
            return true;
        }

        @NotNull
        public ICurio.SoundInfo getEquipSound(SlotContext slotContext) {
            return SOUND_INFO;
        }

        public boolean canEquipFromUse(SlotContext slotContext) {
            return true;
        }
    }

    private static class Renderer
    implements ICurioRenderer {
        private static final Renderer INSTANCE = new Renderer();

        private Renderer() {
        }

        public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            LivingEntity livingEntity = slotContext.entity();
            EntityModel contextModel = renderLayerParent.m_7200_();
            ItemBauble item = (ItemBauble)stack.m_41720_();
            if (!item.hasRender(stack, livingEntity)) {
                return;
            }
            if (!(contextModel instanceof HumanoidModel)) {
                return;
            }
            matrixStack.m_85836_();
            ItemStack cosmetic = item.getCosmeticItem(stack);
            if (!cosmetic.m_41619_()) {
                CuriosRendererRegistry.getRenderer((Item)item).ifPresent(curio -> curio.render(cosmetic, slotContext, matrixStack, renderLayerParent, renderTypeBuffer, light, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch));
            } else {
                AccessoryRenderer renderer = AccessoryRenderRegistry.get(stack);
                if (renderer != null) {
                    renderer.doRender((HumanoidModel)contextModel, stack, livingEntity, matrixStack, renderTypeBuffer, light, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                }
            }
            matrixStack.m_85849_();
        }
    }
}

