/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.helper.MathHelper;

public class SubTileVinculotus
extends TileEntityFunctionalFlower {
    public static final Set<SubTileVinculotus> existingFlowers = Collections.newSetFromMap(new WeakHashMap());
    private static final int RANGE = 64;

    public SubTileVinculotus(BlockPos pos, BlockState state) {
        super(ModSubtiles.VINCULOTUS, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (!this.m_58904_().f_46443_) {
            existingFlowers.add(this);
        }
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Circle(this.getEffectivePos(), 64.0);
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public int getColor() {
        return 680017;
    }

    @Override
    public int getMaxMana() {
        return 500;
    }

    @Nullable
    public static Vec3 onEndermanTeleport(EnderMan entity, double targetX, double targetY, double targetZ) {
        int cost = 50;
        ArrayList<SubTileVinculotus> possibleFlowers = new ArrayList<SubTileVinculotus>();
        for (SubTileVinculotus flower : existingFlowers) {
            double z;
            double y;
            double x;
            BlockPos activePos = flower.getEffectivePos();
            if (flower.redstoneSignal > 0 || flower.getMana() <= cost || flower.m_58904_() != entity.f_19853_ || flower.m_58904_().m_7702_(flower.m_58899_()) != flower || !(MathHelper.pointDistanceSpace(x = (double)activePos.m_123341_() + 0.5, y = (double)activePos.m_123342_() + 1.5, z = (double)activePos.m_123343_() + 0.5, targetX, targetY, targetZ) < 64.0f)) continue;
            possibleFlowers.add(flower);
        }
        if (!possibleFlowers.isEmpty()) {
            SubTileVinculotus flower = (SubTileVinculotus)possibleFlowers.get(entity.f_19853_.f_46441_.nextInt(possibleFlowers.size()));
            BlockPos activePos = flower.getEffectivePos();
            double x = (double)activePos.m_123341_() + 0.5;
            double y = (double)activePos.m_123342_() + 1.5;
            double z = (double)activePos.m_123343_() + 0.5;
            flower.addMana(-cost);
            flower.sync();
            return new Vec3(x + Math.random() * 3.0 - 1.0, y, z + Math.random() * 3.0 - 1.0);
        }
        return null;
    }
}

