/*
 * Decompiled with CFR 0.152.
 */
package cofh.toolscomplement.init;

import cofh.core.item.ArmorItemCoFH;
import cofh.core.item.ExcavatorItem;
import cofh.core.item.HammerItem;
import cofh.core.item.KnifeItem;
import cofh.core.item.SickleItem;
import cofh.lib.item.ArmorMaterialCoFH;
import cofh.lib.item.AxeItemCoFH;
import cofh.lib.item.HoeItemCoFH;
import cofh.lib.item.ItemTierCoFH;
import cofh.lib.item.PickaxeItemCoFH;
import cofh.lib.item.ShovelItemCoFH;
import cofh.lib.item.SwordItemCoFH;
import cofh.lib.tags.ItemTagsCoFH;
import cofh.lib.util.helpers.MathHelper;
import cofh.toolscomplement.ToolsComplement;
import cofh.toolscomplement.init.TComFlags;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.Tags;

public class TComItems {
    public static final Tier TOOL_MATERIAL_COPPER = new ItemTierCoFH(1, 160, 4.5f, 1.5f, 9, () -> Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_COPPER));
    public static final Tier TOOL_MATERIAL_TIN = new ItemTierCoFH(0, 16, 13.0f, 0.0f, 18, () -> Ingredient.m_204132_((TagKey)ItemTagsCoFH.INGOTS_TIN));
    public static final Tier TOOL_MATERIAL_LEAD = new ItemTierCoFH(1, 32, 12.0f, 1.0f, 16, () -> Ingredient.m_204132_((TagKey)ItemTagsCoFH.INGOTS_LEAD));
    public static final Tier TOOL_MATERIAL_SILVER = new ItemTierCoFH(0, 24, 14.0f, 0.0f, 30, () -> Ingredient.m_204132_((TagKey)ItemTagsCoFH.INGOTS_SILVER));
    public static final Tier TOOL_MATERIAL_NICKEL = new ItemTierCoFH(2, 225, 7.0f, 2.5f, 12, () -> Ingredient.m_204132_((TagKey)ItemTagsCoFH.INGOTS_NICKEL));
    public static final Tier TOOL_MATERIAL_BRONZE = new ItemTierCoFH(2, 325, 5.5f, 2.0f, 16, () -> Ingredient.m_204132_((TagKey)ItemTagsCoFH.INGOTS_BRONZE));
    public static final Tier TOOL_MATERIAL_ELECTRUM = new ItemTierCoFH(0, 96, 13.0f, 0.0f, 28, () -> Ingredient.m_204132_((TagKey)ItemTagsCoFH.INGOTS_ELECTRUM));
    public static final Tier TOOL_MATERIAL_INVAR = new ItemTierCoFH(2, 300, 7.0f, 2.5f, 13, () -> Ingredient.m_204132_((TagKey)ItemTagsCoFH.INGOTS_INVAR));
    public static final Tier TOOL_MATERIAL_CONSTANTAN = new ItemTierCoFH(1, 250, 5.5f, 2.0f, 10, () -> Ingredient.m_204132_((TagKey)ItemTagsCoFH.INGOTS_CONSTANTAN));
    public static ArmorMaterialCoFH armorMaterialCopper;
    public static ArmorMaterialCoFH armorMaterialTin;
    public static ArmorMaterialCoFH armorMaterialLead;
    public static ArmorMaterialCoFH armorMaterialSilver;
    public static ArmorMaterialCoFH armorMaterialNickel;
    public static ArmorMaterialCoFH armorMaterialBronze;
    public static ArmorMaterialCoFH armorMaterialElectrum;
    public static ArmorMaterialCoFH armorMaterialInvar;
    public static ArmorMaterialCoFH armorMaterialConstantan;

    private TComItems() {
    }

    public static void register() {
        armorMaterialCopper = new ArmorMaterialCoFH("tools_complement:copper", 7, new int[]{1, 3, 4, 1}, 11, SoundEvents.f_11677_, 0.0f, 0.0f, () -> Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_COPPER));
        armorMaterialTin = new ArmorMaterialCoFH("tools_complement:tin", 8, new int[]{1, 3, 4, 1}, 20, SoundEvents.f_11677_, 0.0f, 0.0f, () -> Ingredient.m_204132_((TagKey)ItemTagsCoFH.INGOTS_TIN));
        armorMaterialLead = new ArmorMaterialCoFH("tools_complement:lead", 12, new int[]{2, 4, 5, 2}, 18, SoundEvents.f_11677_, 0.0f, 0.0f, () -> Ingredient.m_204132_((TagKey)ItemTagsCoFH.INGOTS_LEAD));
        armorMaterialSilver = new ArmorMaterialCoFH("tools_complement:silver", 6, new int[]{1, 3, 5, 2}, 32, SoundEvents.f_11676_, 0.0f, 0.0f, () -> Ingredient.m_204132_((TagKey)ItemTagsCoFH.INGOTS_SILVER));
        armorMaterialNickel = new ArmorMaterialCoFH("tools_complement:nickel", 14, new int[]{2, 5, 5, 2}, 14, SoundEvents.f_11677_, 0.0f, 0.0f, () -> Ingredient.m_204132_((TagKey)ItemTagsCoFH.INGOTS_NICKEL));
        armorMaterialBronze = new ArmorMaterialCoFH("tools_complement:bronze", 16, new int[]{2, 5, 6, 2}, 18, SoundEvents.f_11677_, 0.0f, 0.0f, () -> Ingredient.m_204132_((TagKey)ItemTagsCoFH.INGOTS_BRONZE));
        armorMaterialElectrum = new ArmorMaterialCoFH("tools_complement:electrum", 7, new int[]{1, 3, 5, 2}, 30, SoundEvents.f_11676_, 0.0f, 0.0f, () -> Ingredient.m_204132_((TagKey)ItemTagsCoFH.INGOTS_ELECTRUM));
        armorMaterialInvar = new ArmorMaterialCoFH("tools_complement:invar", 15, new int[]{2, 5, 7, 2}, 15, SoundEvents.f_11677_, 0.0f, 0.0f, () -> Ingredient.m_204132_((TagKey)ItemTagsCoFH.INGOTS_INVAR));
        armorMaterialConstantan = new ArmorMaterialCoFH("tools_complement:constantan", 8, new int[]{1, 4, 4, 2}, 12, SoundEvents.f_11677_, 0.0f, 0.0f, () -> Ingredient.m_204132_((TagKey)ItemTagsCoFH.INGOTS_CONSTANTAN));
        CreativeModeTab combat = CreativeModeTab.f_40757_;
        CreativeModeTab tools = CreativeModeTab.f_40756_;
        TComItems.registerExtraToolSet("iron", (Tier)Tiers.IRON, tools, combat);
        TComItems.registerExtraToolSet("gold", (Tier)Tiers.GOLD, tools, combat);
        TComItems.registerExtraToolSet("diamond", (Tier)Tiers.DIAMOND, tools, combat);
        TComItems.registerExtraToolSet("netherite", (Tier)Tiers.NETHERITE, tools, combat);
        TComItems.registerFullToolSet("copper", TOOL_MATERIAL_COPPER, tools, combat);
        TComItems.registerFullToolSet("tin", TOOL_MATERIAL_TIN, tools, combat);
        TComItems.registerFullToolSet("lead", TOOL_MATERIAL_LEAD, tools, combat);
        TComItems.registerFullToolSet("silver", TOOL_MATERIAL_SILVER, tools, combat);
        TComItems.registerFullToolSet("nickel", TOOL_MATERIAL_NICKEL, tools, combat);
        TComItems.registerFullToolSet("bronze", TOOL_MATERIAL_BRONZE, tools, combat);
        TComItems.registerFullToolSet("electrum", TOOL_MATERIAL_ELECTRUM, tools, combat);
        TComItems.registerFullToolSet("invar", TOOL_MATERIAL_INVAR, tools, combat);
        TComItems.registerFullToolSet("constantan", TOOL_MATERIAL_CONSTANTAN, tools, combat);
        TComItems.registerArmorSet("copper", (ArmorMaterial)armorMaterialCopper, combat);
        TComItems.registerArmorSet("tin", (ArmorMaterial)armorMaterialTin, combat);
        TComItems.registerArmorSet("lead", (ArmorMaterial)armorMaterialLead, combat);
        TComItems.registerArmorSet("silver", (ArmorMaterial)armorMaterialSilver, combat);
        TComItems.registerArmorSet("nickel", (ArmorMaterial)armorMaterialNickel, combat);
        TComItems.registerArmorSet("bronze", (ArmorMaterial)armorMaterialBronze, combat);
        TComItems.registerArmorSet("electrum", (ArmorMaterial)armorMaterialElectrum, combat);
        TComItems.registerArmorSet("invar", (ArmorMaterial)armorMaterialInvar, combat);
        TComItems.registerArmorSet("constantan", (ArmorMaterial)armorMaterialConstantan, combat);
    }

    private static void registerFullToolSet(String prefix, Tier tier, CreativeModeTab toolGroup, CreativeModeTab combatGroup) {
        TComItems.registerStandardToolSet(prefix, tier, toolGroup, combatGroup);
        TComItems.registerExtraToolSet(prefix, tier, toolGroup, combatGroup);
    }

    private static void registerStandardToolSet(String prefix, Tier tier, CreativeModeTab toolGroup, CreativeModeTab combatGroup) {
        ToolsComplement.ITEMS.register(prefix + "_shovel", () -> new ShovelItemCoFH(tier, 1.5f, -3.0f, new Item.Properties().m_41491_(toolGroup)).setDisplayGroup(() -> ToolsComplement.itemGroup).setShowInGroups(TComFlags.getFlag(prefix + "_tools")));
        ToolsComplement.ITEMS.register(prefix + "_pickaxe", () -> new PickaxeItemCoFH(tier, 1, -2.8f, new Item.Properties().m_41491_(toolGroup)).setDisplayGroup(() -> ToolsComplement.itemGroup).setShowInGroups(TComFlags.getFlag(prefix + "_tools")));
        ToolsComplement.ITEMS.register(prefix + "_axe", () -> new AxeItemCoFH(tier, tier.m_6631_() > 0.0f ? 8.0f - tier.m_6631_() : 6.0f, MathHelper.clamp((float)(-3.7f + tier.m_6624_() / 10.0f), (float)-3.2f, (float)-3.0f), new Item.Properties().m_41491_(toolGroup)).setDisplayGroup(() -> ToolsComplement.itemGroup).setShowInGroups(TComFlags.getFlag(prefix + "_tools")));
        ToolsComplement.ITEMS.register(prefix + "_hoe", () -> new HoeItemCoFH(tier, -tier.m_6604_(), Math.min(-3.0f + (float)tier.m_6604_(), 0.0f), new Item.Properties().m_41491_(toolGroup)).setDisplayGroup(() -> ToolsComplement.itemGroup).setShowInGroups(TComFlags.getFlag(prefix + "_tools")));
        ToolsComplement.ITEMS.register(prefix + "_sword", () -> new SwordItemCoFH(tier, 3, -2.4f, new Item.Properties().m_41491_(combatGroup)).setDisplayGroup(() -> ToolsComplement.itemGroup).setShowInGroups(TComFlags.getFlag(prefix + "_tools")));
    }

    private static void registerExtraToolSet(String prefix, Tier tier, CreativeModeTab toolGroup, CreativeModeTab combatGroup) {
        ToolsComplement.ITEMS.register(prefix + "_excavator", () -> new ExcavatorItem(tier, new Item.Properties().m_41491_(toolGroup)).setDisplayGroup(() -> ToolsComplement.itemGroup).setShowInGroups(TComFlags.getFlag(prefix + "_tools")));
        ToolsComplement.ITEMS.register(prefix + "_hammer", () -> new HammerItem(tier, new Item.Properties().m_41491_(toolGroup)).setDisplayGroup(() -> ToolsComplement.itemGroup).setShowInGroups(TComFlags.getFlag(prefix + "_tools")));
        ToolsComplement.ITEMS.register(prefix + "_sickle", () -> new SickleItem(tier, new Item.Properties().m_41491_(toolGroup)).setDisplayGroup(() -> ToolsComplement.itemGroup).setShowInGroups(TComFlags.getFlag(prefix + "_tools")));
        ToolsComplement.ITEMS.register(prefix + "_knife", () -> new KnifeItem(tier, new Item.Properties().m_41491_(combatGroup)).setDisplayGroup(() -> ToolsComplement.itemGroup).setShowInGroups(TComFlags.getFlag(prefix + "_tools")));
    }

    private static void registerArmorSet(String prefix, ArmorMaterial material, CreativeModeTab armorGroup) {
        ToolsComplement.ITEMS.register(prefix + "_helmet", () -> new ArmorItemCoFH(material, EquipmentSlot.HEAD, new Item.Properties().m_41491_(armorGroup)).setDisplayGroup(() -> ToolsComplement.itemGroup).setShowInGroups(TComFlags.getFlag(prefix + "_armor")));
        ToolsComplement.ITEMS.register(prefix + "_chestplate", () -> new ArmorItemCoFH(material, EquipmentSlot.CHEST, new Item.Properties().m_41491_(armorGroup)).setDisplayGroup(() -> ToolsComplement.itemGroup).setShowInGroups(TComFlags.getFlag(prefix + "_armor")));
        ToolsComplement.ITEMS.register(prefix + "_leggings", () -> new ArmorItemCoFH(material, EquipmentSlot.LEGS, new Item.Properties().m_41491_(armorGroup)).setDisplayGroup(() -> ToolsComplement.itemGroup).setShowInGroups(TComFlags.getFlag(prefix + "_armor")));
        ToolsComplement.ITEMS.register(prefix + "_boots", () -> new ArmorItemCoFH(material, EquipmentSlot.FEET, new Item.Properties().m_41491_(armorGroup)).setDisplayGroup(() -> ToolsComplement.itemGroup).setShowInGroups(TComFlags.getFlag(prefix + "_armor")));
    }
}

